/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThirdPartyHelper
implements ThirdPartyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultThirdPartyHelper.class);
    private final DependenciesTool dependenciesTool;
    private final ThirdPartyTool thirdPartyTool;
    private final List<ArtifactRepository> remoteRepositoriesCoreApi;
    private final List<RemoteRepository> remoteRepositories;
    private final MavenProject project;
    private final String encoding;
    private final boolean verbose;
    private static final SortedMap<String, MavenProject> ARTIFACT_CACHE = new ConcurrentSkipListMap<String, MavenProject>();

    public DefaultThirdPartyHelper(MavenProject project, String encoding, boolean verbose, DependenciesTool dependenciesTool, ThirdPartyTool thirdPartyTool, List<ArtifactRepository> remoteRepositoriesCoreApi, List<RemoteRepository> remoteRepositories) {
        this.project = project;
        this.encoding = encoding;
        this.verbose = verbose;
        this.dependenciesTool = dependenciesTool;
        this.thirdPartyTool = thirdPartyTool;
        this.remoteRepositoriesCoreApi = remoteRepositoriesCoreApi;
        this.remoteRepositories = remoteRepositories;
        this.thirdPartyTool.setVerbose(verbose);
    }

    @Override
    public SortedMap<String, MavenProject> getArtifactCache() {
        return ARTIFACT_CACHE;
    }

    @Override
    public SortedMap<String, MavenProject> loadDependencies(MavenProjectDependenciesConfigurator configuration, ResolvedProjectDependencies dependencyArtifacts) {
        return this.dependenciesTool.loadProjectDependencies(dependencyArtifacts, configuration, this.remoteRepositoriesCoreApi, this.getArtifactCache());
    }

    @Override
    public SortedProperties loadThirdPartyDescriptorForUnsafeMapping(Set<Artifact> topLevelDependencies, SortedSet<MavenProject> unsafeDependencies, Collection<MavenProject> projects, LicenseMap licenseMap) throws ThirdPartyToolException, IOException {
        return this.thirdPartyTool.loadThirdPartyDescriptorsForUnsafeMapping(topLevelDependencies, this.encoding, projects, unsafeDependencies, licenseMap, this.remoteRepositories);
    }

    @Override
    public SortedProperties loadUnsafeMapping(LicenseMap licenseMap, File missingFile, String missingFileUrl, SortedMap<String, MavenProject> projectDependencies) throws IOException, MojoExecutionException {
        return this.thirdPartyTool.loadUnsafeMapping(licenseMap, projectDependencies, this.encoding, missingFile, missingFileUrl);
    }

    @Override
    public LicenseMap createLicenseMap(SortedMap<String, MavenProject> dependencies) {
        LicenseMap licenseMap = new LicenseMap();
        for (MavenProject project : dependencies.values()) {
            this.thirdPartyTool.addLicense(licenseMap, project, project.getLicenses());
        }
        return licenseMap;
    }

    @Override
    public void attachThirdPartyDescriptor(File file) {
        this.thirdPartyTool.attachThirdPartyDescriptor(this.project, file);
    }

    @Override
    public SortedSet<MavenProject> getProjectsWithNoLicense(LicenseMap licenseMap) {
        return this.thirdPartyTool.getProjectsWithNoLicense(licenseMap);
    }

    @Override
    public SortedProperties createUnsafeMapping(LicenseMap licenseMap, File missingFile, String missingFileUrl, boolean useRepositoryMissingFiles, SortedSet<MavenProject> unsafeDependencies, SortedMap<String, MavenProject> projectDependencies, Set<Artifact> dependencyArtifacts) throws ProjectBuildingException, IOException, ThirdPartyToolException, MojoExecutionException {
        SortedProperties unsafeMappings = this.loadUnsafeMapping(licenseMap, missingFile, missingFileUrl, projectDependencies);
        if (CollectionUtils.isNotEmpty(unsafeDependencies) && useRepositoryMissingFiles) {
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>(projectDependencies.values());
            projects.remove(this.project);
            projects.removeAll(unsafeDependencies);
            SortedProperties resolvedUnsafeMapping = this.loadThirdPartyDescriptorForUnsafeMapping(dependencyArtifacts, unsafeDependencies, projects, licenseMap);
            for (Object coord : resolvedUnsafeMapping.keySet()) {
                String s = (String)coord;
                if (!projectDependencies.containsKey(s)) continue;
                unsafeMappings.put(s, resolvedUnsafeMapping.get(s));
            }
        }
        return unsafeMappings;
    }

    @Override
    public void mergeLicenses(List<String> licenseMerges, LicenseMap licenseMap) throws MojoFailureException {
        HashSet<String> licenseFound = new HashSet<String>();
        if (!CollectionUtils.isEmpty(licenseMerges)) {
            HashMap<String, Set<String>> mergedLicenses = new HashMap<String, Set<String>>();
            for (String string : licenseMerges) {
                String string2 = string.trim();
                String[] split = string2.split("\\s*\\|\\s*");
                String mainLicense = split[0];
                Set mergeList = mergedLicenses.containsKey(mainLicense) ? (Set)mergedLicenses.get(mainLicense) : new HashSet();
                for (int i = 0; i < split.length; ++i) {
                    String licenseToAdd = split[i];
                    if (i == 0) continue;
                    if (mergeList.contains(licenseToAdd) || licenseFound.contains(licenseToAdd) || mainLicense.equals(licenseToAdd)) {
                        throw new MojoFailureException("The license " + licenseToAdd + " was already registered in the configuration, please use only one such entry as described in the example http://mojohaus.org/license-maven-plugin/examples/example-thirdparty.html#Merge_licenses");
                    }
                    mergeList.add(licenseToAdd);
                    licenseFound.add(licenseToAdd);
                }
                mergedLicenses.put(mainLicense, mergeList);
            }
            for (Map.Entry entry : mergedLicenses.entrySet()) {
                String mainLicense = (String)entry.getKey();
                Set mergedLicense = (Set)entry.getValue();
                if (this.verbose) {
                    LOG.info("Will merge to '{}', licenses: {}", (Object)mainLicense, (Object)mergedLicense);
                }
                this.thirdPartyTool.mergeLicenses(licenseMap, mainLicense, mergedLicense);
            }
        }
    }
}

