/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.ArtifactHelper;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.LicenseDownloader;
import org.codehaus.mojo.license.LicenseSummaryReader;
import org.codehaus.mojo.license.LicenseSummaryWriter;
import org.codehaus.mojo.license.MavenProjectDependenciesLoader;
import org.codehaus.mojo.license.model.ProjectLicenseInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadLicensesMojo
extends AbstractMojo
implements MavenProjectDependenciesLoader {
    private MavenProject project;
    private MavenProjectBuilder projectBuilder;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private File licensesConfigFile;
    private File licensesOutputDirectory;
    private File licensesOutputFile;
    private boolean quiet;
    private boolean includeTransitiveDependencies;
    private Set<String> downloadedLicenseURLs = new HashSet<String>();

    public void execute() throws MojoExecutionException {
        this.initDirectories();
        HashMap<String, ProjectLicenseInfo> configuredDepLicensesMap = new HashMap<String, ProjectLicenseInfo>();
        this.loadLicenseInfo(configuredDepLicensesMap, this.licensesOutputFile, true);
        this.loadLicenseInfo(configuredDepLicensesMap, this.licensesConfigFile, false);
        SortedMap<String, MavenProject> dependencies = ArtifactHelper.loadProjectDependencies(this, this.getLog(), null);
        ArrayList<ProjectLicenseInfo> depProjectLicenses = new ArrayList<ProjectLicenseInfo>();
        for (MavenProject project : dependencies.values()) {
            Artifact artifact = project.getArtifact();
            this.getLog().debug((CharSequence)("Checking licenses for project " + artifact));
            String artifactProjectId = this.getArtifactProjectId(artifact);
            ProjectLicenseInfo depProject = null;
            if (configuredDepLicensesMap.containsKey(artifactProjectId)) {
                depProject = (ProjectLicenseInfo)configuredDepLicensesMap.get(artifactProjectId);
                depProject.setVersion(artifact.getVersion());
            } else {
                try {
                    depProject = this.createDependencyProject(project);
                }
                catch (ProjectBuildingException e) {
                    this.getLog().warn((CharSequence)("Unable to build project: " + artifact));
                    this.getLog().warn((Throwable)e);
                }
            }
            this.downloadLicenses(depProject);
            depProjectLicenses.add(depProject);
        }
        try {
            LicenseSummaryWriter.writeLicenseSummary(depProjectLicenses, this.licensesOutputFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to write license summary file.", e);
        }
    }

    private void initDirectories() throws MojoExecutionException {
        try {
            FileUtil.createDirectoryIfNecessary(this.licensesOutputDirectory);
            FileUtil.createDirectoryIfNecessary(this.licensesOutputFile.getParentFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create a directory...", (Exception)e);
        }
    }

    private void loadLicenseInfo(Map<String, ProjectLicenseInfo> configuredDepLicensesMap, File licenseConfigFile, boolean previouslyDownloaded) throws MojoExecutionException {
        if (licenseConfigFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(licenseConfigFile);
                List<ProjectLicenseInfo> licensesList = LicenseSummaryReader.parseLicenseSummary(fis);
                for (ProjectLicenseInfo dep : licensesList) {
                    configuredDepLicensesMap.put(dep.getId(), dep);
                    if (!previouslyDownloaded) continue;
                    for (License license : dep.getLicenses()) {
                        this.downloadedLicenseURLs.add(license.getUrl());
                    }
                }
            }
            catch (Exception e) {
                try {
                    throw new MojoExecutionException("Unable to parse license summary output file.", e);
                }
                catch (Throwable throwable) {
                    FileUtil.tryClose(fis);
                    throw throwable;
                }
            }
            FileUtil.tryClose(fis);
        }
    }

    public String getArtifactProjectId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public ProjectLicenseInfo createDependencyProject(MavenProject depMavenProject) throws ProjectBuildingException {
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        for (Object license : licenses) {
            dependencyProject.addLicense((License)license);
        }
        return dependencyProject;
    }

    private String getLicenseFileName(License license) throws MalformedURLException {
        URL licenseUrl = new URL(license.getUrl());
        File licenseUrlFile = new File(licenseUrl.getPath());
        String licenseFileName = licenseUrlFile.getName();
        if (license.getName() != null) {
            licenseFileName = license.getName() + " - " + licenseUrlFile.getName();
        }
        String DEFAULT_EXTENSION = ".txt";
        int extensionIndex = licenseFileName.lastIndexOf(".");
        if (extensionIndex == -1 || extensionIndex > licenseFileName.length() - 3) {
            licenseFileName = licenseFileName + ".txt";
        }
        licenseFileName = licenseFileName.toLowerCase();
        return licenseFileName;
    }

    private void downloadLicenses(ProjectLicenseInfo depProject) {
        this.getLog().debug((CharSequence)("Downloading license(s) for project " + depProject));
        List<License> licenses = depProject.getLicenses();
        if (depProject.getLicenses() == null || depProject.getLicenses().isEmpty()) {
            if (!this.quiet) {
                this.getLog().warn((CharSequence)("No license information available for: " + depProject));
            }
            return;
        }
        for (License license : licenses) {
            try {
                String licenseFileName = this.getLicenseFileName(license);
                File licenseOutputFile = new File(this.licensesOutputDirectory, licenseFileName);
                if (licenseOutputFile.exists() || this.downloadedLicenseURLs.contains(license.getUrl())) continue;
                LicenseDownloader.downloadLicense(license.getUrl(), licenseOutputFile);
                this.downloadedLicenseURLs.add(license.getUrl());
            }
            catch (MalformedURLException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has an invalid license URL: " + license.getUrl()));
            }
            catch (FileNotFoundException e) {
                if (this.quiet) continue;
                this.getLog().warn((CharSequence)("POM for dependency " + depProject.toString() + " has a license URL that returns file not found: " + license.getUrl()));
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to retrieve license for dependency: " + depProject.toString()));
                this.getLog().warn((CharSequence)license.getUrl());
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public MavenProjectBuilder getMavenProjectBuilder() {
        return this.projectBuilder;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public List<String> getExcludeScopes() {
        return Collections.emptyList();
    }

    @Override
    public String getIncludedArtifacts() {
        return null;
    }

    @Override
    public String getIncludedGroups() {
        return null;
    }

    @Override
    public String getExcludedGroups() {
        return null;
    }

    @Override
    public String getExcludedArtifacts() {
        return null;
    }

    @Override
    public boolean isVerbose() {
        return !this.quiet;
    }
}

