/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.dependencies;

import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.extraenforcer.dependencies.AbstractResolveDependencies;
import org.eclipse.aether.RepositorySystem;

@Named(value="banCircularDependencies")
public class BanCircularDependencies
extends AbstractResolveDependencies {
    private final MavenProject project;
    private String message;

    @Inject
    public BanCircularDependencies(MavenSession session, RepositorySystem repositorySystem) {
        super(session, repositorySystem);
        this.project = session.getCurrentProject();
    }

    @Override
    protected void handleArtifacts(Set<Artifact> artifacts) throws EnforcerRuleException {
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("groupId: " + artifact.getGroupId() + this.project.getGroupId()));
            if (!artifact.getGroupId().equals(this.project.getGroupId())) continue;
            this.getLog().debug((CharSequence)("artifactId: " + artifact.getArtifactId() + " " + this.project.getArtifactId()));
            if (!artifact.getArtifactId().equals(this.project.getArtifactId())) continue;
            throw new EnforcerRuleException(this.getErrorMessage() + "\n  " + artifact.getGroupId() + ":" + artifact.getArtifactId() + "\n ");
        }
    }

    private String getErrorMessage() {
        if (this.message == null) {
            return "Circular Dependency found. Your project's groupId:artifactId combination must not exist in the list of direct or transitive dependencies.";
        }
        return this.message;
    }
}

