/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.encoding;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.freebsd.file.FileEncoding;

@Named(value="requireEncoding")
public class RequireEncoding
extends AbstractEnforcerRule {
    private static final String ISO_8859_15 = "ISO-8859-15";
    private String encoding = "";
    private String includes = "";
    private String excludes = "";
    private boolean useDefaultExcludes = true;
    private boolean failFast = true;
    private boolean acceptAsciiSubset = false;
    private boolean acceptIso8859Subset = false;
    private final MavenProject project;

    @Inject
    public RequireEncoding(MavenProject project) {
        this.project = project;
    }

    public void execute() throws EnforcerRuleException {
        try {
            if (StringUtils.isBlank((String)this.encoding)) {
                this.encoding = this.project.getProperties().getProperty("project.build.sourceEncoding", "");
            }
            HashSet<String> acceptedEncodings = new HashSet<String>(Collections.singletonList(this.encoding));
            if (this.encoding.equals(StandardCharsets.US_ASCII.name())) {
                this.getLog().warn((CharSequence)"Encoding US-ASCII is hard to detect. Use UTF-8 or ISO-8859-1");
            }
            if (this.acceptAsciiSubset && (this.encoding.equals(StandardCharsets.ISO_8859_1.name()) || this.encoding.equals(ISO_8859_15) || this.encoding.equals(StandardCharsets.UTF_8.name()))) {
                acceptedEncodings.add(StandardCharsets.US_ASCII.name());
            }
            if (this.acceptIso8859Subset && this.encoding.equals(ISO_8859_15)) {
                acceptedEncodings.add("ISO-8859-1");
            }
            String basedir = this.project.getBasedir().getAbsolutePath();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(basedir);
            if (StringUtils.isNotBlank((String)this.includes)) {
                ds.setIncludes(this.includes.split("[,|]"));
            }
            if (StringUtils.isNotBlank((String)this.excludes)) {
                ds.setExcludes(this.excludes.split("[,|]"));
            }
            if (this.useDefaultExcludes) {
                ds.addDefaultExcludes();
            }
            ds.scan();
            StringBuilder filesInMsg = new StringBuilder();
            for (String file : ds.getIncludedFiles()) {
                String fileEncoding = this.getEncoding(new File(basedir, file));
                this.getLog().debug(() -> file + "==>" + fileEncoding);
                if (fileEncoding == null || acceptedEncodings.contains(fileEncoding)) continue;
                filesInMsg.append(file);
                filesInMsg.append("==>");
                filesInMsg.append(fileEncoding);
                filesInMsg.append(System.lineSeparator());
                if (!this.failFast) continue;
                throw new EnforcerRuleException(filesInMsg.toString());
            }
            if (filesInMsg.length() > 0) {
                throw new EnforcerRuleException("Files not encoded in " + this.encoding + ":\n" + filesInMsg);
            }
        }
        catch (IOException ex) {
            throw new EnforcerRuleError("Reading Files", (Throwable)ex);
        }
    }

    protected String getEncoding(File file) throws IOException {
        FileEncoding fileEncoding = new FileEncoding();
        if (!fileEncoding.guessFileEncoding(Files.readAllBytes(file.toPath()))) {
            return null;
        }
        this.getLog().debug(() -> String.format("%s: (%s) %s; charset=%s", file, fileEncoding.getCode(), fileEncoding.getType(), fileEncoding.getCodeMime()));
        return fileEncoding.getCodeMime().toUpperCase();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

