/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codehaus.mojo.chronos.common.IOUtil;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSampleGroup;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSamples;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupedResponsetimeSamples
extends ResponsetimeSamples {
    private static final String GROUPEDRESPONSETIMESAMPLES_TAG = "groupedresponsetimesamples";
    private static final String SUCCEEDED_ATTRIBUTE = "succeeded";
    private static final String GROUP_TAG = "responsetimesamplegroup";
    private final SortedMap<String, ResponsetimeSampleGroup> sampleGroupsByName = new TreeMap<String, ResponsetimeSampleGroup>();

    public GroupedResponsetimeSamples() {
    }

    public GroupedResponsetimeSamples(Document doc) {
        String rootElementName = doc.getRootElement().getName();
        if (!rootElementName.equals(GROUPEDRESPONSETIMESAMPLES_TAG)) {
            String message = "Unexpected rootelement: " + rootElementName;
            throw new IllegalArgumentException(message);
        }
        Element xml = doc.getRootElement();
        this.succeeded = Integer.parseInt(xml.getAttributeValue(SUCCEEDED_ATTRIBUTE));
        List groups = xml.getChildren(GROUP_TAG);
        for (Element gXml : groups) {
            ResponsetimeSampleGroup rsg = ResponsetimeSampleGroup.fromXml(gXml);
            this.addGroup(rsg);
        }
    }

    public void addAll(GroupedResponsetimeSamples other) {
        for (ResponsetimeSampleGroup group : other.getSampleGroups()) {
            this.addGroup(group);
        }
    }

    private void addGroup(ResponsetimeSampleGroup group) {
        String groupName = group.getName();
        this.getSampleGroup(groupName).addAll(group);
        this.addAll(group);
    }

    private ResponsetimeSamples getSampleGroup(String sampleName) {
        ResponsetimeSampleGroup sampleGroup = (ResponsetimeSampleGroup)this.sampleGroupsByName.get(sampleName);
        if (sampleGroup == null) {
            sampleGroup = new ResponsetimeSampleGroup(sampleName);
            this.sampleGroupsByName.put(sampleName, sampleGroup);
        }
        return sampleGroup;
    }

    public List<ResponsetimeSampleGroup> getSampleGroups() {
        return new ArrayList<ResponsetimeSampleGroup>(this.sampleGroupsByName.values());
    }

    public static GroupedResponsetimeSamples fromXmlFile(File file) throws JDOMException, IOException {
        IOUtil.copyDTDToDir("chronos-responsetimesamples.dtd", file.getParentFile());
        Document doc = new SAXBuilder().build(file);
        return new GroupedResponsetimeSamples(doc);
    }
}

