/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.resolver.bod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionException;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionManager;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionRequest;
import org.codehaus.mojo.resolver.bod.binary.BinaryDependencyManager;
import org.codehaus.mojo.resolver.bod.build.DependencyBuilder;
import org.codehaus.mojo.resolver.bod.pom.DependencyPOMResolver;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildOnDemandResolutionManager
implements BuildOnDemandResolutionManager {
    public static final String ROLE_HINT = "default";
    public static final String SNAPSHOT_PARENT_ARTIFACT_ID = "cpkg-projects";
    private DependencyPOMResolver pomResolver;
    private DependencyBuilder dependencyBuilder;
    private BinaryDependencyManager binaryDependencyManager;

    public DefaultBuildOnDemandResolutionManager() {
    }

    public DefaultBuildOnDemandResolutionManager(DependencyPOMResolver pomResolver) {
        this.pomResolver = pomResolver;
    }

    @Override
    public void resolveDependencies(BuildOnDemandResolutionRequest request) throws BuildOnDemandResolutionException {
        Set<String> completedBuilds = request.getCompletedBuilds();
        if (completedBuilds == null) {
            completedBuilds = new HashSet<String>();
        }
        ArtifactRepository localRepository = request.getLocalRepository();
        List<MavenProject> missingDependencyProjects = this.pomResolver.resolveDependencyPoms(request.getProject(), request.getCurrentPendingProjects(), localRepository, completedBuilds);
        missingDependencyProjects = this.orderDependencyProjects(missingDependencyProjects);
        if (request.useBinaryOnlyMode() || request.useBuildOnDemandMode()) {
            this.binaryDependencyManager.findDependenciesWithMissingBinaries(missingDependencyProjects, localRepository);
        }
        if (request.useBuildOnDemandMode() || request.useSourceOnlyMode()) {
            this.dependencyBuilder.buildDependencies(missingDependencyProjects, completedBuilds, request);
        }
        if (!missingDependencyProjects.isEmpty()) {
            throw new BuildOnDemandResolutionException(this.buildLeftoverDependencyMessage(missingDependencyProjects));
        }
    }

    private String buildLeftoverDependencyMessage(List<MavenProject> missingDependencyProjects) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Failed to resolve " + missingDependencyProjects.size() + " projects:");
        for (MavenProject project : missingDependencyProjects) {
            buffer.append("\n- ").append(project.getId());
        }
        return buffer.toString();
    }

    protected List<MavenProject> orderDependencyProjects(List<MavenProject> candidates) throws BuildOnDemandResolutionException {
        DAG dag = new DAG();
        if (candidates == null || candidates.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, MavenProject> projectMap = this.populateGraphVerticesAndProjectMap(dag, candidates);
        this.graphRelationships(dag, candidates);
        ArrayList<MavenProject> sortedProjects = new ArrayList<MavenProject>();
        for (String id : TopologicalSorter.sort((DAG)dag)) {
            sortedProjects.add(projectMap.get(id));
        }
        return sortedProjects;
    }

    protected void graphRelationships(DAG dag, List<MavenProject> candidates) throws BuildOnDemandResolutionException {
        for (MavenProject project : candidates) {
            String parentId;
            String id = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            for (Dependency dependency : project.getDependencies()) {
                String dependencyId = ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId());
                if (dag.getVertex(dependencyId) == null) continue;
                try {
                    dag.addEdge(id, dependencyId);
                }
                catch (CycleDetectedException e) {
                    throw new BuildOnDemandResolutionException("Cycle detected with dependency: " + dependencyId + " of project: " + id + "\n\nCycle: " + e.getCycle(), e);
                }
            }
            MavenProject parent = project.getParent();
            if (parent == null || dag.getVertex(parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId())) == null) continue;
            if (dag.hasEdge(parentId, id)) {
                dag.removeEdge(parentId, id);
            }
            try {
                dag.addEdge(id, parentId);
            }
            catch (CycleDetectedException e) {
                throw new BuildOnDemandResolutionException("THIS SHOULD NEVER HAPPEN!\nCycle detected with parent: " + parentId + " of project: " + id + "\n\nCycle: " + e.getCycle(), e);
            }
        }
    }

    protected Map<String, MavenProject> populateGraphVerticesAndProjectMap(DAG dag, List<MavenProject> candidates) throws BuildOnDemandResolutionException {
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        for (MavenProject project : candidates) {
            String id = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            if (dag.getVertex(id) != null) {
                throw new BuildOnDemandResolutionException("Project '" + id + "' is duplicated in build-candidate set.");
            }
            dag.addVertex(id);
            projectMap.put(id, project);
        }
        return projectMap;
    }
}

