/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.script.Platform;
import org.codehaus.mojo.appassembler.daemon.script.ScriptGenerator;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class DefaultScriptGenerator
extends AbstractLogEnabled
implements ScriptGenerator {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createBinScript(String platformName, Daemon daemon, File outputDirectory) throws DaemonGeneratorException {
        Platform platform = Platform.getInstance(platformName);
        InputStream in = null;
        FileWriter out = null;
        try {
            in = this.getClass().getResourceAsStream(platformName + "BinTemplate");
            if (in == null) {
                throw new DaemonGeneratorException("Internal error: could not find template for platform '" + platformName + "'.");
            }
            InputStreamReader reader = new InputStreamReader(in);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("MAINCLASS", daemon.getMainClass());
            context.put("CLASSPATH", platform.getClassPath(daemon));
            context.put("EXTRA_JVM_ARGUMENTS", platform.getExtraJvmArguments(daemon.getJvmSettings()));
            context.put("APP_NAME", daemon.getId());
            context.put("ENV_SETUP", platform.getEnvSetup(daemon));
            context.put("REPO", daemon.getRepositoryName());
            if (platform.isShowConsoleWindow(daemon)) {
                context.put("JAVA_BINARY", "java");
            } else {
                context.put("JAVA_BINARY", "start /min javaw");
            }
            String appArguments = platform.getAppArguments(daemon);
            if (appArguments != null) {
                context.put("APP_ARGUMENTS", appArguments + " ");
            } else {
                context.put("APP_ARGUMENTS", "");
            }
            String interpolationToken = platform.getInterpolationToken();
            InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, context, interpolationToken, interpolationToken);
            String programName = "";
            if (daemon.getId() == null || daemon.getId().trim().equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(daemon.getMainClass(), ".");
                while (tokenizer.hasMoreElements()) {
                    programName = tokenizer.nextToken();
                }
                programName = programName.toLowerCase();
            } else {
                programName = daemon.getId();
            }
            File binDir = new File(outputDirectory, "bin");
            FileUtils.forceMkdir((File)binDir);
            File binFile = new File(binDir, programName + platform.getBinFileExtension());
            out = new FileWriter(binFile);
            this.getLogger().debug("Writing shell file for platform '" + platform.getName() + "' to '" + binFile.getAbsolutePath() + "'.");
            IOUtil.copy((Reader)interpolationFilterReader, (Writer)out);
        }
        catch (FileNotFoundException e) {
            try {
                throw new DaemonGeneratorException("Failed to get template for bin file.", e);
                catch (IOException e2) {
                    throw new DaemonGeneratorException("Failed to write bin file.", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((Writer)out);
        IOUtil.close((InputStream)in);
    }
}

