/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.Daemon;
import org.codehaus.mojo.appassembler.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.JvmSettings;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.plexus.util.StringUtils;

public class GenerateDaemonsMojo
extends AbstractMojo {
    private Set daemons;
    private JvmSettings defaultJvmSettings;
    private File basedir;
    private File target;
    private MavenProject project;
    private String repositoryLayout;
    private ArtifactRepository localRepository;
    private DaemonGeneratorService daemonGeneratorService;
    private Map availableRepositoryLayouts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Iterator it = this.daemons.iterator();
        while (it.hasNext()) {
            ArtifactRepositoryLayout artifactRepositoryLayout;
            Daemon daemon = (Daemon)it.next();
            File descriptor = null;
            if (!StringUtils.isEmpty((String)daemon.getDescriptor())) {
                descriptor = new File(this.basedir, daemon.getDescriptor());
            }
            org.codehaus.mojo.appassembler.model.JvmSettings modelJvmSettings = null;
            if (this.defaultJvmSettings != null) {
                modelJvmSettings = this.convertJvmSettings(this.defaultJvmSettings);
            }
            if ((artifactRepositoryLayout = (ArtifactRepositoryLayout)this.availableRepositoryLayouts.get(this.repositoryLayout)) == null) {
                throw new MojoFailureException("Unknown repository layout '" + this.repositoryLayout + "'.");
            }
            org.codehaus.mojo.appassembler.model.Daemon modelDaemon = this.convertDaemon(daemon, modelJvmSettings);
            Iterator i = daemon.getPlatforms().iterator();
            while (i.hasNext()) {
                String platform = (String)i.next();
                File output = new File(this.target, platform);
                DaemonGenerationRequest request = new DaemonGenerationRequest();
                request.setPlatform(platform);
                request.setStubDescriptor(descriptor);
                request.setStubDaemon(modelDaemon);
                request.setOutputDirectory(output);
                request.setMavenProject(this.project);
                request.setLocalRepository(this.localRepository);
                request.setRepositoryLayout(artifactRepositoryLayout);
                try {
                    this.daemonGeneratorService.generateDaemon(request);
                }
                catch (DaemonGeneratorException e) {
                    throw new MojoExecutionException("Error while generating daemon.", (Exception)e);
                }
            }
        }
    }

    private org.codehaus.mojo.appassembler.model.Daemon convertDaemon(Daemon daemon, org.codehaus.mojo.appassembler.model.JvmSettings modelJvmSettings) {
        org.codehaus.mojo.appassembler.model.Daemon modelDaemon = new org.codehaus.mojo.appassembler.model.Daemon();
        modelDaemon.setId(daemon.getId());
        modelDaemon.setMainClass(daemon.getMainClass());
        modelDaemon.setCommandLineArguments(daemon.getCommandLineArguments());
        modelDaemon.setShowConsoleWindow(daemon.isShowConsoleWindow());
        modelDaemon.setEnvironmentSetupFileName(daemon.getEnvironmentSetupFileName());
        if (daemon.getJvmSettings() != null) {
            modelDaemon.setJvmSettings(this.convertJvmSettings(daemon.getJvmSettings()));
        } else {
            modelDaemon.setJvmSettings(modelJvmSettings);
        }
        if (daemon.getGeneratorConfigurations() != null) {
            modelDaemon.setGeneratorConfigurations(this.convertGeneratorConfigurations(daemon.getGeneratorConfigurations()));
        }
        return modelDaemon;
    }

    private List convertGeneratorConfigurations(List generatorConfigurations) {
        ArrayList<org.codehaus.mojo.appassembler.model.GeneratorConfiguration> value = new ArrayList<org.codehaus.mojo.appassembler.model.GeneratorConfiguration>(generatorConfigurations.size());
        Iterator i = generatorConfigurations.iterator();
        while (i.hasNext()) {
            GeneratorConfiguration config = (GeneratorConfiguration)i.next();
            value.add(this.convertGeneratorConfiguration(config));
        }
        return value;
    }

    private org.codehaus.mojo.appassembler.model.GeneratorConfiguration convertGeneratorConfiguration(GeneratorConfiguration config) {
        org.codehaus.mojo.appassembler.model.GeneratorConfiguration value = new org.codehaus.mojo.appassembler.model.GeneratorConfiguration();
        value.setGenerator(config.getGenerator());
        value.setConfiguration(config.getConfiguration());
        value.setIncludes(config.getIncludes());
        return value;
    }

    private org.codehaus.mojo.appassembler.model.JvmSettings convertJvmSettings(JvmSettings jvmSettings) {
        org.codehaus.mojo.appassembler.model.JvmSettings modelJvmSettings = new org.codehaus.mojo.appassembler.model.JvmSettings();
        modelJvmSettings.setInitialMemorySize(jvmSettings.getInitialMemorySize());
        modelJvmSettings.setMaxMemorySize(jvmSettings.getMaxMemorySize());
        modelJvmSettings.setMaxStackSize(jvmSettings.getMaxStackSize());
        if (jvmSettings.getSystemProperties() == null) {
            modelJvmSettings.setSystemProperties(new ArrayList());
        } else {
            modelJvmSettings.setSystemProperties(Arrays.asList(jvmSettings.getSystemProperties()));
        }
        if (jvmSettings.getExtraArguments() == null) {
            modelJvmSettings.setExtraArguments(new ArrayList());
        } else {
            modelJvmSettings.setExtraArguments(Arrays.asList(jvmSettings.getExtraArguments()));
        }
        return modelJvmSettings;
    }

    public void setAvailableRepositoryLayouts(Map availableRepositoryLayouts) {
        this.availableRepositoryLayouts = availableRepositoryLayouts;
    }

    public void setDaemons(Set daemons) {
        this.daemons = daemons;
    }
}

