/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jstestrunner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.codehaus.jstestrunner.ProcessLogger;
import org.codehaus.jstestrunner.TestResultProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTestExecutionServer
implements TestResultProducer {
    private static Logger logger = Logger.getLogger(JSTestExecutionServer.class.getName());
    private File testRunnerFile;
    private final Lock testRunnerFileLock = new ReentrantLock();
    private String testRunnerFilePath;
    private String commandPattern;
    private Process process;
    private List<URL> urls;
    private ProcessLogger processLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyTestRunnerFileIfNotExists() throws IOException {
        block12: {
            assert (this.testRunnerFilePath != null);
            String testRunnerFilename = "run-qunit.js";
            this.testRunnerFileLock.lock();
            try {
                this.testRunnerFile = new File(this.testRunnerFilePath, testRunnerFilename);
                if (this.testRunnerFile.exists()) break block12;
                new File(this.testRunnerFilePath).mkdirs();
                this.testRunnerFile.createNewFile();
                InputStream is = JSTestExecutionServer.class.getResourceAsStream("/org/codehaus/jstestrunner/" + testRunnerFilename);
                assert (is != null);
                BufferedInputStream bis = new BufferedInputStream(is);
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.testRunnerFile));
                    try {
                        int c;
                        while ((c = bis.read()) != -1) {
                            bos.write(c);
                        }
                    }
                    finally {
                        bos.close();
                    }
                }
                finally {
                    bis.close();
                }
            }
            finally {
                this.testRunnerFileLock.unlock();
            }
        }
    }

    protected String[] getCommandArgs() throws IOException {
        int c;
        assert (this.commandPattern != null && this.testRunnerFile != null && this.urls != null);
        ArrayList<String> args = new ArrayList<String>();
        StringReader s = new StringReader(this.commandPattern);
        StringBuilder sb = new StringBuilder();
        boolean inDoubleQuotes = false;
        boolean inSingleQuotes = false;
        while ((c = s.read()) != -1) {
            if (c == 34 && !inSingleQuotes) {
                if (inDoubleQuotes) {
                    args.add(sb.toString());
                    sb = new StringBuilder();
                }
                inDoubleQuotes = !inDoubleQuotes;
                continue;
            }
            if (c == 39 && !inDoubleQuotes) {
                if (inSingleQuotes) {
                    args.add(sb.toString());
                    sb = new StringBuilder();
                }
                inSingleQuotes = !inSingleQuotes;
                continue;
            }
            if (!inDoubleQuotes && !inSingleQuotes) {
                if (c == 32) {
                    if (sb.length() <= 0) continue;
                    args.add(sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            sb.append((char)c);
        }
        if (sb.length() > 0) {
            args.add(sb.toString());
        }
        String testRunnerAbsoluteFilePath = this.testRunnerFile.getAbsolutePath();
        sb = new StringBuilder();
        for (URL url : this.urls) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(url.toString());
        }
        String testUrls = sb.toString();
        Object[] formattedArgs = new String[args.size()];
        int i = 0;
        for (String arg : args) {
            formattedArgs[i++] = String.format(arg, testRunnerAbsoluteFilePath, testUrls);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Args to use: " + Arrays.toString(formattedArgs));
        }
        return formattedArgs;
    }

    public String getCommandPattern() {
        return this.commandPattern;
    }

    public String getTestRunnerFilePath() {
        return this.testRunnerFilePath;
    }

    public List<URL> getUrls() {
        return this.urls;
    }

    @Override
    public boolean isAvailable() {
        if (this.process != null) {
            try {
                this.process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }
        return false;
    }

    @Resource
    public void setCommandPattern(String commandPattern) {
        this.commandPattern = commandPattern;
    }

    @Resource
    public void setTestRunnerFilePath(String testRunnerFilePath) {
        this.testRunnerFilePath = testRunnerFilePath;
    }

    @Resource
    public void setUrls(List<URL> urls) {
        this.urls = urls;
    }

    public void start() throws IOException {
        this.copyTestRunnerFileIfNotExists();
        ProcessBuilder builder = new ProcessBuilder(this.getCommandArgs());
        builder.redirectErrorStream(true);
        try {
            this.process = builder.start();
        }
        catch (IOException e) {
            throw new IOException("The phantomjs executable cannot be launched from the path or from the value of the org.codehaus.jstestrunner.commandPattern property. See http://js-testrunner.codehaus.org/usage.html for instructions. Original exception: " + e.toString());
        }
        this.processLogger = new ProcessLogger(this.process);
        this.processLogger.start();
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
            if (logger.isLoggable(Level.FINE) && this.processLogger.isAlive()) {
                try {
                    this.processLogger.join();
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Exception waiting for process logger to exit: " + e.toString());
                }
            }
        }
    }
}

