/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.file;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.userinput.field.file.AbstractFileField;
import com.izforge.izpack.panels.userinput.field.file.FileFieldView;
import com.izforge.izpack.panels.userinput.gui.file.UserInputFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileInputField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4673684743657328492L;
    private static final transient Logger logger = Logger.getLogger(FileInputField.class.getName());
    private final FileFieldView view;
    private final AbstractFileField field;
    InstallerFrame parentFrame;
    IzPanel parent;
    JTextField filetxt;
    JButton browseBtn;
    GUIInstallData installDataGUI;

    public FileInputField(FileFieldView view, IzPanel parent, GUIInstallData installDataGUI) {
        this.view = view;
        this.field = view.getField();
        this.parent = parent;
        this.parentFrame = parent.getInstallerFrame();
        this.installDataGUI = installDataGUI;
        this.initialize();
    }

    public void setFile(String filename) {
        this.filetxt.setText(filename);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.browseBtn) {
            logger.fine("Show file/directory chooser");
            File initialPath = null;
            String initialText = this.filetxt.getText();
            if (initialText != null) {
                initialPath = new File(initialText);
            }
            JFileChooser filechooser = new JFileChooser();
            this.prepareFileChooser(filechooser);
            File prev = null;
            while (!filechooser.isTraversable(initialPath) && prev != initialPath) {
                prev = initialPath;
                if (initialPath == null) continue;
                initialPath = initialPath.getParentFile();
            }
            filechooser.setCurrentDirectory(initialPath);
            if (filechooser.showOpenDialog((Component)this.parentFrame) == 0) {
                String selectedFile = filechooser.getSelectedFile().getAbsolutePath();
                this.filetxt.setText(selectedFile);
                logger.fine("Setting current file chooser directory to: " + selectedFile);
            }
        }
    }

    protected void prepareFileChooser(JFileChooser filechooser) {
        filechooser.setFileSelectionMode(0);
        String fileExtension = this.field.getFileExtension();
        String fileExtensionDescription = this.field.getFileExtensionDescription();
        if (fileExtension != null && fileExtensionDescription != null) {
            UserInputFileFilter fileFilter = new UserInputFileFilter();
            fileFilter.setFileExt(fileExtension);
            fileFilter.setFileExtDesc(fileExtensionDescription);
            filechooser.setFileFilter(fileFilter);
        }
    }

    public File getSelectedFile() {
        File result = null;
        if (this.filetxt.getText() != null && this.filetxt.getText().length() > 0) {
            result = new File(this.filetxt.getText());
        }
        return result;
    }

    public boolean validateField() {
        String path = this.filetxt.getText();
        if (path.length() > 0) {
            File file = this.field.getAbsoluteFile(path);
            this.filetxt.setText(file.getPath());
        }
        return this.view.validate(this.filetxt.getText());
    }

    private void initialize() {
        int size = this.field.getSize() < 0 ? 0 : this.field.getSize();
        this.filetxt = new JTextField(size);
        this.filetxt.setName(this.field.getVariable());
        this.filetxt.setCaretPosition(0);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints fileTextConstraint = new GridBagConstraints();
        GridBagConstraints fileButtonConstraint = new GridBagConstraints();
        fileTextConstraint.gridx = 0;
        fileTextConstraint.gridy = 0;
        fileTextConstraint.anchor = 17;
        fileTextConstraint.insets = new Insets(0, 0, 0, 5);
        fileButtonConstraint.gridx = 1;
        fileButtonConstraint.gridy = 0;
        fileButtonConstraint.anchor = 17;
        this.browseBtn = ButtonFactory.createButton((String)this.installDataGUI.getMessages().get("UserInputPanel.search.browse", new Object[0]), (Color)this.installDataGUI.buttonsHColor);
        this.browseBtn.addActionListener(this);
        this.add((Component)this.filetxt, fileTextConstraint);
        this.add((Component)this.browseBtn, fileButtonConstraint);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.filetxt.setEnabled(enabled);
        this.browseBtn.setEnabled(enabled);
    }
}

