/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.custom;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.userinput.FieldCommand;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.panels.userinput.field.custom.CustomField;
import com.izforge.izpack.panels.userinput.gui.custom.CustomInputRows;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CustomInputField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -5954748826095621101L;
    private GUIInstallData installData;
    private IzPanel parent;
    private List<Field> fields;
    private static final String addCommand = "addComponent";
    private static final String removeCommand = "removeCompoent";
    private JPanel controlPanel;
    private JPanel header;
    private CustomInputRows rows;

    public CustomInputField(CustomField customField, FieldCommand createField, UserInputPanelSpec userInputPanelSpec, IXMLElement spec, IzPanel parent, GUIInstallData installData) {
        this.parent = parent;
        this.installData = installData;
        this.rows = new CustomInputRows(customField, createField, userInputPanelSpec, spec, installData);
        this.header = this.rows.getHeader();
        this.controlPanel = this.initializeControlPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.addComponents(this.rows, this.controlPanel);
        this.updateControlPanel();
    }

    public void addComponents(JPanel rows, JPanel controlPanel) {
        GridBagConstraints headerConstraints = new GridBagConstraints();
        headerConstraints.fill = 1;
        headerConstraints.anchor = 10;
        headerConstraints.gridx = 0;
        headerConstraints.gridy = 0;
        this.add((Component)this.header, headerConstraints);
        GridBagConstraints rowConstraints = new GridBagConstraints();
        rowConstraints.fill = 1;
        rowConstraints.anchor = 10;
        rowConstraints.gridx = 0;
        rowConstraints.gridy = 1;
        this.add((Component)rows, rowConstraints);
        GridBagConstraints controlPanelConstraints = new GridBagConstraints();
        controlPanelConstraints.fill = 0;
        controlPanelConstraints.anchor = 14;
        controlPanelConstraints.gridx = 0;
        controlPanelConstraints.gridy = 2;
        controlPanelConstraints.weighty = 1.0;
        controlPanelConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)controlPanel, controlPanelConstraints);
    }

    private JPanel initializeControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(1, 2));
        Messages messages = this.installData.getMessages();
        JButton addButton = ButtonFactory.createButton((String)messages.get("UserInputPanel.custom.swing.buttonlabel.add", new Object[0]), (Color)this.installData.buttonsHColor);
        addButton.setActionCommand(addCommand);
        addButton.addActionListener(this);
        JButton removeButton = ButtonFactory.createButton((String)messages.get("UserInputPanel.custom.swing.buttonlabel.remove", new Object[0]), (Color)this.installData.buttonsHColor);
        removeButton.setEnabled(false);
        removeButton.setActionCommand(removeCommand);
        removeButton.addActionListener(this);
        controlPanel.add(addButton);
        controlPanel.add(removeButton);
        return controlPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand.equals(addCommand)) {
            this.rows.addRow();
        } else if (actionCommand.equals(removeCommand)) {
            this.rows.removeRow();
        }
        this.updateControlPanel();
    }

    private void updateControlPanel() {
        if (this.rows.hideRowControls()) {
            this.controlPanel.getComponent(0).setVisible(false);
            this.controlPanel.getComponent(1).setVisible(false);
        } else {
            this.controlPanel.getComponent(0).setEnabled(this.rows.atMax());
            this.controlPanel.getComponent(1).setEnabled(this.rows.atMin());
        }
        this.revalidate();
        this.repaint();
    }

    public boolean updateField(Prompt prompt, boolean skipValidation) {
        return this.rows.updateField(prompt, skipValidation);
    }

    public List<String> getLabels() {
        return this.rows.getLabels();
    }

    public List<String> getVariables() {
        return this.rows.getVariables();
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Component component : this.header.getComponents()) {
            component.setEnabled(enabled);
        }
        for (Component component : this.controlPanel.getComponents()) {
            if (enabled) {
                this.updateControlPanel();
                continue;
            }
            component.setEnabled(enabled);
        }
        for (Component component : this.rows.getComponents()) {
            component.setEnabled(enabled);
        }
        this.rows.setEnabled(enabled);
    }
}

