/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.installationgroup;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.panels.installationgroup.GroupData;
import java.util.List;
import java.util.logging.Logger;

public class InstallationGroupPanelAutomationHelper
implements PanelAutomation {
    private static final Logger logger = Logger.getLogger(InstallationGroupPanelAutomationHelper.class.getName());

    public void createInstallationRecord(InstallData installData, IXMLElement rootElement) {
        GroupData[] rows = (GroupData[])installData.getAttribute("GroupData");
        String selectedInstallGroup = installData.getVariable("INSTALL_GROUP");
        for (GroupData groupData : rows) {
            if (!groupData.name.equals(selectedInstallGroup)) continue;
            XMLElementImpl xgroup = new XMLElementImpl("group", rootElement);
            xgroup.setAttribute("name", groupData.name);
            for (String name : groupData.packNames) {
                XMLElementImpl xpack = new XMLElementImpl("pack", (IXMLElement)xgroup);
                xpack.setContent(name);
                xgroup.addChild((IXMLElement)xpack);
            }
            rootElement.addChild((IXMLElement)xgroup);
        }
    }

    public void runAutomated(InstallData idata, IXMLElement panelRoot) {
        IXMLElement group = panelRoot.getFirstChildNamed("group");
        if (group != null) {
            String name = group.getAttribute("name");
            idata.getSelectedPacks().clear();
            List packs = group.getChildrenNamed("pack");
            logger.fine(name + " pack count: " + packs.size());
            logger.fine("Available pack count: " + idata.getAvailablePacks().size());
            block0: for (IXMLElement xpack : packs) {
                String packName = xpack.getContent();
                for (Pack pack : idata.getAvailablePacks()) {
                    if (!pack.getName().equals(packName)) continue;
                    idata.getSelectedPacks().add(pack);
                    logger.fine("Added pack: " + pack.getName());
                    continue block0;
                }
            }
            logger.fine("Set selectedPacks to: " + idata.getSelectedPacks());
        }
    }

    public void processOptions(InstallData installData, Overrides overrides) {
    }
}

