/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.imgpacks;

import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.LayoutHelper;
import com.izforge.izpack.panels.packs.PacksPanelBase;
import com.izforge.izpack.util.IoHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class ImgPacksPanel
extends PacksPanelBase {
    private static final long serialVersionUID = 3977858492633659444L;
    private HashMap<String, ImageIcon> images;
    private JLabel imgLabel;

    public ImgPacksPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, ObjectFactory factory, RulesEngine rules) {
        super(panel, parent, installData, resources, factory, rules);
    }

    @Override
    protected void createNormalLayout() {
        this.preLoadImages();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.setLayout(layout);
        LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)0, (int)0, (int)1, (int)1, (double)0.25, (double)0.0);
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        gbConstraints.anchor = 17;
        this.createLabel("PacksPanel.info", "preferences", layout, gbConstraints);
        LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)1, (int)0, (int)1, (int)1, (double)0.5, (double)0.0);
        this.createLabel("ImgPacksPanel.snap", "tip", layout, gbConstraints);
        this.tableScroller = new JScrollPane();
        LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)0, (int)1, (int)1, (int)2, (double)0.5, (double)0.0);
        gbConstraints.fill = 1;
        this.packsTable = this.createPacksTable(250, this.tableScroller, layout, gbConstraints);
        Iterator pack_it = this.installData.getAvailablePacks().iterator();
        Pack firstImgPack = null;
        boolean imgFound = false;
        while (!imgFound && pack_it.hasNext()) {
            firstImgPack = (Pack)pack_it.next();
            imgFound = firstImgPack.getImageId() != null;
        }
        this.imgLabel = imgFound ? new JLabel(this.images.get(firstImgPack.getImageId())) : new JLabel();
        JScrollPane imgScroller = new JScrollPane(this.imgLabel);
        imgScroller.setPreferredSize(this.getPreferredSizeFromImages());
        LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)1, (int)1, (int)1, (int)1, (double)0.5, (double)1.0);
        layout.addLayoutComponent(imgScroller, gbConstraints);
        this.add(imgScroller);
        Component strut = Box.createVerticalStrut(20);
        LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)1, (int)2, (int)1, (int)3, (double)0.0, (double)0.0);
        layout.addLayoutComponent(strut, gbConstraints);
        this.add(strut);
        if (this.dependenciesExist) {
            JScrollPane depScroller = new JScrollPane();
            depScroller.setPreferredSize(new Dimension(250, 40));
            LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)0, (int)3, (int)1, (int)1, (double)0.5, (double)0.5);
            this.dependencyArea = this.createTextArea("ImgPacksPanel.dependencyList", depScroller, layout, gbConstraints);
        }
        JScrollPane descriptionScroller = new JScrollPane();
        descriptionScroller.setPreferredSize(new Dimension(200, 60));
        descriptionScroller.setBorder(BorderFactory.createEmptyBorder());
        LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)1, (int)3, (int)1, (int)1, (double)0.5, (double)0.5);
        this.descriptionArea = this.createTextArea("PacksPanel.description", descriptionScroller, layout, gbConstraints);
        LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)0, (int)4, (int)2, (int)1, (double)0.0, (double)0.0);
        this.createLabel("PacksPanel.tip", "tip", layout, gbConstraints);
        LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)0, (int)5, (int)2, (int)1, (double)0.0, (double)0.0);
        this.spaceLabel = this.createPanelWithLabel("PacksPanel.space", layout, gbConstraints);
        if (IoHelper.supported((String)"getFreeSpace")) {
            LayoutHelper.buildConstraints((GridBagConstraints)gbConstraints, (int)0, (int)6, (int)2, (int)1, (double)0.0, (double)0.0);
            this.freeSpaceLabel = this.createPanelWithLabel("PacksPanel.freespace", layout, gbConstraints);
        }
    }

    private void preLoadImages() {
        int size = this.installData.getAvailablePacks().size();
        this.images = new HashMap(size);
        Resources resources = this.getResources();
        for (Pack pack : this.installData.getAvailablePacks()) {
            String imageId = pack.getImageId();
            if (imageId == null) continue;
            try {
                ImageIcon img = resources.getImageIcon(imageId, new String[0]);
                this.images.put(imageId, img);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    private Dimension getPreferredSizeFromImages() {
        int maxWidth = 80;
        int maxHeight = 60;
        Iterator<ImageIcon> i$ = this.images.values().iterator();
        while (i$.hasNext()) {
            ImageIcon imageIcon;
            ImageIcon icon = imageIcon = i$.next();
            maxWidth = Math.max(maxWidth, icon.getIconWidth());
            maxHeight = Math.max(maxHeight, icon.getIconHeight());
        }
        maxWidth = Math.min(maxWidth + 20, this.installData.guiPrefs.width - 150);
        maxHeight = Math.min(maxHeight + 20, this.installData.guiPrefs.height - 150);
        return new Dimension(maxWidth, maxHeight);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int i = this.packsTable.getSelectedRow();
        super.valueChanged(e);
        if (i < 0) {
            return;
        }
        if (i >= 0) {
            Pack pack = (Pack)this.installData.getAvailablePacks().get(i);
            this.imgLabel.setIcon(this.images.get(pack.getImageId()));
        }
    }
}

