/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.compile;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class CompileResult {
    public static final int SUCCESS = 42;
    public static final int FAILED = 23;
    public static final int ACTION_ABORT = 27;
    public static final int ACTION_CONTINUE = 39;
    public static final int ACTION_RECONFIGURE = 31;
    private int status = 42;
    private int action = 27;
    private String message = null;
    private List<String> cmdline = null;
    private String stdout = null;
    private String stderr = null;

    public CompileResult() {
        this.status = 42;
        this.action = 39;
    }

    public CompileResult(Exception anException) {
        StringWriter writer = new StringWriter();
        anException.printStackTrace(new PrintWriter(writer));
        this.message = writer.toString();
        this.action = 27;
        this.status = 23;
    }

    public CompileResult(String message, List<String> cmdline, String stdout, String stderr) {
        this.message = message;
        this.status = 23;
        this.cmdline = cmdline;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public void setStatus(int status) {
        if (status == 42 || status == 23) {
            this.status = status;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setAction(int action) {
        if (action == 27 || action == 39 || action == 31) {
            this.action = action;
        }
    }

    public int getAction() {
        return this.action;
    }

    public boolean isSuccess() {
        return this.status == 42;
    }

    public boolean isAbort() {
        return this.status == 23 && this.action == 27;
    }

    public boolean isContinue() {
        return this.status == 42 || this.action == 39;
    }

    public boolean isReconfigure() {
        return this.status == 23 && this.action == 31;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCmdline() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String aCmdline : this.cmdline) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(aCmdline);
        }
        return stringBuffer.toString();
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }
}

