/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.checkedhello;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.checkedhello.RegistryHelper;
import com.izforge.izpack.panels.hello.HelloConsolePanel;
import com.izforge.izpack.util.Console;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckedHelloConsolePanel
extends HelloConsolePanel {
    private final RegistryHelper registryHelper;
    private boolean registered;
    private final Prompt prompt;
    private static final Logger log = Logger.getLogger(CheckedHelloConsolePanel.class.getName());

    public CheckedHelloConsolePanel(RegistryDefaultHandler handler, InstallData installData, Prompt prompt, PanelView<ConsolePanel> panel) throws NativeLibException {
        super(panel);
        this.registryHelper = new RegistryHelper(handler, installData);
        this.prompt = prompt;
        this.registered = this.registryHelper.isRegistered();
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        boolean result = true;
        if (this.registered && (result = this.multipleInstall(installData))) {
            try {
                this.registryHelper.updateUninstallName();
                this.registered = false;
            }
            catch (NativeLibException exception) {
                result = false;
                log.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        installData.setVariable("UNINSTALL_NAME", this.registryHelper.getUninstallName());
        if (result) {
            this.display(installData, console);
            result = this.promptEndPanel(installData, console);
        }
        return result;
    }

    protected boolean multipleInstall(InstallData installData) {
        boolean result;
        try {
            Messages messages;
            String message;
            String path = this.registryHelper.getInstallationPath();
            if (path == null) {
                path = "<not found>";
            }
            result = this.prompt.confirm(Prompt.Type.ERROR, message = (messages = installData.getMessages()).get("CheckedHelloPanel.productAlreadyExist0", new Object[0]) + path + "\n" + messages.get("CheckedHelloPanel.productAlreadyExist1", new Object[0]), Prompt.Options.YES_NO) == Prompt.Option.YES;
        }
        catch (NativeLibException exception) {
            result = false;
        }
        return result;
    }
}

