/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.Blockable;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.util.os.FileQueue;
import com.izforge.izpack.util.os.FileQueueMove;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class FileUnpacker {
    private final Cancellable cancellable;
    private File target;
    private File tmpTarget;
    private final FileQueue queue;
    private boolean queued;
    private static final Logger logger = Logger.getLogger(FileUnpacker.class.getName());

    public FileUnpacker(Cancellable cancellable, FileQueue queue) {
        this.cancellable = cancellable;
        this.queue = queue;
    }

    public abstract void unpack(PackFile var1, InputStream var2, File var3) throws IOException, InstallerException;

    public boolean isQueued() {
        return this.queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long copy(PackFile file, InputStream in, File target) throws IOException {
        OutputStream out = this.getTarget(file, target);
        byte[] buffer = new byte[5120];
        long bytesCopied = 0L;
        long bytesToCopy = file.isBackReference() ? file.getLinkedPackFile().length() : file.length();
        logger.fine("|- Copying to file system (size: " + bytesToCopy + " bytes)");
        try {
            while (bytesCopied < bytesToCopy) {
                if (this.cancellable.isCancelled()) {
                    throw new InterruptedIOException("Copy operation cancelled");
                }
                bytesCopied = this.copy(file, buffer, in, out, bytesCopied);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        this.postCopy(file);
        return bytesCopied;
    }

    protected void postCopy(PackFile file) {
        this.setLastModified(file);
        if (this.isBlockable(file)) {
            this.queue();
        }
    }

    protected long copy(PackFile file, byte[] buffer, InputStream in, OutputStream out, long bytesCopied) throws IOException {
        int maxBytes = (int)Math.min(file.length() - bytesCopied, (long)buffer.length);
        int read = this.read(buffer, in, maxBytes);
        if (read == -1) {
            throw new IOException("Unexpected end of stream (installer corrupted?)");
        }
        out.write(buffer, 0, read);
        return bytesCopied += (long)read;
    }

    protected int read(byte[] buffer, InputStream in, int maxBytes) throws IOException {
        return in.read(buffer, 0, maxBytes);
    }

    protected OutputStream getTarget(PackFile file, File target) throws IOException {
        FileOutputStream result;
        this.target = target;
        if (this.isBlockable(file)) {
            this.tmpTarget = File.createTempFile("__FQ__", null, target.getParentFile());
            result = FileUtils.openOutputStream((File)this.tmpTarget);
        } else {
            result = FileUtils.openOutputStream((File)target);
        }
        return result;
    }

    protected void setLastModified(PackFile file) {
        if (file.lastModified() >= 0L) {
            File f;
            File file2 = f = this.tmpTarget != null ? this.tmpTarget : this.target;
            if (!f.setLastModified(file.lastModified())) {
                logger.warning("Failed to set last modified timestamp for: " + this.target);
            }
        }
    }

    private boolean isBlockable(PackFile file) {
        return this.queue != null && file.blockable() != Blockable.BLOCKABLE_NONE;
    }

    private void queue() {
        FileQueueMove move = new FileQueueMove(this.tmpTarget, this.target);
        move.setForceInUse(true);
        move.setOverwrite(true);
        this.queue.add(move);
        logger.fine(this.tmpTarget.getAbsolutePath() + " -> " + this.target.getAbsolutePath() + " added to file queue for being copied after reboot");
        this.tmpTarget.deleteOnExit();
        this.queued = true;
    }
}

