/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.Navigator;
import com.izforge.izpack.installer.panel.Panels;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class DefaultNavigator
implements Navigator {
    private InstallerFrame frame;
    private final Panels panels;
    private JButton previous;
    private JButton next;
    private JButton quit;
    private boolean switchPanel;
    private boolean configureNext = true;
    private boolean configurePrevious = true;

    public DefaultNavigator(Panels panels, IconsDatabase icons, GUIInstallData installData) {
        this.panels = panels;
        Messages messages = installData.getMessages();
        this.previous = ButtonFactory.createButton((String)messages.get("installer.prev", new Object[0]), (Icon)((Icon)icons.get((Object)"stepback")), (Color)installData.buttonsHColor);
        NavigationHandler navHandler = new NavigationHandler();
        this.previous.addActionListener(navHandler);
        this.previous.setName(GuiId.BUTTON_PREV.id);
        this.previous.setVisible(false);
        this.next = ButtonFactory.createButton((String)messages.get("installer.next", new Object[0]), (Icon)((Icon)icons.get((Object)"stepforward")), (Color)installData.buttonsHColor);
        this.next.setName(GuiId.BUTTON_NEXT.id);
        this.next.addActionListener(navHandler);
        this.quit = ButtonFactory.createButton((String)messages.get("installer.quit", new Object[0]), (Icon)((Icon)icons.get((Object)"stop")), (Color)installData.buttonsHColor);
        this.quit.setName(GuiId.BUTTON_QUIT.id);
        this.quit.addActionListener(navHandler);
        this.configureVisibility();
    }

    protected void updateButtonText(Messages messages) {
        this.previous.setText(messages.get("installer.prev", new Object[0]));
        this.next.setText(messages.get("installer.next", new Object[0]));
        this.quit.setText(messages.get("installer.quit", new Object[0]));
    }

    public void reserveNavigatorButtonMnemonics() {
        JButton[] buttons = new JButton[]{this.quit, this.next, this.previous};
        ButtonFactory.reserveButtonMnemonics((JButton[])buttons);
    }

    public void setInstallerFrame(InstallerFrame frame) {
        this.frame = frame;
    }

    @Override
    public boolean isNextEnabled() {
        return this.next.isEnabled();
    }

    @Override
    public void setNextEnabled(boolean enable) {
        this.configureNext = !this.switchPanel;
        this.next.setEnabled(enable);
    }

    @Override
    public void setNextVisible(boolean visible) {
        this.next.setVisible(visible);
    }

    @Override
    public void setNextText(String text) {
        this.next.setText(text);
    }

    @Override
    public void setNextIcon(Icon icon) {
        this.next.setIcon(icon);
    }

    @Override
    public boolean isPreviousEnabled() {
        return this.previous.isEnabled();
    }

    @Override
    public void setPreviousEnabled(boolean enable) {
        this.configurePrevious = !this.switchPanel;
        this.previous.setEnabled(enable);
    }

    @Override
    public void setPreviousVisible(boolean visible) {
        this.previous.setVisible(visible);
    }

    @Override
    public void setPreviousText(String text) {
        this.previous.setText(text);
    }

    @Override
    public void setPreviousIcon(Icon icon) {
        this.previous.setIcon(icon);
    }

    @Override
    public boolean isQuitEnabled() {
        return this.quit.isEnabled();
    }

    @Override
    public void setQuitEnabled(boolean enable) {
        this.quit.setEnabled(enable);
    }

    @Override
    public void setQuitVisible(boolean visible) {
        this.quit.setVisible(visible);
    }

    @Override
    public void setQuitText(String text) {
        this.quit.setText(text);
    }

    @Override
    public void setQuitIcon(Icon icon) {
        this.quit.setIcon(icon);
    }

    @Override
    public boolean next() {
        return this.next(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next(boolean validate) {
        boolean result = false;
        try {
            this.preSwitchPanel();
            result = this.panels.next(validate);
        }
        finally {
            this.postSwitchPanel();
        }
        this.configureVisibility();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() {
        boolean result = false;
        if (this.isPreviousEnabled()) {
            try {
                this.preSwitchPanel();
                result = this.panels.previous();
            }
            finally {
                this.postSwitchPanel();
            }
            this.configureVisibility();
        }
        return result;
    }

    @Override
    public void quit() {
        if (this.isQuitEnabled()) {
            this.frame.quit();
        }
    }

    protected JButton getNext() {
        return this.next;
    }

    protected JButton getPrevious() {
        return this.previous;
    }

    protected JButton getQuit() {
        return this.quit;
    }

    protected JButton setDefaultButton() {
        JButton result = null;
        if (this.next.isEnabled()) {
            result = this.next;
            this.quit.setDefaultCapable(false);
            this.previous.setDefaultCapable(false);
            this.next.setDefaultCapable(true);
        } else if (this.quit.isEnabled()) {
            result = this.quit;
            this.quit.setDefaultCapable(true);
            this.previous.setDefaultCapable(false);
            this.next.setDefaultCapable(false);
        }
        return result;
    }

    private void preSwitchPanel() {
        this.switchPanel = true;
        this.configureNext = true;
        this.configurePrevious = true;
    }

    private void postSwitchPanel() {
        this.switchPanel = false;
    }

    private void configureVisibility() {
        boolean isLastPanel;
        boolean bl = isLastPanel = this.panels.getNext(true) == -1;
        if (isLastPanel) {
            this.setPreviousVisible(false);
            this.setPreviousEnabled(false);
            this.setNextVisible(false);
            this.setNextEnabled(false);
        } else {
            if (this.configurePrevious) {
                boolean enablePrev = this.panels.getPrevious(true) != -1;
                this.setPreviousVisible(enablePrev);
                this.setPreviousEnabled(enablePrev);
            }
            if (this.configureNext) {
                boolean enableNext = !isLastPanel;
                this.setNextVisible(enableNext);
                this.setNextEnabled(enableNext);
            }
        }
        if (this.frame != null && this.frame.getRootPane() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultNavigator.this.frame.getRootPane().setDefaultButton(DefaultNavigator.this.setDefaultButton());
                }
            });
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DefaultNavigator.this.frame.blockGUI();
                            NavigationHandler.this.navigate(e);
                            DefaultNavigator.this.frame.releaseGUI();
                        }
                    });
                }
            }).start();
        }

        private void navigate(ActionEvent e) {
            Object source = e.getSource();
            if (source == DefaultNavigator.this.previous) {
                DefaultNavigator.this.previous();
            } else if (source == DefaultNavigator.this.next) {
                DefaultNavigator.this.next();
            } else if (source == DefaultNavigator.this.quit) {
                DefaultNavigator.this.quit();
            }
        }
    }
}

