/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.provider;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.core.rules.ConditionContainer;
import com.izforge.izpack.core.rules.RulesEngineImpl;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.picocontainer.injectors.Provider;

public class RulesProvider
implements Provider {
    private static final Logger logger = Logger.getLogger(RulesProvider.class.getName());
    private static final String CONDITIONS_SPECRESOURCENAME = "conditions.xml";

    public RulesEngine provide(AutomatedInstallData installData, DefaultVariables variables, ConditionContainer conditionContainer, Resources resources) {
        RulesEngineImpl result = new RulesEngineImpl((InstallData)installData, conditionContainer, installData.getPlatform());
        Map<String, Condition> conditions = this.readConditions(resources);
        if (conditions != null && !conditions.isEmpty()) {
            result.readConditionMap(conditions);
        } else {
            IXMLElement xml = this.readConditions();
            if (xml != null) {
                result.analyzeXml(xml);
            }
        }
        installData.setRules((RulesEngine)result);
        variables.setRules((RulesEngine)result);
        return result;
    }

    private Map<String, Condition> readConditions(Resources resources) {
        Map rules = null;
        try {
            rules = (Map)resources.getObject("rules");
        }
        catch (ResourceNotFoundException rnfe) {
            logger.fine("No optional rules defined");
        }
        catch (ResourceException re) {
            logger.log(Level.SEVERE, "Optional rules could not be loaded", re);
        }
        return rules;
    }

    private IXMLElement readConditions() {
        IXMLElement conditions = null;
        try {
            InputStream input = ClassLoader.getSystemResourceAsStream(CONDITIONS_SPECRESOURCENAME);
            if (input != null) {
                XMLParser xmlParser = new XMLParser();
                conditions = xmlParser.parse(input);
            }
        }
        catch (Exception e) {
            logger.fine("No optional resource found: conditions.xml");
        }
        return conditions;
    }
}

