/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.lang.reflect.InvocationTargetException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.gmavenplus.mojo.AbstractToolsMojo;
import org.codehaus.gmavenplus.util.ClassWrangler;
import org.codehaus.gmavenplus.util.NoExitSecurityManager;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public class ShellMojo
extends AbstractToolsMojo {
    protected String verbosity;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.classWrangler = new ClassWrangler(Thread.currentThread().getContextClassLoader(), this.getLog());
        if (this.groovyVersionSupportsAction()) {
            this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
            this.logPluginClasspath();
            if (this.getLog().isDebugEnabled()) {
                try {
                    this.getLog().debug((CharSequence)("Project test classpath:\n" + this.project.getTestClasspathElements()));
                }
                catch (DependencyResolutionRequiredException e) {
                    this.getLog().warn((CharSequence)"Unable to log project test classpath", (Throwable)e);
                }
            }
            SecurityManager sm = System.getSecurityManager();
            try {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(new NoExitSecurityManager());
                }
                Class shellClass = this.classWrangler.getClass("org.codehaus.groovy.tools.shell.Groovysh");
                Class bindingClass = this.classWrangler.getClass("groovy.lang.Binding");
                Class ioClass = this.classWrangler.getClass("org.codehaus.groovy.tools.shell.IO");
                Class verbosityClass = this.classWrangler.getClass("org.codehaus.groovy.tools.shell.IO$Verbosity");
                Class loggerClass = this.classWrangler.getClass("org.codehaus.groovy.tools.shell.util.Logger");
                Object shell = this.setupShell(shellClass, bindingClass, ioClass, verbosityClass, loggerClass);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(shellClass, "run", String.class), shell, new Object[]{null});
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Unable to get a Groovy class from classpath.  Do you have Groovy as a compile dependency in your project or the plugin?", (Exception)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NoClassDefFoundError && e.getCause().getMessage() != null && e.getCause().getMessage().contains("jline")) {
                    throw new MojoExecutionException("Unable to get a JLine class from classpath.  This might be because of a JLine version mismatch.  If you are using Groovy < 2.2.0-beta-1, make sure you include JLine 1.0 as a runtime dependency in your project or the plugin.", (Exception)e);
                }
                throw new MojoExecutionException("Error occurred while calling a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException("Unable to access a method on a Groovy class from classpath.", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException("Error occurred while instantiating a Groovy class from classpath.", (Exception)e);
            }
            finally {
                if (!this.allowSystemExits) {
                    System.setSecurityManager(sm);
                }
            }
        }
        this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support running a shell.  The minimum version of Groovy required is " + this.minGroovyVersion + ".  Skipping shell startup."));
    }

    protected Object setupShell(Class shellClass, Class bindingClass, Class ioClass, Class verbosityClass, Class loggerClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object binding = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(bindingClass, new Class[0]), new Object[0]);
        this.initializeProperties();
        if (this.bindPropertiesToSeparateVariables) {
            for (Object k : this.properties.keySet()) {
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class), binding, k, this.properties.get(k));
            }
        } else {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class), binding, "properties", this.properties);
        }
        Object io = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(ioClass, new Class[0]), new Object[0]);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(ioClass, "setVerbosity", verbosityClass), io, ReflectionUtils.invokeStaticMethod(ReflectionUtils.findMethod(verbosityClass, "forName", String.class), this.verbosity));
        ReflectionUtils.findField(loggerClass, "io", ioClass).set(null, io);
        return ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(shellClass, ClassLoader.class, bindingClass, ioClass), Thread.currentThread().getContextClassLoader(), binding, io);
    }
}

