/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.tools.daemon;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.http.FormContentType;
import org.codehaus.cargo.container.internal.http.HttpFormRequest;
import org.codehaus.cargo.container.internal.http.HttpRequest;
import org.codehaus.cargo.container.internal.http.HttpResult;
import org.codehaus.cargo.container.internal.http.MultipartFormContentType;
import org.codehaus.cargo.container.internal.http.UrlEncodedFormContentType;
import org.codehaus.cargo.tools.daemon.DaemonException;
import org.codehaus.cargo.tools.daemon.DaemonParameters;
import org.codehaus.cargo.tools.daemon.DaemonStart;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.XmlReplacement;
import org.codehaus.cargo.util.log.LoggedObject;

public class DaemonClient
extends LoggedObject {
    private final URL url;
    private final String username;
    private final String password;
    private final FileHandler fileHandler = new DefaultFileHandler();
    private String userAgent;

    public DaemonClient(URL url) {
        this(url, null, null);
    }

    public DaemonClient(URL url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public URL getURL() {
        return this.url;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void start(DaemonStart start) throws DaemonException, IOException {
        DaemonParameters parameters = new DaemonParameters();
        String handleId = start.getHandleId();
        parameters.setParameter("handleId", handleId);
        InstalledLocalContainer container = start.getContainer();
        if (container != null) {
            boolean autostart = start.isAutostart();
            String installerZipFile = start.getInstallerZipFile();
            String logFile = start.getLogFile();
            List<Deployable> deployables = start.getDeployables();
            LocalConfiguration configuration = container.getConfiguration();
            parameters.setParameter("autostart", String.valueOf(autostart));
            parameters.setParameter("containerId", container.getId());
            parameters.setParameter("configurationType", configuration.getType().toString());
            parameters.setParameter("timeout", String.valueOf(container.getTimeout()));
            if (container.getHome() != null) {
                parameters.setParameter("containerHome", container.getHome());
            }
            if (configuration.getHome() != null) {
                parameters.setParameter("configurationHome", configuration.getHome());
            }
            if (installerZipFile != null) {
                if (!this.installed(installerZipFile)) {
                    parameters.setFile("installerZipFileData", installerZipFile);
                }
                parameters.setParameter("installerZipFile", this.fileHandler.getName(installerZipFile));
            }
            if (deployables != null) {
                parameters.setParameter("deployableFiles", this.setupDeployables(parameters, deployables));
            }
            this.setupConfigFiles(parameters, configuration);
            if (container instanceof InstalledLocalContainer) {
                this.setupExtraClasspath(parameters, container);
                this.setupSharedClasspath(parameters, container);
            }
            this.setupAdditionalClasspath(parameters, start.getAdditionalClasspathEntries());
            parameters.setParameter("configurationProperties", this.setupConfigurationProperties(configuration));
            parameters.setParameter("containerProperties", this.setupContainerProperties(container));
            parameters.setParameter("xmlReplacements", this.setupXmlReplacements(container));
            parameters.setParameter("containerOutput", container.getOutput());
            if (logFile != null) {
                parameters.setParameter("containerLogFile", logFile);
            }
            parameters.setParameter("containerLogLevel", container.getLogger().getLevel().toString());
            if (container.isAppend()) {
                parameters.setParameter("containerAppend", "on");
            } else {
                parameters.setParameter("containerAppend", "off");
            }
        }
        this.invoke("start", parameters);
    }

    private void setupAdditionalClasspath(DaemonParameters parameters, List<String> additionalClasspathEntries) {
        if (additionalClasspathEntries == null || additionalClasspathEntries.size() == 0) {
            return;
        }
        StringBuilder classpathJSON = new StringBuilder();
        classpathJSON.append("[");
        boolean first = true;
        for (String additionalClasspathEntry : additionalClasspathEntries) {
            if (first) {
                first = false;
            } else {
                classpathJSON.append(",");
            }
            classpathJSON.append("\"");
            classpathJSON.append(additionalClasspathEntry);
            classpathJSON.append("\"");
        }
        classpathJSON.append("]");
        parameters.setParameter("additionalClasspath", classpathJSON.toString());
    }

    private void resolveFiles(List<String> classpaths, Map<String, String> files, String[] paths, String prefix) {
        for (String path : paths) {
            String relativePath = this.fileHandler.getName(path);
            if (prefix != null) {
                relativePath = this.fileHandler.append(prefix, relativePath);
            }
            if (classpaths != null) {
                classpaths.add(relativePath);
            }
            if (this.fileHandler.isDirectory(path)) {
                String[] children = this.fileHandler.getChildren(path);
                if (children == null || children.length == 0) continue;
                this.resolveFiles(null, files, children, relativePath);
                continue;
            }
            files.put(relativePath, path);
        }
    }

    private void resolveFile(Map<String, String> files, String file, String relativePath) {
        if (this.fileHandler.isDirectory(file)) {
            String[] children = this.fileHandler.getChildren(file);
            if (children != null && children.length != 0) {
                for (String child : children) {
                    this.resolveFile(files, child, this.fileHandler.append(relativePath, this.fileHandler.getName(child)));
                }
            }
        } else {
            files.put(relativePath, file);
        }
    }

    private void addListParameter(DaemonParameters parameters, String parameterName, List<String> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        StringBuilder listJSON = new StringBuilder();
        listJSON.append("[");
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                listJSON.append(",");
            }
            listJSON.append("\"" + item + "\"");
        }
        listJSON.append("]");
        parameters.setParameter(parameterName, listJSON.toString());
    }

    private void addFilesParameter(DaemonParameters parameters, String parameterName, String filePrefix, Map<String, String> files) {
        StringBuilder propertiesJSON = new StringBuilder();
        propertiesJSON.append("[");
        int fileId = 0;
        for (Map.Entry<String, String> entry : files.entrySet()) {
            String relativePath = entry.getKey();
            String absolutePath = entry.getValue();
            if (fileId != 0) {
                propertiesJSON.append(",");
            }
            propertiesJSON.append("\"" + relativePath + "\"");
            parameters.setFile(filePrefix + fileId, absolutePath);
            ++fileId;
        }
        propertiesJSON.append("]");
        parameters.setParameter(parameterName, propertiesJSON.toString());
    }

    private void setupExtraClasspath(DaemonParameters parameters, InstalledLocalContainer container) {
        String[] extraClasspaths = container.getExtraClasspath();
        if (extraClasspaths == null || extraClasspaths.length == 0) {
            return;
        }
        HashMap<String, String> files = new HashMap<String, String>();
        ArrayList<String> relativeClasspaths = new ArrayList<String>();
        this.resolveFiles(relativeClasspaths, files, extraClasspaths, null);
        this.addFilesParameter(parameters, "extraFiles", "extraFileData_", files);
        this.addListParameter(parameters, "extraClasspath", relativeClasspaths);
    }

    private void setupSharedClasspath(DaemonParameters parameters, InstalledLocalContainer container) {
        String[] sharedClasspaths = container.getSharedClasspath();
        if (sharedClasspaths == null || sharedClasspaths.length == 0) {
            return;
        }
        HashMap<String, String> files = new HashMap<String, String>();
        ArrayList<String> relativeClasspaths = new ArrayList<String>();
        this.resolveFiles(relativeClasspaths, files, sharedClasspaths, null);
        this.addFilesParameter(parameters, "sharedFiles", "sharedFileData_", files);
        this.addListParameter(parameters, "sharedClasspath", relativeClasspaths);
    }

    private String setupDeployables(DaemonParameters parameters, List<Deployable> deployables) {
        StringBuilder propertiesJSON = new StringBuilder();
        propertiesJSON.append("[");
        for (int i = 0; i < deployables.size(); ++i) {
            Deployable deployable = deployables.get(i);
            if (i != 0) {
                propertiesJSON.append(",");
            }
            propertiesJSON.append("{");
            if (deployable instanceof WAR) {
                WAR war = (WAR)deployable;
                propertiesJSON.append("\"context\":\"" + war.getContext() + "\",");
            }
            propertiesJSON.append("\"type\":\"" + deployable.getType().toString() + "\",");
            propertiesJSON.append("\"filename\":\"" + this.fileHandler.getName(deployable.getFile()) + "\"");
            propertiesJSON.append("}");
            parameters.setFile("deployableFileData_" + i, deployable.getFile());
        }
        propertiesJSON.append("]");
        return propertiesJSON.toString();
    }

    private void setupConfigFiles(DaemonParameters parameters, LocalConfiguration configuration) {
        List fileConfigs = configuration.getFileProperties();
        if (fileConfigs == null || fileConfigs.size() == 0) {
            return;
        }
        HashMap<String, String> files = new HashMap<String, String>();
        for (FileConfig fileConfig : fileConfigs) {
            String file = fileConfig.getFile();
            String relativePath = this.fileHandler.getName(file);
            this.resolveFile(files, file, relativePath);
        }
        StringBuilder propertiesJSON = new StringBuilder();
        propertiesJSON.append("[");
        boolean first = true;
        for (FileConfig fileConfig : fileConfigs) {
            if (first) {
                first = false;
            } else {
                propertiesJSON.append(",");
            }
            String file = this.fileHandler.getName(fileConfig.getFile());
            String toFile = fileConfig.getToFile();
            String toDirectory = fileConfig.getToDir();
            boolean overwrite = fileConfig.getOverwrite();
            boolean filter = fileConfig.getConfigfile();
            String encoding = fileConfig.getEncoding();
            propertiesJSON.append("{");
            if (toFile != null) {
                propertiesJSON.append("\"tofile\":\"" + this.escapeJson(toFile) + "\",");
            }
            if (toDirectory != null) {
                propertiesJSON.append("\"todir\":\"" + this.escapeJson(toDirectory) + "\",");
            }
            propertiesJSON.append("\"overwrite\":\"" + overwrite + "\",");
            propertiesJSON.append("\"filter\":\"" + filter + "\",");
            if (encoding != null) {
                propertiesJSON.append("\"encoding\":\"" + this.escapeJson(encoding) + "\",");
            }
            propertiesJSON.append("\"file\":\"" + this.escapeJson(file) + "\"");
            propertiesJSON.append("}");
        }
        propertiesJSON.append("]");
        parameters.setParameter("configurationFileProperties", propertiesJSON.toString());
        this.addFilesParameter(parameters, "configurationFiles", "configurationFileData_", files);
    }

    private String setupConfigurationProperties(LocalConfiguration configuration) {
        StringBuilder propertiesJSON = new StringBuilder();
        Map properties = configuration.getProperties();
        propertiesJSON.append("{");
        boolean first = true;
        for (Map.Entry entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                propertiesJSON.append(",");
            }
            propertiesJSON.append("\"" + this.escapeJson((String)entry.getKey()) + "\":\"" + this.escapeJson((String)entry.getValue()) + "\"");
        }
        propertiesJSON.append("}");
        return propertiesJSON.toString();
    }

    private String setupContainerProperties(InstalledLocalContainer container) {
        StringBuilder propertiesJSON = new StringBuilder();
        Map properties = container.getSystemProperties();
        propertiesJSON.append("{");
        boolean first = true;
        for (Map.Entry entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                propertiesJSON.append(",");
            }
            propertiesJSON.append("\"" + this.escapeJson((String)entry.getKey()) + "\":\"" + this.escapeJson((String)entry.getValue()) + "\"");
        }
        propertiesJSON.append("}");
        return propertiesJSON.toString();
    }

    private String setupXmlReplacements(InstalledLocalContainer container) {
        StringBuilder propertiesJSON = new StringBuilder();
        if (container.getConfiguration() instanceof StandaloneLocalConfiguration) {
            StandaloneLocalConfiguration configuration = (StandaloneLocalConfiguration)container.getConfiguration();
            propertiesJSON.append("[");
            boolean first = true;
            for (XmlReplacement xmlReplacement : configuration.getXmlReplacements()) {
                if (first) {
                    first = false;
                } else {
                    propertiesJSON.append(",");
                }
                propertiesJSON.append("{\"attributeName\":\"" + this.escapeJson(xmlReplacement.getAttributeName()) + "\",\"file\":\"" + this.escapeJson(xmlReplacement.getFile()) + "\",\"value\":\"" + this.escapeJson(xmlReplacement.getValue()) + "\",\"xpathExpression\":\"" + this.escapeJson(xmlReplacement.getXpathExpression()) + "\",\"replacementBehavior\":\"" + xmlReplacement.getReplacementBehavior() + "\"}");
            }
            propertiesJSON.append("]");
        }
        return propertiesJSON.toString();
    }

    private String escapeJson(String string) {
        if (string != null) {
            return string.replace("\\", "\\\\").replace("\"", "\\\"");
        }
        return "";
    }

    private boolean installed(String file) throws DaemonException, IOException {
        DaemonParameters parameters = new DaemonParameters();
        parameters.setParameter("file", this.fileHandler.getName(file));
        String response = this.invoke("installed", parameters);
        if (response != null) {
            response = response.trim();
        }
        return "OK - INSTALLED".equals(response);
    }

    public void stop(String handleId) throws DaemonException, IOException {
        DaemonParameters parameters = new DaemonParameters();
        parameters.setParameter("handleId", handleId);
        this.invoke("stop", parameters);
    }

    protected String invoke(String path, DaemonParameters parameters) throws DaemonException, IOException {
        HttpResult result;
        URL invokeURL = this.url.toString().endsWith("/") ? new URL(this.url + path) : new URL(this.url + "/" + path);
        if (parameters == null) {
            HttpRequest request = new HttpRequest(invokeURL);
            request.setAuthentication(this.username, this.password);
            if (this.userAgent != null) {
                request.addRequestProperty("User-Agent", this.userAgent);
            }
            request.setLogger(this.getLogger());
            result = request.get();
        } else {
            UrlEncodedFormContentType contentType = null;
            if (parameters.isMultipartForm()) {
                MultipartFormContentType multipartFormContentType = new MultipartFormContentType();
                contentType = multipartFormContentType;
                for (Map.Entry<String, String> entry : parameters.getFiles().entrySet()) {
                    multipartFormContentType.setFormFile(entry.getKey(), new File(entry.getValue()));
                }
            } else {
                contentType = new UrlEncodedFormContentType();
            }
            for (Map.Entry entry : parameters.getParameters().entrySet()) {
                contentType.setFormContent((String)entry.getKey(), (String)entry.getValue());
            }
            HttpFormRequest request = new HttpFormRequest(invokeURL, (FormContentType)contentType);
            request.setAuthentication(this.username, this.password);
            if (this.userAgent != null) {
                request.addRequestProperty("User-Agent", this.userAgent);
            }
            request.setLogger(this.getLogger());
            result = request.post();
        }
        if (!result.isSuccessful()) {
            if (result.getResponseCode() == 401) {
                throw new DaemonException("The username and password you provided are not correct (error 401): " + this.extractErrorMessage(result.getResponseBody()));
            }
            if (result.getResponseCode() == 403) {
                throw new DaemonException("The username you provided is not allowed to use the text-based Cargo daemon (error 403): " + this.extractErrorMessage(result.getResponseBody()));
            }
            throw new DaemonException("Failed to call Cargo Daemon via URL [" + invokeURL + "], response code: " + result.getResponseCode() + ", response message: " + result.getResponseMessage() + ", response body: " + this.extractErrorMessage(result.getResponseBody()));
        }
        String response = result.getResponseBody();
        if (response == null || !response.startsWith("OK -")) {
            throw new DaemonException("Failed parsing response for " + invokeURL + ". Response was: " + this.extractErrorMessage(response));
        }
        return response;
    }

    private String extractErrorMessage(String response) {
        if (response != null) {
            String scriptEndString = "</script>";
            int scriptEnd = response.indexOf("</script>");
            if (scriptEnd != -1) {
                return response.substring(scriptEnd + "</script>".length()).trim();
            }
        }
        return response;
    }
}

