/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.PAS;
import jsr166y.forkjoin.ParallelDoubleArray;
import jsr166y.forkjoin.ParallelLongArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelArray<T>
implements Iterable<T> {
    final ForkJoinExecutor ex;
    T[] array;
    int limit;
    AsList listView;

    public static ForkJoinExecutor defaultExecutor() {
        return PAS.defaultExecutor();
    }

    protected ParallelArray(ForkJoinExecutor executor, T[] array, int limit) {
        if (executor == null || array == null) {
            throw new NullPointerException();
        }
        if (limit < 0 || limit > array.length) {
            throw new IllegalArgumentException();
        }
        this.ex = executor;
        this.array = array;
        this.limit = limit;
    }

    ParallelArray(ForkJoinExecutor executor, T[] array) {
        this.ex = executor;
        this.array = array;
        this.limit = array.length;
    }

    public static <T> ParallelArray<T> create(int size, Class<? super T> elementType, ForkJoinExecutor executor) {
        Object[] array = (Object[])Array.newInstance(elementType, size);
        return new ParallelArray<Object>(executor, array, size);
    }

    public static <T> ParallelArray<T> createUsingHandoff(T[] handoff, ForkJoinExecutor executor) {
        return new ParallelArray<T>(executor, handoff, handoff.length);
    }

    public static <T> ParallelArray<T> createFromCopy(T[] source, ForkJoinExecutor executor) {
        int size = source.length;
        Object[] array = (Object[])Array.newInstance(source.getClass().getComponentType(), size);
        System.arraycopy(source, 0, array, 0, size);
        return new ParallelArray<Object>(executor, array, size);
    }

    public static <T> ParallelArray<T> createFromCopy(int size, T[] source, ForkJoinExecutor executor) {
        Object[] array = (Object[])Array.newInstance(source.getClass().getComponentType(), size);
        System.arraycopy(source, 0, array, 0, Math.min(source.length, size));
        return new ParallelArray<Object>(executor, array, size);
    }

    public static <T> ParallelArray<T> createEmpty(int size, Class<? super T> elementType, ForkJoinExecutor executor) {
        Object[] array = (Object[])Array.newInstance(elementType, size);
        return new ParallelArray<Object>(executor, array, 0);
    }

    public ForkJoinExecutor getExecutor() {
        return this.ex;
    }

    public void apply(Ops.Procedure<? super T> procedure) {
        new WithBounds<T>(this).apply(procedure);
    }

    public T reduce(Ops.Reducer<T> reducer, T base) {
        return new WithBounds<T>(this).reduce(reducer, base);
    }

    public ParallelArray<T> all() {
        return new WithBounds(this).all();
    }

    public ParallelArray<T> all(Class<? super T> elementType) {
        return new WithBounds<T>(this).all(elementType);
    }

    public <U, V> ParallelArray<V> combine(U[] other, Ops.Combiner<? super T, ? super U, ? extends V> combiner) {
        return new WithBounds<T>(this).combine(other, combiner);
    }

    public <U, V> ParallelArray<V> combine(ParallelArray<? extends U> other, Ops.Combiner<? super T, ? super U, ? extends V> combiner) {
        return new WithBounds<T>(this).combine(other, combiner);
    }

    public <U, V> ParallelArray<V> combine(U[] other, Ops.Combiner<? super T, ? super U, ? extends V> combiner, Class<? super V> elementType) {
        return new WithBounds<T>(this).combine(other, combiner, elementType);
    }

    public <U, V> ParallelArray<V> combine(WithBounds<? extends U> other, Ops.Combiner<? super T, ? super U, ? extends V> combiner) {
        return new WithBounds<T>(this).combine(other, combiner);
    }

    public <U, V> ParallelArray<V> combine(WithBounds<? extends U> other, Ops.Combiner<? super T, ? super U, ? extends V> combiner, Class<? super V> elementType) {
        return new WithBounds<T>(this).combine(other, combiner, elementType);
    }

    public <U, V> ParallelArray<V> combine(ParallelArray<? extends U> other, Ops.Combiner<? super T, ? super U, ? extends V> combiner, Class<? super V> elementType) {
        return new WithBounds<T>(this).combine(other.array, combiner, elementType);
    }

    public void replaceWithTransform(Ops.Mapper<? super T, ? extends T> mapper) {
        new WithBounds<T>(this).replaceWithTransform(mapper);
    }

    public void replaceWithMappedIndex(Ops.MapperFromInt<? extends T> mapper) {
        new WithBounds<T>(this).replaceWithMappedIndex(mapper);
    }

    public void replaceWithGeneratedValue(Ops.Generator<? extends T> generator) {
        new WithBounds<T>(this).replaceWithGeneratedValue(generator);
    }

    public void replaceWithValue(T value) {
        new WithBounds<T>(this).replaceWithValue(value);
    }

    public void replaceWithCombination(ParallelArray<? extends T> other, Ops.Reducer<T> combiner) {
        new WithBounds<T>(this).replaceWithCombination(other.array, combiner);
    }

    public void replaceWithCombination(T[] other, Ops.Reducer<T> combiner) {
        new WithBounds<T>(this).replaceWithCombination(other, combiner);
    }

    public void replaceWithCombination(WithBounds<? extends T> other, Ops.Reducer<T> combiner) {
        new WithBounds<T>(this).replaceWithCombination(other, combiner);
    }

    public int indexOf(T target) {
        return new WithBounds<T>(this).indexOf(target);
    }

    public int binarySearch(T target) {
        int lo = 0;
        int hi = this.limit - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int c = ((Comparable)target).compareTo((Comparable)this.array[mid]);
            if (c == 0) {
                return mid;
            }
            if (c < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -1;
    }

    public int binarySearch(T target, Comparator<? super T> comparator) {
        int lo = 0;
        int hi = this.limit - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int c = comparator.compare(target, this.array[mid]);
            if (c == 0) {
                return mid;
            }
            if (c < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -1;
    }

    public SummaryStatistics<T> summary(Comparator<? super T> comparator) {
        return new WithBounds<T>(this).summary(comparator);
    }

    public SummaryStatistics<T> summary() {
        return new WithBounds(this).summary();
    }

    public T min(Comparator<? super T> comparator) {
        return new WithBounds<T>(this).min(comparator);
    }

    public T min() {
        return new WithBounds(this).min();
    }

    public T max(Comparator<? super T> comparator) {
        return new WithBounds<T>(this).max(comparator);
    }

    public T max() {
        return new WithBounds(this).max();
    }

    public void cumulate(Ops.Reducer<T> reducer, T base) {
        new WithBounds<T>(this).cumulate(reducer, base);
    }

    public T precumulate(Ops.Reducer<T> reducer, T base) {
        return new WithBounds<T>(this).precumulate(reducer, base);
    }

    public void sort(Comparator<? super T> comparator) {
        new WithBounds<T>(this).sort(comparator);
    }

    public void sort() {
        new WithBounds(this).sort();
    }

    public void removeConsecutiveDuplicates() {
        new WithBounds(this).removeConsecutiveDuplicates();
    }

    public void removeNulls() {
        new WithBounds(this).removeNulls();
    }

    public ParallelArray<T> allUniqueElements() {
        return new WithBounds(this).allUniqueElements();
    }

    public ParallelArray<T> allNonidenticalElements() {
        return new WithBounds(this).allNonidenticalElements();
    }

    public WithBounds<T> withBounds(int firstIndex, int upperBound) {
        if (firstIndex > upperBound) {
            throw new IllegalArgumentException("firstIndex(" + firstIndex + ") > upperBound(" + upperBound + ")");
        }
        if (firstIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(firstIndex);
        }
        if (upperBound > this.limit) {
            throw new ArrayIndexOutOfBoundsException(upperBound);
        }
        return new WithBounds(this, firstIndex, upperBound);
    }

    public WithFilter<T> withFilter(Ops.Predicate<? super T> selector) {
        return new WithBoundedFilter<T>(this, 0, this.limit, selector);
    }

    public <U> WithMapping<T, U> withMapping(Ops.Mapper<? super T, ? extends U> mapper) {
        return new WithBoundedMapping<T, U>(this, 0, this.limit, mapper);
    }

    public WithDoubleMapping<T> withMapping(Ops.MapperToDouble<? super T> mapper) {
        return new WithBoundedDoubleMapping<T>(this, 0, this.limit, mapper);
    }

    public WithLongMapping<T> withMapping(Ops.MapperToLong<? super T> mapper) {
        return new WithBoundedLongMapping<T>(this, 0, this.limit, mapper);
    }

    @Override
    public Iterator<T> iterator() {
        return new ParallelArrayIterator<T>(this.array, this.limit);
    }

    public List<T> asList() {
        AsList lv = this.listView;
        if (lv == null) {
            this.listView = lv = new AsList();
        }
        return lv;
    }

    public int size() {
        return this.limit;
    }

    public T get(int i) {
        return this.array[i];
    }

    public void set(int i, T x) {
        this.array[i] = x;
    }

    public T[] getArray() {
        return this.array;
    }

    public String toString() {
        return this.asList().toString();
    }

    public void addAll(T[] other) {
        int csize = other.length;
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other, 0, this.array, end, csize);
    }

    public void addAll(ParallelArray<T> other) {
        int csize = other.size();
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other.array, 0, this.array, end, csize);
    }

    public void addAll(WithBounds<T> other) {
        int csize = other.size();
        int end = this.limit;
        this.insertSlotsAt(end, csize);
        System.arraycopy(other.pa.array, other.firstIndex, this.array, end, csize);
    }

    public final void setLimit(int newLimit) {
        if (newLimit < 0) {
            throw new IllegalArgumentException();
        }
        int cap = this.array.length;
        if (newLimit > cap) {
            this.resizeArray(newLimit);
        }
        this.limit = newLimit;
    }

    final void replaceElementsWith(T[] a) {
        System.arraycopy(a, 0, this.array, 0, a.length);
        this.limit = a.length;
    }

    final void resizeArray(int newCap) {
        int cap = this.array.length;
        if (newCap > cap) {
            Class<?> elementType = this.array.getClass().getComponentType();
            Object[] a = (Object[])Array.newInstance(elementType, newCap);
            System.arraycopy(this.array, 0, a, 0, cap);
            this.array = a;
        }
    }

    final void insertElementAt(int index, T e) {
        int hi;
        if ((hi = this.limit++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        if (hi > index) {
            System.arraycopy(this.array, index, this.array, index + 1, hi - index);
        }
        this.array[index] = e;
    }

    final void appendElement(T e) {
        int hi;
        if ((hi = this.limit++) >= this.array.length) {
            this.resizeArray(hi * 3 / 2 + 1);
        }
        this.array[hi] = e;
    }

    final void insertSlotsAt(int index, int len) {
        if (len <= 0) {
            return;
        }
        int cap = this.array.length;
        int newSize = this.limit + len;
        if (cap < newSize) {
            if ((cap = cap * 3 / 2 + 1) < newSize) {
                cap = newSize;
            }
            this.resizeArray(cap);
        }
        if (index < this.limit) {
            System.arraycopy(this.array, index, this.array, index + len, this.limit - index);
        }
        this.limit = newSize;
    }

    final void removeSlotAt(int index) {
        System.arraycopy(this.array, index + 1, this.array, index, this.limit - index - 1);
        this.array[--this.limit] = null;
    }

    final void removeSlotsAt(int fromIndex, int toIndex) {
        if (fromIndex < toIndex) {
            int newSize;
            int size = this.limit;
            System.arraycopy(this.array, toIndex, this.array, fromIndex, size - toIndex);
            this.limit = newSize = size - (toIndex - fromIndex);
            while (size > newSize) {
                this.array[--size] = null;
            }
        }
    }

    final int seqIndexOf(Object target) {
        T[] arr = this.array;
        int fence = this.limit;
        if (target == null) {
            for (int i = 0; i < fence; ++i) {
                if (arr[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < fence; ++i) {
                if (!target.equals(arr[i])) continue;
                return i;
            }
        }
        return -1;
    }

    final int seqLastIndexOf(Object target) {
        T[] arr = this.array;
        int last = this.limit - 1;
        if (target == null) {
            for (int i = last; i >= 0; --i) {
                if (arr[i] != null) continue;
                return i;
            }
        } else {
            for (int i = last; i >= 0; --i) {
                if (!target.equals(arr[i])) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AsList
    extends AbstractList<T>
    implements RandomAccess {
        AsList() {
        }

        @Override
        public T get(int i) {
            if (i >= ParallelArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            return ParallelArray.this.array[i];
        }

        @Override
        public T set(int i, T x) {
            if (i >= ParallelArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            T[] arr = ParallelArray.this.array;
            Object t = arr[i];
            arr[i] = x;
            return t;
        }

        @Override
        public boolean isEmpty() {
            return ParallelArray.this.limit == 0;
        }

        @Override
        public int size() {
            return ParallelArray.this.limit;
        }

        @Override
        public Iterator<T> iterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<T> listIterator() {
            return new ListIter(0);
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            if (index < 0 || index > ParallelArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            return new ListIter(index);
        }

        @Override
        public boolean add(T e) {
            ParallelArray.this.appendElement(e);
            return true;
        }

        @Override
        public void add(int index, T e) {
            if (index < 0 || index > ParallelArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            ParallelArray.this.insertElementAt(index, e);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            int hi = ParallelArray.this.limit;
            ParallelArray.this.setLimit(hi + csize);
            T[] arr = ParallelArray.this.array;
            for (Object e : c) {
                arr[hi++] = e;
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            if (index < 0 || index > ParallelArray.this.limit) {
                throw new IndexOutOfBoundsException();
            }
            int csize = c.size();
            if (csize == 0) {
                return false;
            }
            ParallelArray.this.insertSlotsAt(index, csize);
            T[] arr = ParallelArray.this.array;
            for (Object e : c) {
                arr[index++] = e;
            }
            return true;
        }

        @Override
        public void clear() {
            T[] arr = ParallelArray.this.array;
            for (int i = 0; i < ParallelArray.this.limit; ++i) {
                arr[i] = null;
            }
            ParallelArray.this.limit = 0;
        }

        @Override
        public boolean remove(Object o) {
            int idx = ParallelArray.this.seqIndexOf(o);
            if (idx < 0) {
                return false;
            }
            ParallelArray.this.removeSlotAt(idx);
            return true;
        }

        @Override
        public T remove(int index) {
            Object oldValue = this.get(index);
            ParallelArray.this.removeSlotAt(index);
            return oldValue;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            ParallelArray.this.removeSlotsAt(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            return ParallelArray.this.seqIndexOf(o) >= 0;
        }

        @Override
        public int indexOf(Object o) {
            return ParallelArray.this.seqIndexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return ParallelArray.this.seqLastIndexOf(o);
        }

        @Override
        public Object[] toArray() {
            int len = ParallelArray.this.limit;
            Object[] a = new Object[len];
            System.arraycopy(ParallelArray.this.array, 0, a, 0, len);
            return a;
        }

        @Override
        public <V> V[] toArray(V[] a) {
            int len = ParallelArray.this.limit;
            if (a.length < len) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, len);
            }
            System.arraycopy(ParallelArray.this.array, 0, a, 0, len);
            if (a.length > len) {
                a[len] = null;
            }
            return a;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ListIter
    implements ListIterator<T> {
        int cursor;
        int lastRet;
        T[] arr;
        int hi;

        ListIter(int lo) {
            this.cursor = lo;
            this.lastRet = -1;
            this.arr = ParallelArray.this.array;
            this.hi = ParallelArray.this.limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public T next() {
            int i = this.cursor;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            Object next = this.arr[i];
            this.lastRet = i;
            this.cursor = i + 1;
            return next;
        }

        @Override
        public void remove() {
            int k = this.lastRet;
            if (k < 0) {
                throw new IllegalStateException();
            }
            ParallelArray.this.removeSlotAt(k);
            this.hi = ParallelArray.this.limit;
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public T previous() {
            int i = this.cursor - 1;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            Object previous = this.arr[i];
            this.lastRet = this.cursor = i;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(T e) {
            int i = this.lastRet;
            if (i < 0 || i >= this.hi) {
                throw new NoSuchElementException();
            }
            this.arr[i] = e;
        }

        @Override
        public void add(T e) {
            int i = this.cursor;
            ParallelArray.this.insertElementAt(i, e);
            this.arr = ParallelArray.this.array;
            this.hi = ParallelArray.this.limit;
            this.lastRet = -1;
            this.cursor = i + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ParallelArrayIterator<T>
    implements Iterator<T> {
        int cursor;
        final T[] arr;
        final int hi;

        ParallelArrayIterator(T[] a, int limit) {
            this.arr = a;
            this.hi = limit;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.hi;
        }

        @Override
        public T next() {
            if (this.cursor >= this.hi) {
                throw new NoSuchElementException();
            }
            return this.arr[this.cursor++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredLongMapping<T>
    extends WithLongMapping<T> {
        final Ops.Predicate<? super T> selector;

        WithBoundedFilteredLongMapping(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.Predicate<? super T> selector, Ops.MapperToLong<? super T> mapper) {
            super(pa, firstIndex, upperBound, mapper);
            this.selector = selector;
        }

        @Override
        public ParallelLongArray all() {
            PAS.FJLSelectAllDriver r = new PAS.FJLSelectAllDriver(this);
            this.ex.invoke(r);
            return new ParallelLongArray(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJRCountSelected f = new PAS.FJRCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJRSelectAny f = new PAS.FJRSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public WithDoubleMapping<T> withMapping(Ops.MapperFromLongToDouble mapper) {
            return new WithBoundedFilteredDoubleMapping<T>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping<T> withMapping(Ops.LongMapper mapper) {
            return new WithBoundedFilteredLongMapping<T>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<T, U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
            return new WithBoundedFilteredMapping<T, U>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            Ops.MapperToLong mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.Predicate sel = this.selector;
            Ops.MapperToLong mpr = this.mapper;
            boolean gotFirst = false;
            long r = base;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (!sel.evaluate(t)) continue;
                long y = mpr.map(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJLStats task) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            Ops.MapperToLong mpr = this.mapper;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (!sel.evaluate(t)) continue;
                ++count;
                long x = mpr.map(t);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedLongMapping<T>
    extends WithLongMapping<T> {
        WithBoundedLongMapping(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.MapperToLong<? super T> mapper) {
            super(pa, firstIndex, upperBound, mapper);
        }

        @Override
        public ParallelLongArray all() {
            long[] dest = new long[this.upperBound - this.firstIndex];
            PAS.FJLMap f = new PAS.FJLMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelLongArray(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public WithDoubleMapping<T> withMapping(Ops.MapperFromLongToDouble mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping<T> withMapping(Ops.LongMapper mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<T, U> withMapping(Ops.MapperFromLong<? extends U> mapper) {
            return new WithBoundedMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            T[] array = this.pa.array;
            Ops.MapperToLong mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            T[] array = this.pa.array;
            Ops.MapperToLong mpr = this.mapper;
            long r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJLStats task) {
            T[] array = this.pa.array;
            Ops.MapperToLong mpr = this.mapper;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                long x = mpr.map(array[i]);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithLongMapping<T>
    extends PAS.RPrefix {
        final Ops.MapperToLong<? super T> mapper;

        WithLongMapping(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.MapperToLong<? super T> mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        public void apply(Ops.LongProcedure procedure) {
            this.ex.invoke(new PAS.FJLApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public long reduce(Ops.LongReducer reducer, long base) {
            PAS.FJLReduce f = new PAS.FJLReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return f.result;
        }

        public long min() {
            return this.reduce(Ops.naturalLongMinReducer(), Long.MAX_VALUE);
        }

        public long min(Ops.LongComparator comparator) {
            return this.reduce(Ops.longMinReducer(comparator), Long.MAX_VALUE);
        }

        public long max() {
            return this.reduce(Ops.naturalLongMaxReducer(), Long.MIN_VALUE);
        }

        public long max(Ops.LongComparator comparator) {
            return this.reduce(Ops.longMaxReducer(comparator), Long.MIN_VALUE);
        }

        public long sum() {
            return this.reduce(Ops.longAdder(), 0L);
        }

        public ParallelLongArray.SummaryStatistics summary(Ops.LongComparator comparator) {
            PAS.FJLStats f = new PAS.FJLStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public ParallelLongArray.SummaryStatistics summary() {
            PAS.FJLStats f = new PAS.FJLStats(this, this.firstIndex, this.upperBound, null, Ops.naturalLongComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelLongArray all();

        public abstract int size();

        public abstract int anyIndex();

        public abstract WithDoubleMapping<T> withMapping(Ops.MapperFromLongToDouble var1);

        public abstract WithLongMapping<T> withMapping(Ops.LongMapper var1);

        public abstract <U> WithMapping<T, U> withMapping(Ops.MapperFromLong<? extends U> var1);

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            Ops.MapperToLong mpr = this.mapper;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            T[] array = this.pa.array;
            Ops.MapperToLong mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredDoubleMapping<T>
    extends WithDoubleMapping<T> {
        final Ops.Predicate<? super T> selector;

        WithBoundedFilteredDoubleMapping(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.Predicate<? super T> selector, Ops.MapperToDouble<? super T> mapper) {
            super(pa, firstIndex, upperBound, mapper);
            this.selector = selector;
        }

        @Override
        public ParallelDoubleArray all() {
            PAS.FJDSelectAllDriver r = new PAS.FJDSelectAllDriver(this);
            this.ex.invoke(r);
            return new ParallelDoubleArray(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJRCountSelected f = new PAS.FJRCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJRSelectAny f = new PAS.FJRSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public WithDoubleMapping<T> withMapping(Ops.DoubleMapper mapper) {
            return new WithBoundedFilteredDoubleMapping<T>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping<T> withMapping(Ops.MapperFromDoubleToLong mapper) {
            return new WithBoundedFilteredLongMapping<T>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<T, U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
            return new WithBoundedFilteredMapping<T, U>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            Ops.MapperToDouble mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.Predicate sel = this.selector;
            Ops.MapperToDouble mpr = this.mapper;
            boolean gotFirst = false;
            double r = base;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (!sel.evaluate(t)) continue;
                double y = mpr.map(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJDStats task) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            Ops.MapperToDouble mpr = this.mapper;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (!sel.evaluate(t)) continue;
                ++count;
                double x = mpr.map(t);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedDoubleMapping<T>
    extends WithDoubleMapping<T> {
        WithBoundedDoubleMapping(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.MapperToDouble<? super T> mapper) {
            super(pa, firstIndex, upperBound, mapper);
        }

        @Override
        public ParallelDoubleArray all() {
            double[] dest = new double[this.upperBound - this.firstIndex];
            PAS.FJDMap f = new PAS.FJDMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelDoubleArray(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public WithDoubleMapping<T> withMapping(Ops.DoubleMapper mapper) {
            return new WithBoundedDoubleMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping<T> withMapping(Ops.MapperFromDoubleToLong mapper) {
            return new WithBoundedLongMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public <U> WithMapping<T, U> withMapping(Ops.MapperFromDouble<? extends U> mapper) {
            return new WithBoundedMapping(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.MapperToDouble mpr = this.mapper;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            T[] array = this.pa.array;
            Ops.MapperToDouble mpr = this.mapper;
            double r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJDStats task) {
            T[] array = this.pa.array;
            Ops.MapperToDouble mpr = this.mapper;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                double x = mpr.map(array[i]);
                task.sum += x;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithDoubleMapping<T>
    extends PAS.RPrefix {
        final Ops.MapperToDouble<? super T> mapper;

        WithDoubleMapping(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.MapperToDouble<? super T> mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        public void apply(Ops.DoubleProcedure procedure) {
            this.ex.invoke(new PAS.FJDApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public double reduce(Ops.DoubleReducer reducer, double base) {
            PAS.FJDReduce f = new PAS.FJDReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return f.result;
        }

        public double min() {
            return this.reduce(Ops.naturalDoubleMinReducer(), Double.MAX_VALUE);
        }

        public double min(Ops.DoubleComparator comparator) {
            return this.reduce(Ops.doubleMinReducer(comparator), Double.MAX_VALUE);
        }

        public double max() {
            return this.reduce(Ops.naturalDoubleMaxReducer(), -1.7976931348623157E308);
        }

        public double max(Ops.DoubleComparator comparator) {
            return this.reduce(Ops.doubleMaxReducer(comparator), -1.7976931348623157E308);
        }

        public double sum() {
            return this.reduce(Ops.doubleAdder(), 0.0);
        }

        public ParallelDoubleArray.SummaryStatistics summary(Ops.DoubleComparator comparator) {
            PAS.FJDStats f = new PAS.FJDStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public ParallelDoubleArray.SummaryStatistics summary() {
            PAS.FJDStats f = new PAS.FJDStats(this, this.firstIndex, this.upperBound, null, Ops.naturalDoubleComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelDoubleArray all();

        public abstract int size();

        public abstract int anyIndex();

        public abstract WithDoubleMapping<T> withMapping(Ops.DoubleMapper var1);

        public abstract WithLongMapping<T> withMapping(Ops.MapperFromDoubleToLong var1);

        public abstract <U> WithMapping<T, U> withMapping(Ops.MapperFromDouble<? extends U> var1);

        @Override
        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            Ops.MapperToDouble mpr = this.mapper;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            T[] array = this.pa.array;
            Ops.MapperToDouble mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilteredMapping<T, U>
    extends WithMapping<T, U> {
        final Ops.Predicate<? super T> selector;
        final Ops.Mapper<? super T, ? extends U> mapper;

        WithBoundedFilteredMapping(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.Predicate<? super T> selector, Ops.Mapper<? super T, ? extends U> mapper) {
            super(pa, firstIndex, upperBound);
            this.selector = selector;
            this.mapper = mapper;
        }

        @Override
        public ParallelArray<U> all() {
            PAS.FJRSelectAllDriver r = new PAS.FJRSelectAllDriver(this, Object.class);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public ParallelArray<U> all(Class<? super U> elementType) {
            PAS.FJRSelectAllDriver r = new PAS.FJRSelectAllDriver(this, elementType);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJRCountSelected f = new PAS.FJRCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJRSelectAny f = new PAS.FJRSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public U any() {
            int idx = this.anyIndex();
            T[] array = this.pa.array;
            Ops.Mapper<? super T, ? extends U> mpr = this.mapper;
            return idx < 0 ? null : (U)mpr.map((T)array[idx]);
        }

        @Override
        public <V> WithMapping<T, V> withMapping(Ops.Mapper<? super U, ? extends V> mapper) {
            return new WithBoundedFilteredMapping<T, V>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping<T> withMapping(Ops.MapperToDouble<? super U> mapper) {
            return new WithBoundedFilteredDoubleMapping<T>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping<T> withMapping(Ops.MapperToLong<? super U> mapper) {
            return new WithBoundedFilteredLongMapping<T>(this.pa, this.firstIndex, this.upperBound, this.selector, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            Ops.Mapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(mpr.map(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            Ops.Mapper mpr = this.mapper;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                U y = mpr.map(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.combine(r, y);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJRStats task) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            Ops.Mapper mpr = this.mapper;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (!sel.evaluate(t)) continue;
                ++count;
                U x = mpr.map(t);
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            T[] array = this.pa.array;
            Ops.Mapper mpr = this.mapper;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            T[] array = this.pa.array;
            Ops.Mapper mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedMapping<T, U>
    extends WithMapping<T, U> {
        final Ops.Mapper<? super T, ? extends U> mapper;

        WithBoundedMapping(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.Mapper<? super T, ? extends U> mapper) {
            super(pa, firstIndex, upperBound);
            this.mapper = mapper;
        }

        @Override
        public ParallelArray<U> all() {
            int n = this.upperBound - this.firstIndex;
            Object[] dest = new Object[n];
            PAS.FJRMap f = new PAS.FJRMap(this, this.firstIndex, this.upperBound, null, dest, this.firstIndex);
            this.ex.invoke(f);
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public ParallelArray<U> all(Class<? super U> elementType) {
            int n = this.upperBound - this.firstIndex;
            Object[] dest = (Object[])Array.newInstance(elementType, n);
            PAS.FJRMap f = new PAS.FJRMap(this, this.firstIndex, this.upperBound, null, dest, 0);
            this.ex.invoke(f);
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public U any() {
            Ops.Mapper<? super T, ? extends U> mpr = this.mapper;
            T[] array = this.pa.array;
            return this.firstIndex < this.upperBound ? (U)mpr.map((T)array[this.firstIndex]) : null;
        }

        @Override
        public <V> WithMapping<T, V> withMapping(Ops.Mapper<? super U, ? extends V> mapper) {
            return new WithBoundedMapping<T, V>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithDoubleMapping<T> withMapping(Ops.MapperToDouble<? super U> mapper) {
            return new WithBoundedDoubleMapping<T>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        public WithLongMapping<T> withMapping(Ops.MapperToLong<? super U> mapper) {
            return new WithBoundedLongMapping<T>(this.pa, this.firstIndex, this.upperBound, Ops.compoundMapper(this.mapper, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.Mapper mpr = this.mapper;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(mpr.map(array[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            T[] array = this.pa.array;
            Ops.Mapper mpr = this.mapper;
            U r = mpr.map(array[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, mpr.map(array[i]));
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJRStats task) {
            T[] array = this.pa.array;
            Ops.Mapper mpr = this.mapper;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                U x = mpr.map(array[i]);
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }

        @Override
        void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            Ops.Mapper mpr = this.mapper;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = mpr.map(array[i]);
            }
        }

        @Override
        void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            T[] array = this.pa.array;
            Ops.Mapper mpr = this.mapper;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = mpr.map(array[indices[i]]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class WithBoundedFilter<T>
    extends WithFilter<T> {
        final Ops.Predicate<? super T> selector;

        WithBoundedFilter(ParallelArray<T> pa, int firstIndex, int upperBound, Ops.Predicate<? super T> selector) {
            super(pa, firstIndex, upperBound);
            this.selector = selector;
        }

        @Override
        public WithFilter<T> withFilter(Ops.Predicate<? super T> selector) {
            return new WithBoundedFilter<T>(this.pa, this.firstIndex, this.upperBound, Ops.andPredicate(this.selector, selector));
        }

        @Override
        public WithFilter<T> orFilter(Ops.Predicate<? super T> selector) {
            return new WithBoundedFilter<T>(this.pa, this.firstIndex, this.upperBound, Ops.orPredicate(this.selector, selector));
        }

        @Override
        public <U> WithMapping<T, U> withMapping(Ops.Mapper<? super T, ? extends U> mapper) {
            return new WithBoundedFilteredMapping<T, U>(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public WithDoubleMapping<T> withMapping(Ops.MapperToDouble<? super T> mapper) {
            return new WithBoundedFilteredDoubleMapping<T>(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public WithLongMapping<T> withMapping(Ops.MapperToLong<? super T> mapper) {
            return new WithBoundedFilteredLongMapping<T>(this.pa, this.firstIndex, this.upperBound, this.selector, mapper);
        }

        @Override
        public int anyIndex() {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJRSelectAny f = new PAS.FJRSelectAny(this, this.firstIndex, this.upperBound, null, result, this.selector);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public T any() {
            int idx = this.anyIndex();
            T[] array = this.pa.array;
            return idx < 0 ? null : (T)array[idx];
        }

        @Override
        public ParallelArray<T> all() {
            T[] array = this.pa.array;
            Class<?> elementType = array.getClass().getComponentType();
            PAS.FJRSelectAllDriver r = new PAS.FJRSelectAllDriver(this, elementType);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public ParallelArray<T> all(Class<? super T> elementType) {
            PAS.FJRSelectAllDriver r = new PAS.FJRSelectAllDriver(this, elementType);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public int size() {
            PAS.FJRCountSelected f = new PAS.FJRCountSelected(this, this.firstIndex, this.upperBound, null, this.selector);
            this.ex.invoke(f);
            return f.count;
        }

        @Override
        public ParallelArray<T> allUniqueElements() {
            PAS.RUniquifierTable tab = new PAS.RUniquifierTable(this.upperBound - this.firstIndex, this.pa.array, this.selector, false);
            PAS.FJUniquifier f = new PAS.FJUniquifier(this, this.firstIndex, this.upperBound, null, tab);
            this.ex.invoke(f);
            Object[] res = tab.uniqueElements(f.count);
            return new ParallelArray<Object>(this.ex, res);
        }

        @Override
        public ParallelArray<T> allNonidenticalElements() {
            PAS.RUniquifierTable tab = new PAS.RUniquifierTable(this.upperBound - this.firstIndex, this.pa.array, this.selector, true);
            PAS.FJUniquifier f = new PAS.FJUniquifier(this, this.firstIndex, this.upperBound, null, tab);
            this.ex.invoke(f);
            Object[] res = tab.uniqueElements(f.count);
            return new ParallelArray<Object>(this.ex, res);
        }

        @Override
        public void removeAll() {
            PAS.FJRemoveAllDriver f = new PAS.FJRemoveAllDriver(this, this.firstIndex, this.upperBound);
            this.ex.invoke(f);
            this.pa.removeSlotsAt(f.offset, this.upperBound);
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                procedure.apply(x);
            }
        }

        @Override
        void leafTransform(int lo, int hi, Ops.Mapper mapper) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = mapper.map(x);
            }
        }

        @Override
        void leafIndexMap(int lo, int hi, Ops.MapperFromInt mapper) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = mapper.map(i);
            }
        }

        @Override
        void leafGenerate(int lo, int hi, Ops.Generator generator) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = generator.generate();
            }
        }

        @Override
        void leafFillValue(int lo, int hi, Object value) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = value;
            }
        }

        @Override
        void leafCombineInPlace(int lo, int hi, Object[] other, int otherOffset, Ops.Reducer combiner) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                array[i] = combiner.combine(x, other[i + otherOffset]);
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.Predicate sel = this.selector;
            boolean gotFirst = false;
            Object r = base;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.combine(r, x);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJRStats task) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            int count = 0;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                if (!sel.evaluate(x)) continue;
                ++count;
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
            task.size = count;
        }

        @Override
        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            int k = 0;
            for (int i = lo; i < hi; ++i) {
                if (sel.evaluate(array[i]) != positive) continue;
                indices[lo + k++] = i;
            }
            return k;
        }

        @Override
        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            Ops.Predicate sel = this.selector;
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                Object t = array[i];
                if (sel.evaluate(t) != positive) continue;
                array[offset++] = t;
            }
            return offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WithBounds<T>
    extends WithFilter<T> {
        WithBounds(ParallelArray<T> pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        WithBounds(ParallelArray<T> pa) {
            super(pa, 0, pa.limit);
        }

        public WithBounds<T> withBounds(int firstIndex, int upperBound) {
            if (firstIndex > upperBound) {
                throw new IllegalArgumentException("firstIndex(" + firstIndex + ") > upperBound(" + upperBound + ")");
            }
            if (firstIndex < 0) {
                throw new ArrayIndexOutOfBoundsException(firstIndex);
            }
            if (upperBound - firstIndex > this.upperBound - this.firstIndex) {
                throw new ArrayIndexOutOfBoundsException(upperBound);
            }
            return new WithBounds<T>(this.pa, this.firstIndex + firstIndex, this.firstIndex + upperBound);
        }

        @Override
        public WithFilter<T> withFilter(Ops.Predicate<? super T> selector) {
            return new WithBoundedFilter<T>(this.pa, this.firstIndex, this.upperBound, selector);
        }

        @Override
        public <U> WithMapping<T, U> withMapping(Ops.Mapper<? super T, ? extends U> mapper) {
            return new WithBoundedMapping<T, U>(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithDoubleMapping<T> withMapping(Ops.MapperToDouble<? super T> mapper) {
            return new WithBoundedDoubleMapping<T>(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithLongMapping<T> withMapping(Ops.MapperToLong<? super T> mapper) {
            return new WithBoundedLongMapping<T>(this.pa, this.firstIndex, this.upperBound, mapper);
        }

        @Override
        public WithFilter<T> orFilter(Ops.Predicate<? super T> selector) {
            return new WithBoundedFilter<T>(this.pa, this.firstIndex, this.upperBound, selector);
        }

        @Override
        public int anyIndex() {
            return this.firstIndex < this.upperBound ? this.firstIndex : -1;
        }

        @Override
        public T any() {
            return this.firstIndex < this.upperBound ? (T)this.pa.array[this.firstIndex] : null;
        }

        public <U, V> ParallelArray<V> combine(U[] other, Ops.Combiner<? super T, ? super U, ? extends V> combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.length < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Object[] dest = new Object[size];
            this.ex.invoke(new PAS.FJRCombine(this, this.firstIndex, this.upperBound, null, other, -this.firstIndex, dest, combiner));
            return new ParallelArray<Object>(this.ex, dest);
        }

        public <U, V> ParallelArray<V> combine(U[] other, Ops.Combiner<? super T, ? super U, ? extends V> combiner, Class<? super V> elementType) {
            int size = this.upperBound - this.firstIndex;
            if (other.length < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Object[] dest = (Object[])Array.newInstance(elementType, size);
            this.ex.invoke(new PAS.FJRCombine(this, this.firstIndex, this.upperBound, null, other, -this.firstIndex, dest, combiner));
            return new ParallelArray<Object>(this.ex, dest);
        }

        public <U, V> ParallelArray<V> combine(ParallelArray<? extends U> other, Ops.Combiner<? super T, ? super U, ? extends V> combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.size() < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Object[] dest = new Object[size];
            this.ex.invoke(new PAS.FJRCombine(this, this.firstIndex, this.upperBound, null, other.array, -this.firstIndex, dest, combiner));
            return new ParallelArray<Object>(this.ex, dest);
        }

        public <U, V> ParallelArray<V> combine(ParallelArray<? extends U> other, Ops.Combiner<? super T, ? super U, ? extends V> combiner, Class<? super V> elementType) {
            int size = this.upperBound - this.firstIndex;
            if (other.size() < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Object[] dest = (Object[])Array.newInstance(elementType, size);
            this.ex.invoke(new PAS.FJRCombine(this, this.firstIndex, this.upperBound, null, other.array, -this.firstIndex, dest, combiner));
            return new ParallelArray<Object>(this.ex, dest);
        }

        public <U, V> ParallelArray<V> combine(WithBounds<? extends U> other, Ops.Combiner<? super T, ? super U, ? extends V> combiner) {
            int size = this.upperBound - this.firstIndex;
            if (other.size() < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Object[] dest = new Object[size];
            this.ex.invoke(new PAS.FJRCombine(this, this.firstIndex, this.upperBound, null, other.pa.array, other.firstIndex - this.firstIndex, dest, combiner));
            return new ParallelArray<Object>(this.ex, dest);
        }

        public <U, V> ParallelArray<V> combine(WithBounds<? extends U> other, Ops.Combiner<? super T, ? super U, ? extends V> combiner, Class<? super V> elementType) {
            int size = this.upperBound - this.firstIndex;
            if (other.size() < size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Object[] dest = (Object[])Array.newInstance(elementType, size);
            this.ex.invoke(new PAS.FJRCombine(this, this.firstIndex, this.upperBound, null, other.pa.array, other.firstIndex - this.firstIndex, dest, combiner));
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public ParallelArray<T> all() {
            T[] array = this.pa.array;
            int size = this.upperBound - this.firstIndex;
            Object[] dest = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            System.arraycopy(array, this.firstIndex, dest, 0, size);
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public ParallelArray<T> all(Class<? super T> elementType) {
            T[] array = this.pa.array;
            int size = this.upperBound - this.firstIndex;
            Object[] dest = (Object[])Array.newInstance(elementType, size);
            System.arraycopy(array, this.firstIndex, dest, 0, size);
            return new ParallelArray<Object>(this.ex, dest);
        }

        @Override
        public ParallelArray<T> allUniqueElements() {
            PAS.RUniquifierTable tab = new PAS.RUniquifierTable(this.upperBound - this.firstIndex, this.pa.array, null, false);
            PAS.FJUniquifier f = new PAS.FJUniquifier(this, this.firstIndex, this.upperBound, null, tab);
            this.ex.invoke(f);
            Object[] res = tab.uniqueElements(f.count);
            return new ParallelArray<Object>(this.ex, res);
        }

        @Override
        public ParallelArray<T> allNonidenticalElements() {
            PAS.RUniquifierTable tab = new PAS.RUniquifierTable(this.upperBound - this.firstIndex, this.pa.array, null, true);
            PAS.FJUniquifier f = new PAS.FJUniquifier(this, this.firstIndex, this.upperBound, null, tab);
            this.ex.invoke(f);
            Object[] res = tab.uniqueElements(f.count);
            return new ParallelArray<Object>(this.ex, res);
        }

        public int indexOf(T target) {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJRIndexOf f = new PAS.FJRIndexOf(this, this.firstIndex, this.upperBound, null, result, target);
            this.ex.invoke(f);
            return result.get();
        }

        public int binarySearch(T target) {
            T[] array = this.pa.array;
            int lo = this.firstIndex;
            int hi = this.upperBound - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int c = ((Comparable)target).compareTo((Comparable)array[mid]);
                if (c == 0) {
                    return mid;
                }
                if (c < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        public int binarySearch(T target, Comparator<? super T> comparator) {
            Comparator<T> cmp = comparator;
            T[] array = this.pa.array;
            int lo = this.firstIndex;
            int hi = this.upperBound - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int c = cmp.compare(target, array[mid]);
                if (c == 0) {
                    return mid;
                }
                if (c < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public int size() {
            return this.upperBound - this.firstIndex;
        }

        public void cumulate(Ops.Reducer<T> reducer, T base) {
            PAS.FJRCumulateOp op = new PAS.FJRCumulateOp(this, reducer, base);
            PAS.FJRScan r = new PAS.FJRScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
        }

        public T precumulate(Ops.Reducer<T> reducer, T base) {
            PAS.FJRPrecumulateOp op = new PAS.FJRPrecumulateOp(this, reducer, base);
            PAS.FJRScan r = new PAS.FJRScan(null, op, this.firstIndex, this.upperBound);
            this.ex.invoke(r);
            return (T)r.out;
        }

        public void sort(Comparator<? super T> cmp) {
            Object[] array = this.pa.array;
            Class<?> tc = array.getClass().getComponentType();
            Object[] ws = (Object[])Array.newInstance(tc, this.upperBound);
            this.ex.invoke(new PAS.FJRSorter(cmp, array, ws, this.firstIndex, this.upperBound - this.firstIndex, this.threshold));
        }

        public void sort() {
            T[] array = this.pa.array;
            Class<?> tc = array.getClass().getComponentType();
            if (!Comparable.class.isAssignableFrom(tc)) {
                this.sort(Ops.castedComparator());
                return;
            }
            Comparable[] ca = (Comparable[])array;
            Comparable[] ws = (Comparable[])Array.newInstance(tc, this.upperBound);
            this.pa.ex.invoke(new PAS.FJRCSorter(ca, ws, this.firstIndex, this.upperBound - this.firstIndex, this.threshold));
        }

        @Override
        public void removeAll() {
            this.pa.removeSlotsAt(this.firstIndex, this.upperBound);
        }

        public void removeConsecutiveDuplicates() {
            int k = this.firstIndex;
            int n = this.upperBound;
            T[] arr = this.pa.array;
            Object last = null;
            for (int i = k; i < n; ++i) {
                Object x = arr[i];
                if (x == null || last != null && last.equals(x)) continue;
                int n2 = k++;
                last = x;
                arr[n2] = last;
            }
            this.pa.removeSlotsAt(k, n);
        }

        public void removeNulls() {
            int k = this.firstIndex;
            int n = this.upperBound;
            T[] arr = this.pa.array;
            for (int i = k; i < n; ++i) {
                Object x = arr[i];
                if (x == null) continue;
                arr[k++] = x;
            }
            this.pa.removeSlotsAt(k, n);
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                procedure.apply(array[i]);
            }
        }

        @Override
        void leafTransform(int lo, int hi, Ops.Mapper mapper) {
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = mapper.map(array[i]);
            }
        }

        @Override
        void leafIndexMap(int lo, int hi, Ops.MapperFromInt mapper) {
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = mapper.map(i);
            }
        }

        @Override
        void leafGenerate(int lo, int hi, Ops.Generator generator) {
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = generator.generate();
            }
        }

        @Override
        void leafFillValue(int lo, int hi, Object value) {
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = value;
            }
        }

        @Override
        void leafCombineInPlace(int lo, int hi, Object[] other, int otherOffset, Ops.Reducer combiner) {
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                array[i] = combiner.combine(array[i], other[i + otherOffset]);
            }
        }

        @Override
        void leafCombine(int lo, int hi, Object[] other, int otherOffset, Object[] dest, Ops.Combiner combiner) {
            T[] array = this.pa.array;
            int k = lo - this.firstIndex;
            for (int i = lo; i < hi; ++i) {
                dest[k] = combiner.combine(array[i], other[i + otherOffset]);
                ++k;
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            T[] array = this.pa.array;
            Object r = array[lo];
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.combine(r, array[i]);
            }
            return r;
        }

        @Override
        void leafStats(int lo, int hi, PAS.FJRStats task) {
            T[] array = this.pa.array;
            task.size = hi - lo;
            for (int i = lo; i < hi; ++i) {
                Object x = array[i];
                task.updateMin(i, x);
                task.updateMax(i, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithFilter<T>
    extends WithMapping<T, T> {
        WithFilter(ParallelArray<T> pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        @Override
        public void apply(Ops.Procedure<? super T> procedure) {
            this.ex.invoke(new PAS.FJRApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        @Override
        public T reduce(Ops.Reducer<T> reducer, T base) {
            PAS.FJRReduce f = new PAS.FJRReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return (T)f.result;
        }

        @Override
        public T min(Comparator<? super T> comparator) {
            return this.reduce(Ops.minReducer(comparator), (T)null);
        }

        @Override
        public T min() {
            return this.reduce(Ops.castedMinReducer(), (T)null);
        }

        @Override
        public T max(Comparator<? super T> comparator) {
            return this.reduce(Ops.maxReducer(comparator), (T)null);
        }

        @Override
        public T max() {
            return this.reduce(Ops.castedMaxReducer(), (T)null);
        }

        @Override
        public SummaryStatistics<T> summary(Comparator<? super T> comparator) {
            PAS.FJRStats f = new PAS.FJRStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        @Override
        public SummaryStatistics<T> summary() {
            PAS.FJRStats f = new PAS.FJRStats(this, this.firstIndex, this.upperBound, null, Ops.castedComparator());
            this.ex.invoke(f);
            return f;
        }

        public void replaceWithTransform(Ops.Mapper<? super T, ? extends T> mapper) {
            this.ex.invoke(new PAS.FJRTransform(this, this.firstIndex, this.upperBound, null, mapper));
        }

        public void replaceWithMappedIndex(Ops.MapperFromInt<? extends T> mapper) {
            this.ex.invoke(new PAS.FJRIndexMap(this, this.firstIndex, this.upperBound, null, mapper));
        }

        public void replaceWithGeneratedValue(Ops.Generator<? extends T> generator) {
            this.ex.invoke(new PAS.FJRGenerate(this, this.firstIndex, this.upperBound, null, generator));
        }

        public void replaceWithValue(T value) {
            this.ex.invoke(new PAS.FJRFill(this, this.firstIndex, this.upperBound, null, value));
        }

        public void replaceWithCombination(ParallelArray<? extends T> other, Ops.Reducer<T> combiner) {
            if (other.size() < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJRCombineInPlace(this, this.firstIndex, this.upperBound, null, other.array, 0, combiner));
        }

        public void replaceWithCombination(WithBounds<? extends T> other, Ops.Reducer<T> combiner) {
            if (other.size() < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJRCombineInPlace(this, this.firstIndex, this.upperBound, null, other.pa.array, other.firstIndex - this.firstIndex, combiner));
        }

        public void replaceWithCombination(T[] other, Ops.Reducer<T> combiner) {
            if (other.length < this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.ex.invoke(new PAS.FJRCombineInPlace(this, this.firstIndex, this.upperBound, null, other, -this.firstIndex, combiner));
        }

        public abstract void removeAll();

        public abstract ParallelArray<T> allUniqueElements();

        public abstract ParallelArray<T> allNonidenticalElements();

        public abstract WithFilter<T> withFilter(Ops.Predicate<? super T> var1);

        public abstract WithFilter<T> orFilter(Ops.Predicate<? super T> var1);

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            T[] array = this.pa.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = array[i];
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            T[] array = this.pa.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = array[indices[i]];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WithMapping<T, U>
    extends PAS.RPrefix {
        WithMapping(ParallelArray<T> pa, int firstIndex, int upperBound) {
            super(pa, firstIndex, upperBound);
        }

        public void apply(Ops.Procedure<? super U> procedure) {
            this.ex.invoke(new PAS.FJRApply(this, this.firstIndex, this.upperBound, null, procedure));
        }

        public U reduce(Ops.Reducer<U> reducer, U base) {
            PAS.FJRReduce f = new PAS.FJRReduce(this, this.firstIndex, this.upperBound, null, reducer, base);
            this.ex.invoke(f);
            return (U)f.result;
        }

        public abstract int anyIndex();

        public abstract U any();

        public U min(Comparator<? super U> comparator) {
            return this.reduce(Ops.minReducer(comparator), null);
        }

        public U min() {
            return this.reduce(Ops.castedMinReducer(), null);
        }

        public U max(Comparator<? super U> comparator) {
            return this.reduce(Ops.maxReducer(comparator), null);
        }

        public U max() {
            return this.reduce(Ops.castedMaxReducer(), null);
        }

        public SummaryStatistics<U> summary(Comparator<? super U> comparator) {
            PAS.FJRStats f = new PAS.FJRStats(this, this.firstIndex, this.upperBound, null, comparator);
            this.ex.invoke(f);
            return f;
        }

        public SummaryStatistics<U> summary() {
            PAS.FJRStats f = new PAS.FJRStats(this, this.firstIndex, this.upperBound, null, Ops.castedComparator());
            this.ex.invoke(f);
            return f;
        }

        public abstract ParallelArray<U> all();

        public abstract ParallelArray<U> all(Class<? super U> var1);

        public abstract int size();

        public abstract <V> WithMapping<T, V> withMapping(Ops.Mapper<? super U, ? extends V> var1);

        public abstract WithDoubleMapping<T> withMapping(Ops.MapperToDouble<? super U> var1);

        public abstract WithLongMapping<T> withMapping(Ops.MapperToLong<? super U> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SummaryStatistics<T> {
        public int size();

        public T min();

        public T max();

        public int indexOfMin();

        public int indexOfMax();
    }
}

