/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.beans.QueryBean;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.models.RequestFieldMenu;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.chorem.vradi.ui.search.CriteriaUI;
import org.chorem.vradi.ui.search.SearchHandler;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.nuiton.i18n.I18n;

public class SearchUI
extends Table
implements JAXXObject {
    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_OFFER_LIST_UI = "offerListUI";
    public static final String PROPERTY_REQUEST = "request";
    public static final String PROPERTY_REQUEST_MODEL = "requestModel";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";
    public static final String BINDING_GROUPS_VISIBLE = "groups.visible";
    public static final String BINDING_REQUESTS_VISIBLE = "requests.visible";
    public static final String BINDING_REQUEST_AREA_TEXT = "requestArea.text";
    private static final String BINDING_$HIDOR_BUTTON0_VISIBLE = "$HidorButton0.visible";
    private static final String BINDING_$JLABEL0_VISIBLE = "$JLabel0.visible";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28TRxSeuNiJCaEhEZSKXwHMoUIal/44BRVIIODIgQonCNWXjnfH9qD1zjDzNtlcqv4J/RPKnQsSt56qHnruoRfEv4AQB66IN7trrzcsjqX1Ydcz773vffPmvc9+/oaUjSYXn7AwpDrwQQw43bz1+PGDzhPuwG1uHC0USE3iz0yJlNpk3h3tGyCX200bXk/C6+tyoKTP/bHo1SY5amDf46bPOQA5l41wjKm3RubVUAV6iDoilYf657u3pT/c35+VCAkVslvCo6wcFpWe5EiTlIQLZAkz7bK6x/we0tDC7yHfBbu37jFj7rMBf0p+I7NNUlFMIxiQS9MfOcKI4kMFZLa2zToe/xbLJnWPOn2p+YDuauYKGghqONNOn7ai105DqSiygnGaPw24wdSLlhi1ZGlMNnWal90u101hYKcB5ETquCalx5k/BtcXruVhlyfS7UXNTeBBRHFLutwD8kMezSgPHVgPQx8Mk6ZhKeKxhHeCtmI5hdTsIW96m3cZZsPideSaDA9EztU2m6zDPSzV0nhUvGudqiPfSk/LQGEvnsx4DpGzznMJpWh9IWtLrucakNOZPooBt4clSwMWapstR0vP+5n59la/yhBITdb9UnpRCYVbmjMgV22Ju6LLbWm12feBhcBDwF5j9GErWm/j2npbgCsH6X5nl7VsikrcSkCWM4zWAgDpW5+rKRuHaZA9zVR/327Vs+ayg72jcwwLtXvClTqGxLOfzynZmEc2uIpzAlwLhrd2ZcIorCduO42k8JqcyeRB8aCpeKTTPdMmZR3gNt5l+1O9eYimWGlOH1AaCxhZP5xa/v+v1y83hvKyjLlP5rqOqSOOvdJScQ3Cpv4y1pYAhFffYmq1TaqGeyitkXSezSHWSsxIDvPFQ2zD6T1m+ghRnn319z+nfv3vC1LaIEc9ydwNZv0bpAp9nN++9NxQ3bgZMTq2N4fPRcsNyBHbVDhN14XvCZ+vMED96ATAfwqxDGdzyjDi0qn++3659eLmsBQzSO3rz7qn5Sj/QipxtkhrExnN1dZ5ZXjgylQu8wR0xr7PqEQlbkTP9byzzu4KI3A0gBy/7jJgKx3hu9iQeFQbczc6g/3WmBqyHOmdNd/PBzk/BQiKj+9yzXUhHLu9VRihNQHhYmEOhyNgK8Zid8cVgHcTTfEExG+m4nSnEAJOiXBirfoMBp2exUYRhEkdcq0wh+II308zhfg3g28LNeEoP04Dg6K2Vxymgr+oPQ4FURZilEexvhQCO2yELMJHHml+A6ILAAA=";
    private static final Log log = LogFactory.getLog(SearchUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected JButton cartography;
    protected JButton clear;
    protected CriteriaUI criterias;
    protected JComboBox groups;
    protected Boolean hidable;
    protected Boolean offerListUI;
    protected String request;
    protected RSyntaxTextArea requestArea;
    protected DefaultComboBoxModel requestModel;
    protected JComboBox requests;
    protected OfferListTableModel resultTableModel;
    protected JButton search;
    private SearchUI $Table0 = this;
    private JLabel $JLabel0;
    private Table $Table1;
    private JScrollPane $JScrollPane0;
    private Table $Table2;
    private HidorButton $HidorButton0;

    public SearchHandler getHandler() {
        return this.getContextValue(SearchHandler.class);
    }

    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }

    void $afterCompleteSetup() {
        this.requestArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchUI.this.textAsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchUI.this.textAsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchUI.this.textAsChanged();
            }
        });
        this.requests.setRenderer(new ListCellRenderer(){
            public static final int TEXT_LENGTH_LIMIT = 130;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                JLabel label = new JLabel();
                if (value instanceof String) {
                    text = (String)value;
                } else {
                    QueryBean bean = (QueryBean)value;
                    if (bean == null) {
                        return new JLabel("");
                    }
                    StringBuffer buf = new StringBuffer();
                    buf.append("[");
                    buf.append(bean.getName());
                    buf.append("] ");
                    buf.append(bean.getQuery());
                    text = buf.toString();
                    label.setToolTipText(bean.getDescription());
                }
                text = StringUtils.abbreviate((String)text, (int)130);
                label.setText(text);
                return label;
            }
        });
        JPopupMenu popupMenu = this.requestArea.getPopupMenu();
        popupMenu.add(new JSeparator());
        popupMenu.add(new RequestFieldMenu(this));
    }

    protected void textAsChanged() {
        this.setRequest(this.requestArea.getText());
    }

    protected void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.executeQuery();
        }
    }

    public void executeQuery() {
        this.getHandler().executeQuery(this, 1);
    }

    protected void executeCartography() {
        this.getHandler().executeCartography(this);
    }

    protected void updateRequests() {
        this.getHandler().updateRequests(this);
    }

    protected String getRequestAsString(Object selected) {
        if (selected == null) {
            return null;
        }
        if (selected instanceof String) {
            return (String)selected;
        }
        QueryBean queryBean = (QueryBean)selected;
        return queryBean.getQuery();
    }

    public SearchUI() {
        this.$initialize();
    }

    public SearchUI(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.$bindings.get($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)((Object)this), clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__cartography(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.executeCartography();
    }

    public void doActionPerformed__on__clear(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.setRequest("");
    }

    public void doActionPerformed__on__groups(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.updateRequests();
    }

    public void doActionPerformed__on__requests(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.setRequest(this.getRequestAsString(this.requests.getSelectedItem()));
    }

    public void doActionPerformed__on__search(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.executeQuery();
    }

    public void doKeyReleased__on__requestArea(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.keyReleased(event);
    }

    public JButton getCartography() {
        return this.cartography;
    }

    public JButton getClear() {
        return this.clear;
    }

    public CriteriaUI getCriterias() {
        return this.criterias;
    }

    public JComboBox getGroups() {
        return this.groups;
    }

    public Boolean getHidable() {
        return this.hidable;
    }

    public Boolean getOfferListUI() {
        return this.offerListUI;
    }

    public String getRequest() {
        return this.request;
    }

    public RSyntaxTextArea getRequestArea() {
        return this.requestArea;
    }

    public DefaultComboBoxModel getRequestModel() {
        return this.requestModel;
    }

    public JComboBox getRequests() {
        return this.requests;
    }

    public OfferListTableModel getResultTableModel() {
        return this.resultTableModel;
    }

    public JButton getSearch() {
        return this.search;
    }

    public Boolean isHidable() {
        return this.hidable != null && this.hidable != false;
    }

    public Boolean isOfferListUI() {
        return this.offerListUI != null && this.offerListUI != false;
    }

    public void setHidable(Boolean hidable) {
        Boolean oldValue = this.hidable;
        this.hidable = hidable;
        this.firePropertyChange(PROPERTY_HIDABLE, oldValue, hidable);
    }

    public void setOfferListUI(Boolean offerListUI) {
        Boolean oldValue = this.offerListUI;
        this.offerListUI = offerListUI;
        this.firePropertyChange(PROPERTY_OFFER_LIST_UI, oldValue, offerListUI);
    }

    public void setRequest(String request) {
        String oldValue = this.request;
        this.request = request;
        this.firePropertyChange(PROPERTY_REQUEST, oldValue, request);
    }

    public void setRequestModel(DefaultComboBoxModel requestModel) {
        DefaultComboBoxModel oldValue = this.requestModel;
        this.requestModel = requestModel;
        this.firePropertyChange(PROPERTY_REQUEST_MODEL, oldValue, requestModel);
    }

    public void setResultTableModel(OfferListTableModel resultTableModel) {
        OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = resultTableModel;
        this.firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, resultTableModel);
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected JScrollPane get$JScrollPane0() {
        return this.$JScrollPane0;
    }

    protected Table get$Table2() {
        return this.$Table2;
    }

    protected HidorButton get$HidorButton0() {
        return this.$HidorButton0;
    }

    protected void createCartography() {
        this.cartography = new JButton();
        this.$objectMap.put("cartography", this.cartography);
        this.cartography.setName("cartography");
        this.cartography.setText(I18n._((String)"vradi.criteria.cartography", (Object[])new Object[0]));
        this.cartography.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)((Object)this), (String)"doActionPerformed__on__cartography"));
    }

    protected void createClear() {
        this.clear = new JButton();
        this.$objectMap.put("clear", this.clear);
        this.clear.setName("clear");
        this.clear.setText(I18n._((String)"vradi.criteria.clear", (Object[])new Object[0]));
        this.clear.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)((Object)this), (String)"doActionPerformed__on__clear"));
    }

    protected void createCriterias() {
        this.criterias = new CriteriaUI((JAXXContext)this);
        this.$objectMap.put("criterias", (Object)this.criterias);
        this.criterias.setName("criterias");
    }

    protected void createGroups() {
        this.groups = new JComboBox();
        this.$objectMap.put("groups", this.groups);
        this.groups.setName("groups");
        this.groups.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)((Object)this), (String)"doActionPerformed__on__groups"));
    }

    protected void createHidable() {
        this.hidable = true;
        this.$objectMap.put(PROPERTY_HIDABLE, this.hidable);
    }

    protected void createOfferListUI() {
        this.offerListUI = false;
        this.$objectMap.put(PROPERTY_OFFER_LIST_UI, this.offerListUI);
    }

    protected void createRequest() {
        this.request = "";
        this.$objectMap.put(PROPERTY_REQUEST, "");
    }

    protected void createRequestArea() {
        this.requestArea = new RSyntaxTextArea();
        this.$objectMap.put("requestArea", this.requestArea);
        this.requestArea.setName("requestArea");
        this.requestArea.setColumns(15);
        this.requestArea.setLineWrap(true);
        this.requestArea.setWrapStyleWord(true);
        this.requestArea.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)((Object)this), (String)"doKeyReleased__on__requestArea"));
    }

    protected void createRequestModel() {
        this.requestModel = this.getHandler().getRequestModel();
        this.$objectMap.put(PROPERTY_REQUEST_MODEL, this.requestModel);
    }

    protected void createRequests() {
        this.requests = new JComboBox();
        this.$objectMap.put("requests", this.requests);
        this.requests.setName("requests");
        this.requests.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)((Object)this), (String)"doActionPerformed__on__requests"));
    }

    protected void createResultTableModel() {
        this.resultTableModel = this.getContextValue(OfferListTableModel.class);
        this.$objectMap.put(PROPERTY_RESULT_TABLE_MODEL, this.resultTableModel);
    }

    protected void createSearch() {
        this.search = new JButton();
        this.$objectMap.put("search", this.search);
        this.search.setName("search");
        this.search.setText(I18n._((String)"vradi.criteria.search", (Object[])new Object[0]));
        this.search.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)((Object)this), (String)"doActionPerformed__on__search"));
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.add(this.$JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.groups, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.requests, new GridBagConstraints(2, 0, 1, 1, 0.7, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.$Table1, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.criterias), new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JScrollPane0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.9, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table1.add((Component)this.$Table2, (Object)new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.$JScrollPane0.getViewport().add((Component)this.requestArea);
        this.$Table2.add((Component)this.search, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table2.add((Component)this.cartography, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table2.add((Component)this.clear, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.$Table2.add((Component)this.$HidorButton0, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.groups.setModel(UIHelper.getGroupModel(true));
        this.groups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        this.requests.setModel(this.requestModel);
        this.requestArea.setSyntaxEditingStyle("text/sql");
        this.search.setIcon(SwingUtil.getUIManagerActionIcon((String)"search"));
        this.cartography.setIcon(SwingUtil.getUIManagerActionIcon((String)"search"));
        this.$HidorButton0.setHideTip(I18n._((String)"vradi.criteria.collapse", (Object[])new Object[0]));
        this.$HidorButton0.setShowTip(I18n._((String)"vradi.criteria.notCollapse", (Object[])new Object[0]));
        this.$HidorButton0.setTarget((JComponent)((Object)this.criterias));
        this.$HidorButton0.setTargetVisible(Boolean.valueOf(true));
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("$Table0", (Object)this.$Table0);
        this.createRequest();
        this.createOfferListUI();
        this.createHidable();
        this.createResultTableModel();
        this.createRequestModel();
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._((String)"vradi.list.requests", (Object[])new Object[0]));
        this.createGroups();
        this.createRequests();
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$JScrollPane0 = new JScrollPane();
        this.$objectMap.put("$JScrollPane0", this.$JScrollPane0);
        this.$JScrollPane0.setName("$JScrollPane0");
        this.createRequestArea();
        this.$Table2 = new Table();
        this.$objectMap.put("$Table2", this.$Table2);
        this.$Table2.setName("$Table2");
        this.createSearch();
        this.createCartography();
        this.createClear();
        this.$HidorButton0 = new HidorButton();
        this.$objectMap.put("$HidorButton0", this.$HidorButton0);
        this.$HidorButton0.setName("$HidorButton0");
        this.createCriterias();
        this.setName("$Table0");
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_VISIBLE, true, new String[]{PROPERTY_OFFER_LIST_UI}){

            public void processDataBinding() {
                SearchUI.this.$JLabel0.setVisible(SearchUI.this.isOfferListUI());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROUPS_VISIBLE, true, new String[]{PROPERTY_OFFER_LIST_UI}){

            public void processDataBinding() {
                SearchUI.this.groups.setVisible(SearchUI.this.isOfferListUI());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_REQUESTS_VISIBLE, true, new String[]{PROPERTY_OFFER_LIST_UI}){

            public void processDataBinding() {
                SearchUI.this.requests.setVisible(SearchUI.this.isOfferListUI());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_REQUEST_AREA_TEXT, true, new String[]{PROPERTY_REQUEST}){

            public void processDataBinding() {
                SwingUtil.setText((JTextComponent)SearchUI.this.requestArea, (String)SearchUI.this.getRequest());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$HIDOR_BUTTON0_VISIBLE, true, new String[]{PROPERTY_HIDABLE}){

            public void processDataBinding() {
                SearchUI.this.$HidorButton0.setVisible(SearchUI.this.isHidable().booleanValue());
            }
        });
    }
}

