/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.email.loadors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.helpers.EmailDataHelper;
import org.chorem.vradi.ui.email.loadors.AbstractEmailNodeLoador;
import org.chorem.vradi.ui.email.loadors.EmailGroupUsersNodeLoadors;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.chorem.vradi.ui.tree.VradiTreeNode;

public class EmailGroupNodeLoadors
extends AbstractEmailNodeLoador<Group> {
    private static final Log log = LogFactory.getLog(EmailGroupNodeLoadors.class);
    protected String sessionId;

    public EmailGroupNodeLoadors() {
        super(Group.class);
    }

    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        this.sessionId = parentId;
        List<Sending> sendings = this.getSendingList(dataProvider, parentId);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Sending sending : sendings) {
            groupIds.addAll(EmailDataHelper.findAllGroupsConcernedBySending(sending));
        }
        List groupSorted = VradiService.getWikittyProxy().restore(Group.class, groupIds);
        Collections.sort(groupSorted, VradiComparators.GROUP_COMPARATOR);
        return this.extractIds(groupSorted);
    }

    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        EmailGroupUsersNodeLoadors usersLoador = (EmailGroupUsersNodeLoadors)NavHelper.getChildLoador(EmailGroupUsersNodeLoadors.class);
        usersLoador.setSessionId(this.sessionId);
        return this.createVradiNode(id, usersLoador);
    }
}

