/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.search;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.ui.search.MultipleSelectionEditor;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.entities.BusinessEntity;

public class SearchMultipleSelectionHandler<B extends BusinessEntity> {
    public static final Log log = LogFactory.getLog(SearchMultipleSelectionHandler.class);
    public static final String VRADI_LIST_EMPTY = I18n.n_((String)"vradi.criteria.empty", (Object[])new Object[0]);
    public static final String WIKITTY_ID = "wikittyId";
    protected Map<String, B> valuesAsMap;
    protected MultipleSelectionEditor<B> editor;
    protected Decorator<B> decorator;

    public SearchMultipleSelectionHandler(MultipleSelectionEditor<B> editor) {
        this.editor = editor;
        this.valuesAsMap = new HashMap<String, B>();
        this.decorator = VradiContext.get().getDecoratorProvider().getDecorator(editor.getBeanClass());
    }

    public String getValueAsString(B value) {
        return I18n._((String)this.decorator.toString(value), (Object[])new Object[0]);
    }

    public String getValuesAsString(List<B> values) {
        String result;
        StringBuilder builder = new StringBuilder();
        if (values != null) {
            for (BusinessEntity value : values) {
                builder.append(this.getValueAsString(value));
                builder.append(", ");
            }
        }
        result = !StringUtils.isEmpty((String)(result = builder.toString())) ? result.substring(0, result.length() - 2) : I18n._((String)VRADI_LIST_EMPTY, (Object[])new Object[0]);
        result = StringUtils.abbreviate((String)result, (int)70);
        return this.getBold(result);
    }

    protected String getBold(String toBold) {
        StringBuilder result = new StringBuilder();
        result.append("<html><strong>").append(toBold).append("</strong></html>");
        return result.toString();
    }

    public Component getPopupUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        List<B> values = this.editor.getAllValues();
        List<B> selectedValues = this.editor.getSelectedValues();
        for (BusinessEntity value : values) {
            String valueAsString = this.getValueAsString(value);
            String id = value.getWikittyId();
            this.valuesAsMap.put(id, value);
            final JCheckBox checkBox = new JCheckBox(valueAsString);
            checkBox.putClientProperty(WIKITTY_ID, id);
            checkBox.setSelected(selectedValues.contains(value));
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String id = (String)checkBox.getClientProperty(SearchMultipleSelectionHandler.WIKITTY_ID);
                    BusinessEntity bean = (BusinessEntity)SearchMultipleSelectionHandler.this.valuesAsMap.get(id);
                    if (checkBox.isSelected()) {
                        SearchMultipleSelectionHandler.this.editor.addSelectedValue(bean);
                    } else {
                        SearchMultipleSelectionHandler.this.editor.removeSelectedValue(bean);
                    }
                }
            });
            panel.add(checkBox);
        }
        return new JScrollPane(panel);
    }
}

