/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: AssignXmlStreamTasks.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-services/src/main/java/org/chorem/vradi/services/tasks/AssignXmlStreamTasks.java $
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.services.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiServiceHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.managers.BindingManager;
import org.chorem.vradi.services.managers.FormManager;
import org.chorem.vradi.services.managers.ThesaurusManager;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author sletellier
 */
public class AssignXmlStreamTasks extends ImportXmlStreamTasks {

    private static final Log log = LogFactory.getLog(AssignXmlStreamTasks.class);

    private final static TimeLog timeLog = new TimeLog(AssignXmlStreamTasks.class, 5000, 1000);

    protected ThesaurusManager thesaurusManager;
    protected FormManager formManager;

    public AssignXmlStreamTasks(ApplicationConfig config,
                                WikittyProxy wikittyProxy,
                                BindingManager bindingManager,
                                ThesaurusManager thesaurusManager,
                                FormManager formManager,
                                String xmlStreamId) {

        super(config, wikittyProxy, bindingManager, xmlStreamId);

        this.thesaurusManager = thesaurusManager;
        this.formManager = formManager;
    }

    @Override
    public void run() {

        // Import stream before assign
        super.run();

        long start = TimeLog.getTime();

        // Get import (super) result
        Set<String> createdFormsIds = importResult.getCreatedFormsIds();

        // Auto selection propositions
        List<BusinessEntity> toStore = new ArrayList<BusinessEntity>();
        for (String formId : createdFormsIds) {
            try {

                // Get thesaurus proposition for form
                List<Thesaurus> thesaurusProposed = thesaurusManager.proposeThesaurus(formId);
                if (!thesaurusProposed.isEmpty()) {
                    Form form = wikittyProxy.restore(Form.class, formId);
                    form = formManager.updateForm(form, VradiServiceHelper.extractIds(thesaurusProposed));

                    // Set form as selected
                    form.setStatus(formManager.getSelectionneStatus().getWikittyId());
                    toStore.add(form);
                }
            } catch (VradiException eee) {
                log.error("Failled to propose thesaurus for form : " + formId, eee);
            }
        }

        // Store forms
        wikittyProxy.store(toStore);

        // Log execution duration
        timeLog.log(start, "AssignXmlStreamTasks");
    }
}
