/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FieldProperties {
    static final int INDEXED = 1;
    static final int TOKENIZED = 2;
    static final int STORED = 4;
    static final int BINARY = 8;
    static final int OMIT_NORMS = 16;
    static final int OMIT_TF_POSITIONS = 32;
    static final int STORE_TERMVECTORS = 64;
    static final int STORE_TERMPOSITIONS = 128;
    static final int STORE_TERMOFFSETS = 256;
    static final int MULTIVALUED = 512;
    static final int SORT_MISSING_FIRST = 1024;
    static final int SORT_MISSING_LAST = 2048;
    static final int REQUIRED = 4096;
    static final String[] propertyNames = new String[]{"indexed", "tokenized", "stored", "binary", "omitNorms", "omitTermFreqAndPositions", "termVectors", "termPositions", "termOffsets", "multiValued", "sortMissingFirst", "sortMissingLast", "required"};
    static final Map<String, Integer> propertyMap = new HashMap<String, Integer>();

    FieldProperties() {
    }

    static String getPropertyName(int property) {
        return propertyNames[Integer.numberOfTrailingZeros(property)];
    }

    static int propertyNameToInt(String name) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyNames[i].equals(name)) continue;
            return 1 << i;
        }
        return 0;
    }

    static String propertiesToString(int properties) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (properties != 0) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            int bitpos = Integer.numberOfTrailingZeros(properties);
            sb.append(FieldProperties.getPropertyName(1 << bitpos));
            properties &= ~(1 << bitpos);
        }
        return sb.toString();
    }

    static boolean on(int bitfield, int props) {
        return (bitfield & props) != 0;
    }

    static boolean off(int bitfield, int props) {
        return (bitfield & props) == 0;
    }

    static int parseProperties(Map<String, String> properties, boolean which) {
        int props = 0;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String val = entry.getValue();
            if (val == null || Boolean.parseBoolean(val) != which) continue;
            props |= FieldProperties.propertyNameToInt(entry.getKey());
        }
        return props;
    }

    static {
        for (String prop : propertyNames) {
            propertyMap.put(prop, FieldProperties.propertyNameToInt(prop));
        }
    }
}

