/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLWriter {
    public static float CURRENT_VERSION = 2.2f;
    private static final char[] XML_START1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".toCharArray();
    private static final char[] XML_STYLESHEET = "<?xml-stylesheet type=\"text/xsl\" href=\"".toCharArray();
    private static final char[] XML_STYLESHEET_END = "\"?>\n".toCharArray();
    private static final char[] XML_START2_SCHEMA = "<response xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:noNamespaceSchemaLocation=\"http://pi.cnet.com/cnet-search/response.xsd\">\n".toCharArray();
    private static final char[] XML_START2_NOSCHEMA = "<response>\n".toCharArray();
    private final Writer writer;
    private final IndexSchema schema;
    private final SolrQueryRequest request;
    private int level;
    private boolean defaultIndent = false;
    private boolean doIndent = false;
    private Set<String> defaultFieldList;
    private final int indentThreshold = 0;
    final int version;
    private final ArrayList tlst = new ArrayList();
    private final Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
    private final StringBuilder sb = new StringBuilder();
    static final char[] indentChars = new char[81];
    private static final Comparator fieldnameComparator;

    public static void writeResponse(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        Object header;
        String ver = req.getParams().get("version");
        writer.write(XML_START1);
        String stylesheet = req.getParams().get("stylesheet");
        if (stylesheet != null && stylesheet.length() > 0) {
            writer.write(XML_STYLESHEET);
            XML.escapeAttributeValue((String)stylesheet, (Writer)writer);
            writer.write(XML_STYLESHEET_END);
        }
        String noSchema = req.getParams().get("noSchema");
        writer.write(XML_START2_NOSCHEMA);
        XMLWriter xw = new XMLWriter(writer, req.getSchema(), req, ver);
        xw.defaultFieldList = rsp.getReturnFields();
        String indent = req.getParams().get("indent");
        if (indent != null) {
            if ("".equals(indent) || "off".equals(indent)) {
                xw.setIndent(false);
            } else {
                xw.setIndent(true);
            }
        }
        NamedList lst = rsp.getValues();
        Boolean omitHeader = req.getParams().getBool("omitHeader");
        if (omitHeader != null && omitHeader.booleanValue()) {
            lst.remove("responseHeader");
        }
        int sz = lst.size();
        int start = 0;
        if (xw.version <= 2100 && sz > 0 && (header = lst.getVal(0)) instanceof NamedList && "responseHeader".equals(lst.getName(0))) {
            writer.write("<responseHeader>");
            xw.incLevel();
            NamedList nl = (NamedList)header;
            for (int i = 0; i < nl.size(); ++i) {
                String name = nl.getName(i);
                Object val = nl.getVal(i);
                if ("status".equals(name) || "QTime".equals(name)) {
                    xw.writePrim(name, null, val.toString(), false);
                    continue;
                }
                xw.writeVal(name, val);
            }
            xw.decLevel();
            writer.write("</responseHeader>");
            start = 1;
        }
        for (int i = start; i < sz; ++i) {
            xw.writeVal(lst.getName(i), lst.getVal(i));
        }
        writer.write("\n</response>\n");
    }

    public XMLWriter(Writer writer, IndexSchema schema, SolrQueryRequest req, String version) {
        this.writer = writer;
        this.schema = schema;
        this.request = req;
        float ver = version == null ? CURRENT_VERSION : Float.parseFloat(version);
        this.version = (int)(ver * 1000.0f);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public int incLevel() {
        return ++this.level;
    }

    public int decLevel() {
        return --this.level;
    }

    public void setIndent(boolean doIndent) {
        this.doIndent = doIndent;
        this.defaultIndent = doIndent;
    }

    public void writeAttr(String name, String val) throws IOException {
        this.writeAttr(name, val, true);
    }

    public void writeAttr(String name, String val, boolean escape) throws IOException {
        if (val != null) {
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("=\"");
            if (escape) {
                XML.escapeAttributeValue((String)val, (Writer)this.writer);
            } else {
                this.writer.write(val);
            }
            this.writer.write(34);
        }
    }

    public void startTag(String tag, Map<String, String> attributes, boolean closeTag, boolean escape) throws IOException {
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write(60);
        this.writer.write(tag);
        if (!attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writeAttr(entry.getKey(), entry.getValue(), escape);
            }
        }
        if (closeTag) {
            this.writer.write("/>");
        } else {
            this.writer.write(62);
        }
    }

    public void writeCdataTag(String tag, Map<String, String> attributes, String cdata, boolean escapeCdata, boolean escapeAttr) throws IOException {
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write(60);
        this.writer.write(tag);
        if (!attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writeAttr(entry.getKey(), entry.getValue(), escapeAttr);
            }
        }
        this.writer.write(62);
        if (cdata != null && cdata.length() > 0) {
            if (escapeCdata) {
                XML.escapeCharData((String)cdata, (Writer)this.writer);
            } else {
                this.writer.write(cdata, 0, cdata.length());
            }
        }
        this.writer.write("</");
        this.writer.write(tag);
        this.writer.write(62);
    }

    public void startTag(String tag, String name, boolean closeTag) throws IOException {
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write(60);
        this.writer.write(tag);
        if (name != null) {
            this.writeAttr("name", name);
            if (closeTag) {
                this.writer.write("/>");
            } else {
                this.writer.write(">");
            }
        } else if (closeTag) {
            this.writer.write("/>");
        } else {
            this.writer.write(62);
        }
    }

    public void indent() throws IOException {
        this.indent(this.level);
    }

    public void indent(int lev) throws IOException {
        this.writer.write(indentChars, 0, Math.min((lev << 1) + 1, indentChars.length));
    }

    public final void writeDoc(String name, Document doc, Set<String> returnFields, float score, boolean includeScore) throws IOException {
        this.startTag("doc", name, false);
        this.incLevel();
        if (includeScore) {
            this.writeFloat("score", score);
        }
        this.tlst.clear();
        Iterator i$ = doc.getFields().iterator();
        while (i$.hasNext()) {
            Fieldable obj;
            Fieldable ff = obj = (Fieldable)i$.next();
            if (returnFields != null && !returnFields.contains(ff.name())) continue;
            this.tlst.add(ff);
        }
        Collections.sort(this.tlst, fieldnameComparator);
        int sz = this.tlst.size();
        int fidx1 = 0;
        int fidx2 = 0;
        while (fidx1 < sz) {
            Fieldable f1 = (Fieldable)this.tlst.get(fidx1);
            String fname = f1.name();
            for (fidx2 = fidx1 + 1; fidx2 < sz && fname.equals(((Fieldable)this.tlst.get(fidx2)).name()); ++fidx2) {
            }
            SchemaField sf = this.schema.getFieldOrNull(fname);
            if (sf == null) {
                sf = new SchemaField(fname, new TextField());
            }
            if (fidx1 + 1 == fidx2) {
                if (this.version >= 2100 && sf.multiValued()) {
                    this.startTag("arr", fname, false);
                    this.doIndent = false;
                    sf.write(this, null, f1);
                    this.writer.write("</arr>");
                    this.doIndent = this.defaultIndent;
                } else {
                    sf.write(this, f1.name(), f1);
                }
            } else {
                this.startTag("arr", fname, false);
                this.incLevel();
                this.doIndent = false;
                int cnt = 0;
                for (int i = fidx1; i < fidx2; ++i) {
                    if (this.defaultIndent && ++cnt == 4) {
                        this.indent();
                        cnt = 0;
                    }
                    sf.write(this, null, (Fieldable)this.tlst.get(i));
                }
                this.decLevel();
                this.writer.write("</arr>");
                this.doIndent = this.defaultIndent;
            }
            fidx1 = fidx2;
        }
        this.decLevel();
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write("</doc>");
    }

    final void writeDoc(String name, SolrDocument doc, Set<String> returnFields, boolean includeScore) throws IOException {
        this.startTag("doc", name, false);
        this.incLevel();
        if (includeScore && returnFields != null) {
            returnFields.add("score");
        }
        for (String fname : doc.getFieldNames()) {
            if (returnFields != null && !returnFields.contains(fname)) continue;
            Object val = doc.getFieldValue(fname);
            if (val instanceof Collection) {
                this.writeVal(fname, val);
                continue;
            }
            SchemaField sf = this.schema.getFieldOrNull(fname);
            if (this.version >= 2100 && sf != null && sf.multiValued()) {
                this.startTag("arr", fname, false);
                this.doIndent = false;
                this.writeVal(fname, val);
                this.writer.write("</arr>");
                this.doIndent = this.defaultIndent;
                continue;
            }
            this.writeVal(fname, val);
        }
        this.decLevel();
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write("</doc>");
    }

    private final void writeDocuments(String name, DocumentListInfo docs, Set<String> fields) throws IOException {
        boolean includeScore = false;
        if (fields != null) {
            includeScore = fields.contains("score");
            if (fields.size() == 0 || fields.size() == 1 && includeScore || fields.contains("*")) {
                fields = null;
            }
        }
        int sz = docs.getCount();
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write("<result");
        this.writeAttr("name", name);
        this.writeAttr("numFound", Long.toString(docs.getNumFound()));
        this.writeAttr("start", Long.toString(docs.getStart()));
        if (includeScore && docs.getMaxScore() != null) {
            this.writeAttr("maxScore", Float.toString(docs.getMaxScore().floatValue()));
        }
        if (sz == 0) {
            this.writer.write("/>");
            return;
        }
        this.writer.write(62);
        this.incLevel();
        docs.writeDocs(includeScore, fields);
        this.decLevel();
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write("</result>");
    }

    public final void writeSolrDocumentList(String name, final SolrDocumentList docs, Set<String> fields) throws IOException {
        this.writeDocuments(name, new DocumentListInfo(){

            @Override
            public int getCount() {
                return docs.size();
            }

            @Override
            public Float getMaxScore() {
                return docs.getMaxScore();
            }

            @Override
            public long getNumFound() {
                return docs.getNumFound();
            }

            @Override
            public long getStart() {
                return docs.getStart();
            }

            @Override
            public void writeDocs(boolean includeScore, Set<String> fields) throws IOException {
                for (SolrDocument doc : docs) {
                    XMLWriter.this.writeDoc(null, doc, fields, includeScore);
                }
            }
        }, fields);
    }

    public final void writeDocList(String name, final DocList ids, Set<String> fields) throws IOException {
        this.writeDocuments(name, new DocumentListInfo(){

            @Override
            public int getCount() {
                return ids.size();
            }

            @Override
            public Float getMaxScore() {
                return Float.valueOf(ids.maxScore());
            }

            @Override
            public long getNumFound() {
                return ids.matches();
            }

            @Override
            public long getStart() {
                return ids.offset();
            }

            @Override
            public void writeDocs(boolean includeScore, Set<String> fields) throws IOException {
                SolrIndexSearcher searcher = XMLWriter.this.request.getSearcher();
                DocIterator iterator = ids.iterator();
                int sz = ids.size();
                includeScore = includeScore && ids.hasScores();
                for (int i = 0; i < sz; ++i) {
                    int id = iterator.nextDoc();
                    Document doc = searcher.doc(id, fields);
                    XMLWriter.this.writeDoc(null, doc, fields, includeScore ? iterator.score() : 0.0f, includeScore);
                }
            }
        }, fields);
    }

    public void writeVal(String name, Object val) throws IOException {
        if (val == null) {
            this.writeNull(name);
        } else if (val instanceof String) {
            this.writeStr(name, (String)val);
        } else if (val instanceof Integer) {
            this.writeInt(name, val.toString());
        } else if (val instanceof Boolean) {
            this.writeBool(name, val.toString());
        } else if (val instanceof Long) {
            this.writeLong(name, val.toString());
        } else if (val instanceof Date) {
            this.writeDate(name, (Date)val);
        } else if (val instanceof Float) {
            this.writeFloat(name, ((Float)val).floatValue());
        } else if (val instanceof Double) {
            this.writeDouble(name, (Double)val);
        } else if (val instanceof Document) {
            this.writeDoc(name, (Document)val, this.defaultFieldList, 0.0f, false);
        } else if (val instanceof DocList) {
            this.writeDocList(name, (DocList)val, this.defaultFieldList);
        } else if (val instanceof SolrDocumentList) {
            this.writeSolrDocumentList(name, (SolrDocumentList)val, this.defaultFieldList);
        } else if (!(val instanceof DocSet)) {
            if (val instanceof Map) {
                this.writeMap(name, (Map)val);
            } else if (val instanceof NamedList) {
                this.writeNamedList(name, (NamedList)val);
            } else if (val instanceof Iterable) {
                this.writeArray(name, ((Iterable)val).iterator());
            } else if (val instanceof Object[]) {
                this.writeArray(name, (Object[])val);
            } else if (val instanceof Iterator) {
                this.writeArray(name, (Iterator)val);
            } else {
                this.writeStr(name, val.getClass().getName() + ':' + val.toString());
            }
        }
    }

    public void writeNamedList(String name, NamedList val) throws IOException {
        int sz = val.size();
        this.startTag("lst", name, sz <= 0);
        if (sz < 0) {
            this.doIndent = false;
        }
        this.incLevel();
        for (int i = 0; i < sz; ++i) {
            this.writeVal(val.getName(i), val.getVal(i));
        }
        this.decLevel();
        if (sz > 0) {
            if (this.doIndent) {
                this.indent();
            }
            this.writer.write("</lst>");
        }
    }

    public void writeMap(String name, Map<Object, Object> map) throws IOException {
        int sz = map.size();
        this.startTag("lst", name, sz <= 0);
        this.incLevel();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.writeVal(null == k ? null : k.toString(), v);
        }
        this.decLevel();
        if (sz > 0) {
            if (this.doIndent) {
                this.indent();
            }
            this.writer.write("</lst>");
        }
    }

    public void writeArray(String name, Object[] val) throws IOException {
        this.writeArray(name, Arrays.asList(val).iterator());
    }

    public void writeArray(String name, Iterator iter) throws IOException {
        if (iter.hasNext()) {
            this.startTag("arr", name, false);
            this.incLevel();
            while (iter.hasNext()) {
                this.writeVal(null, iter.next());
            }
            this.decLevel();
            if (this.doIndent) {
                this.indent();
            }
            this.writer.write("</arr>");
        } else {
            this.startTag("arr", name, true);
        }
    }

    public void writeNull(String name) throws IOException {
        this.writePrim("null", name, "", false);
    }

    public void writeStr(String name, String val) throws IOException {
        this.writePrim("str", name, val, true);
    }

    public void writeInt(String name, String val) throws IOException {
        this.writePrim("int", name, val, false);
    }

    public void writeInt(String name, int val) throws IOException {
        this.writeInt(name, Integer.toString(val));
    }

    public void writeLong(String name, String val) throws IOException {
        this.writePrim("long", name, val, false);
    }

    public void writeLong(String name, long val) throws IOException {
        this.writeLong(name, Long.toString(val));
    }

    public void writeBool(String name, String val) throws IOException {
        this.writePrim("bool", name, val, false);
    }

    public void writeBool(String name, boolean val) throws IOException {
        this.writeBool(name, Boolean.toString(val));
    }

    public void writeShort(String name, String val) throws IOException {
        this.writePrim("short", name, val, false);
    }

    public void writeShort(String name, short val) throws IOException {
        this.writeInt(name, Short.toString(val));
    }

    public void writeByte(String name, String val) throws IOException {
        this.writePrim("byte", name, val, false);
    }

    public void writeByte(String name, byte val) throws IOException {
        this.writeInt(name, Byte.toString(val));
    }

    public void writeFloat(String name, String val) throws IOException {
        this.writePrim("float", name, val, false);
    }

    public void writeFloat(String name, float val) throws IOException {
        this.writeFloat(name, Float.toString(val));
    }

    public void writeDouble(String name, String val) throws IOException {
        this.writePrim("double", name, val, false);
    }

    public void writeDouble(String name, double val) throws IOException {
        this.writeDouble(name, Double.toString(val));
    }

    public void writeDate(String name, Date val) throws IOException {
        this.cal.setTime(val);
        this.sb.setLength(0);
        int i = this.cal.get(1);
        this.sb.append(i);
        this.sb.append('-');
        i = this.cal.get(2) + 1;
        if (i < 10) {
            this.sb.append('0');
        }
        this.sb.append(i);
        this.sb.append('-');
        i = this.cal.get(5);
        if (i < 10) {
            this.sb.append('0');
        }
        this.sb.append(i);
        this.sb.append('T');
        i = this.cal.get(11);
        if (i < 10) {
            this.sb.append('0');
        }
        this.sb.append(i);
        this.sb.append(':');
        i = this.cal.get(12);
        if (i < 10) {
            this.sb.append('0');
        }
        this.sb.append(i);
        this.sb.append(':');
        i = this.cal.get(13);
        if (i < 10) {
            this.sb.append('0');
        }
        this.sb.append(i);
        i = this.cal.get(14);
        if (i != 0) {
            this.sb.append('.');
            if (i < 100) {
                this.sb.append('0');
            }
            if (i < 10) {
                this.sb.append('0');
            }
            this.sb.append(i);
            int lastIdx = this.sb.length() - 1;
            if (this.sb.charAt(lastIdx) == '0') {
                if (this.sb.charAt(--lastIdx) == '0') {
                    --lastIdx;
                }
                this.sb.setLength(lastIdx + 1);
            }
        }
        this.sb.append('Z');
        this.writeDate(name, this.sb.toString());
    }

    public void writeDate(String name, String val) throws IOException {
        this.writePrim("date", name, val, false);
    }

    public void writePrim(String tag, String name, String val, boolean escape) throws IOException {
        int contentLen = val.length();
        this.startTag(tag, name, contentLen == 0);
        if (contentLen == 0) {
            return;
        }
        if (escape) {
            XML.escapeCharData((String)val, (Writer)this.writer);
        } else {
            this.writer.write(val, 0, contentLen);
        }
        this.writer.write("</");
        this.writer.write(tag);
        this.writer.write(62);
    }

    static {
        Arrays.fill(indentChars, ' ');
        XMLWriter.indentChars[0] = 10;
        fieldnameComparator = new Comparator(){

            public int compare(Object o, Object o1) {
                Fieldable f1 = (Fieldable)o;
                Fieldable f2 = (Fieldable)o1;
                int cmp = f1.name().compareTo(f2.name());
                return cmp;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DocumentListInfo {
        public Float getMaxScore();

        public int getCount();

        public long getNumFound();

        public long getStart();

        public void writeDocs(boolean var1, Set<String> var2) throws IOException;
    }
}

