/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.tasks;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.VradiServiceConfigurationHelper;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.managers.BindingManager;
import org.chorem.vradi.services.managers.FormManager;
import org.chorem.vradi.services.managers.MailingManager;
import org.chorem.vradi.services.managers.ThesaurusManager;
import org.chorem.vradi.services.tasks.AssignXmlStreamTasks;
import org.chorem.vradi.services.tasks.AutoSendTasks;
import org.chorem.vradi.services.tasks.ImportXmlStreamTasks;
import org.chorem.vradi.services.tasks.ReceiveMailTasks;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;

public class TasksManager
implements WikittyListener {
    private static final Log log = LogFactory.getLog(TasksManager.class);
    protected ApplicationConfig config;
    protected Timer mailCronTimer;
    protected ScheduledExecutorService xmlStreamScheduler;
    protected ScheduledExecutorService autoSendScheduler;
    protected ScheduledFuture<?> autoSendTask;
    protected ReceiveMailTasks receiveMailTasks;
    protected Map<String, ScheduledFuture<?>> xmlStreamImportTasks;
    protected WikittyProxy wikittyProxy;
    protected MailingManager mailingManager;
    protected BindingManager bindingManager;
    protected ThesaurusManager thesaurusManager;
    protected FormManager formManager;

    public TasksManager(ApplicationConfig config, WikittyProxy wikittyProxy, ThesaurusManager thesaurusManager, FormManager formManager, MailingManager mailingManager, BindingManager bindingManager) {
        this.config = config;
        this.wikittyProxy = wikittyProxy;
        this.mailingManager = mailingManager;
        this.bindingManager = bindingManager;
        this.thesaurusManager = thesaurusManager;
        this.formManager = formManager;
        this.xmlStreamImportTasks = new HashMap();
    }

    public void initTasks() {
        this.initMailTask();
        this.initXmlStreamTasks();
        String sendTaskHour = VradiServiceConfigurationHelper.getSendTaskHour(this.config);
        if (!StringUtils.isEmpty((String)sendTaskHour)) {
            this.initAutoSendTask(sendTaskHour);
        }
    }

    protected void initAutoSendTask(String sendTaskHour) {
        this.autoSendScheduler = Executors.newScheduledThreadPool(1);
        AutoSendTasks task = new AutoSendTasks(this.formManager, this.mailingManager);
        this.autoSendTask = this.initDaylyTask(this.autoSendScheduler, task, sendTaskHour);
    }

    protected void initMailTask() {
        this.mailCronTimer = new Timer("vradi-mail-task");
        this.receiveMailTasks = new ReceiveMailTasks(this.mailingManager);
        this.mailCronTimer.schedule((TimerTask)this.receiveMailTasks, 0L, 600000L);
    }

    protected void initXmlStreamTasks() {
        this.xmlStreamScheduler = Executors.newScheduledThreadPool(1);
        List<XmlStream> xmlStreams = this.bindingManager.getAllXmlStreams();
        for (XmlStream xmlStream : xmlStreams) {
            if (xmlStream == null) continue;
            this.initXmlStreamTask(xmlStream);
        }
    }

    protected void initXmlStreamTask(XmlStream xmlStream) {
        String streamImportTime = xmlStream.getImportTime();
        if (StringUtils.isBlank((String)streamImportTime)) {
            streamImportTime = "0:0";
        }
        ImportXmlStreamTasks autoImportTask = xmlStream.getAutoAssign() ? new AssignXmlStreamTasks(this.config, this.wikittyProxy, this.bindingManager, this.thesaurusManager, this.formManager, xmlStream.getWikittyId()) : new ImportXmlStreamTasks(this.config, this.wikittyProxy, this.bindingManager, xmlStream.getWikittyId());
        ScheduledFuture<?> sheduledImportTask = this.initDaylyTask(this.xmlStreamScheduler, autoImportTask, streamImportTime);
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting import of xml stream " + xmlStream.getName() + " at " + streamImportTime));
        }
        this.xmlStreamImportTasks.put(xmlStream.getWikittyId(), sheduledImportTask);
    }

    public ScheduledFuture<?> initDaylyTask(ScheduledExecutorService scheduledExecutorService, TimerTask task, String hour) {
        Matcher matchImportTime = VradiConstants.XML_STREAM_IMPORT_TIME.matcher(hour);
        if (matchImportTime.find()) {
            int toMinutes;
            String hours = matchImportTime.group(1);
            String minutes = matchImportTime.group(2);
            Calendar nowCalendar = Calendar.getInstance();
            int nowHours = nowCalendar.get(11);
            int nowMinutes = nowCalendar.get(12);
            int toHours = Integer.parseInt(hours);
            int delayInMinute = toHours * 60 + (toMinutes = Integer.parseInt(minutes)) - (nowHours * 60 + nowMinutes);
            if (delayInMinute < 0) {
                delayInMinute += 1440;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(task.getClass().getName() + " - in scheduler, delai : " + delayInMinute + "min, period " + 1440 + "min"));
            }
            return scheduledExecutorService.scheduleAtFixedRate(task, delayInMinute, 1440L, TimeUnit.MINUTES);
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("Can't parse " + hour));
        }
        return null;
    }

    protected void cancelXmlImportTask(String xmlStreamId, boolean restart) {
        ScheduledFuture<?> sheduledImportTask;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Canceling import stream task for " + xmlStreamId));
        }
        if ((sheduledImportTask = this.xmlStreamImportTasks.get(xmlStreamId)) != null) {
            this.xmlStreamImportTasks.remove(xmlStreamId);
            sheduledImportTask.cancel(false);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Nothing to cancel for wikitty id " + xmlStreamId));
        }
        if (restart) {
            XmlStream xmlStream = (XmlStream)this.wikittyProxy.restore(XmlStream.class, xmlStreamId);
            if (xmlStream == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can't restart import task for non existing xml stream " + xmlStreamId));
                }
            } else {
                this.initXmlStreamTask(xmlStream);
            }
        }
    }

    public void putWikitty(WikittyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receiving wikitty event : " + event));
        }
        Map wikittiesMap = event.getWikitties();
        Collection wikitties = wikittiesMap.values();
        for (Wikitty wikitty : wikitties) {
            if (!(wikitty instanceof XmlStream)) continue;
            this.cancelXmlImportTask(((XmlStream)wikitty).getWikittyId(), true);
        }
    }

    public void removeWikitty(WikittyEvent event) {
        Map wikittyMap;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receiving wikitty event : " + event));
        }
        if ((wikittyMap = event.getWikitties()) != null) {
            Set wikittyIds = wikittyMap.keySet();
            for (String wikittyId : wikittyIds) {
                if (!this.xmlStreamImportTasks.containsKey(wikittyId)) continue;
                this.cancelXmlImportTask(wikittyId, false);
            }
        }
    }

    public void clearWikitty(WikittyEvent event) {
    }

    public void putExtension(WikittyEvent event) {
    }

    public void removeExtension(WikittyEvent event) {
    }

    public void clearExtension(WikittyEvent event) {
    }
}

