package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class FormLinkAbstract extends BusinessEntityImpl implements FormLink {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionFormLink;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = FormLinkHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        FormLinkHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(FormLink.FIELD_FORMLINK_NAME, oldValue, getName());
}

    /**
     * getType :
     * @return int 
     */

    @Override
    public int getType() {
        int value = FormLinkHelper.getType(getWikitty());
        return value;
}

    /**
     * setType :
     * @param type 
     */

    @Override
    public void setType(int type) {
        int oldValue = getType();
        FormLinkHelper.setType(getWikitty(), type);
        getPropertyChangeSupport().firePropertyChange(FormLink.FIELD_FORMLINK_TYPE, oldValue, getType());
}

    /**
     * getFromForm :
     * @return String 
     */

    @Override
    public String getFromForm() {
        String value = FormLinkHelper.getFromForm(getWikitty());
        return value;
}

    /**
     * setFromForm :
     * @param fromForm 
     */

    @Override
    public void setFromForm(String fromForm) {
        String oldValue = getFromForm();
        FormLinkHelper.setFromForm(getWikitty(), fromForm);
        getPropertyChangeSupport().firePropertyChange(FormLink.FIELD_FORMLINK_FROMFORM, oldValue, getFromForm());
}

    /**
     * getToForm :
     * @return String 
     */

    @Override
    public String getToForm() {
        String value = FormLinkHelper.getToForm(getWikitty());
        return value;
}

    /**
     * setToForm :
     * @param toForm 
     */

    @Override
    public void setToForm(String toForm) {
        String oldValue = getToForm();
        FormLinkHelper.setToForm(getWikitty(), toForm);
        getPropertyChangeSupport().firePropertyChange(FormLink.FIELD_FORMLINK_TOFORM, oldValue, getToForm());
}

    /**
     * FormLinkAbstract :
     */

    public FormLinkAbstract() {
        super();
}

    /**
     * FormLinkAbstract :
     * @param wikitty 
     */

    public FormLinkAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * FormLinkAbstract :
     * @param businessEntityImpl 
     */

    public FormLinkAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionFormLink =
                new WikittyExtension(EXT_FORMLINK,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=\"true\"", 
                                             "Numeric type unique=\"true\"", 
                                             "Wikitty fromForm unique=\"true\"", 
                                             "Wikitty toForm unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionFormLink);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //FormLinkAbstract
