/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: PollCreatorAccessRequired.java 3595 2012-08-12 11:45:39Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/security/PollCreatorAccessRequired.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.security;

import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.ui.PollenUIUtils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import static org.nuiton.i18n.I18n.n_;

/**
 * Check that a user can show results of a poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class PollCreatorAccessRequired extends AbstractPollenAuthorization {

    @Override
    protected boolean isAccessAllowed(ServletRequest request,
                                      ServletResponse response,
                                      Object mappedValue) {

        PollenUserSecurityContext securityContext =
                createSecurityContext(request);

        boolean isAccessAllowed = securityContext.isPollExists();

        if (isAccessAllowed) {

            // pollId is sane

            if (securityContext.isWithAccountId()) {

                // check accountId is sane

                if (securityContext.hasNoRole()) {

                    // bad accountId
                    isAccessAllowed = false;
                    registerError(
                            request, n_("pollen.security.error.bad.accountId"));
                }
            }
        }

        if (isAccessAllowed) {

            // pollId is sane
            // accountId is sane

            // check now that account role is a creator

            if (!securityContext.isCreator()) {

                // not a creator, access not granted
                isAccessAllowed = false;
                registerError(
                        request,
                        n_("pollen.security.error.creatorId.or.admin.required"));
            }
        }

        if (isAccessAllowed) {

            // store security context in request
            PollenUIUtils.setUserSecuritycontext(request, securityContext);
        }

        return isAccessAllowed;
    }

}