/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.services.impl.VoteService;
import org.chorem.pollen.ui.actions.poll.AbstractVoteAction;

public class VoteForPoll
extends AbstractVoteAction
implements Preparable {
    private static final Log log = LogFactory.getLog(VoteForPoll.class);
    private static final long serialVersionUID = 1L;

    public boolean isModerate() {
        return false;
    }

    public void prepare() throws Exception {
        this.prepareVotePage();
        if (this.getPoll().isClosed()) {
            this.addFlashMessage(this._("pollen.information.pollClosed", new Object[0]));
        } else if (!this.isPollStarted()) {
            this.addFlashMessage(this._("pollen.information.pollNotStarted", new Object[0]));
        } else if (this.isPollFinished()) {
            this.addFlashMessage(this._("pollen.information.pollFinished", new Object[0]));
        }
        if (this.isPollChoiceRunning()) {
            this.addFlashMessage(this._("pollen.information.pollChoiceRunning", new Object[0]));
        }
    }

    public void validate() {
        Vote vote = this.getVote();
        Preconditions.checkNotNull((Object)vote);
        PollAccount pollAccount = this.getVote().getPollAccount();
        Preconditions.checkNotNull((Object)pollAccount);
        Poll poll = this.getPoll();
        if (!vote.isAnonymous()) {
            String name = pollAccount.getVotingId();
            if (StringUtils.isBlank((CharSequence)name)) {
                this.addFieldError("pollAccount.votingId", this._("pollen.error.pollAccount.votingId.required", new Object[0]));
            }
            if (pollAccount.getTopiaId() == null && this.getVoteService().hasAlreadyVoted(poll, name)) {
                this.addFieldError("pollAccount.votingId", this._("pollen.error.user.alreadyVoted", new Object[]{name}));
            }
        }
        int nbVotes = 0;
        int totalValues = 0;
        for (VoteToChoice voteToChoice : vote.getChoiceVoteToChoice()) {
            Integer value = voteToChoice.getVoteValue();
            if (value == null) continue;
            if (this.isCondorcetVoteCounting()) {
                if (value > 0) {
                    ++nbVotes;
                    totalValues += value.intValue();
                    continue;
                }
                this.addFieldError("vote.choices", this._("pollen.error.vote.invalidCondorcetVoteValue", new Object[0]));
                continue;
            }
            if (value == 0) continue;
            ++nbVotes;
            totalValues += value.intValue();
        }
        int maxChoice = this.getPoll().getMaxChoiceNb();
        if (maxChoice != 0 && nbVotes > maxChoice) {
            this.addFieldError("vote.choices", this._("pollen.error.vote.maxChoiceNb", new Object[]{maxChoice}));
        }
        if (this.isPercentageVoteCounting() && totalValues != 100) {
            this.addFieldError("vote.choices", this._("pollen.error.vote.percentage", new Object[0]));
        }
    }

    public String execute() throws Exception {
        Poll poll = this.getPoll();
        Vote vote = this.getVote();
        VoteService voteService = this.getVoteService();
        Vote newVote = StringUtils.isBlank((CharSequence)vote.getTopiaId()) ? voteService.createVote(poll, vote) : voteService.updateVote(poll, vote);
        this.clearFlashMessages();
        if (PollType.FREE == poll.getPollType() && !this.isUserLoggued() && StringUtils.isBlank((CharSequence)this.getAccountId())) {
            String pollId = poll.getPollId();
            String accountId = newVote.getPollAccount().getAccountId();
            PollUrl updateUrl = this.getPollUrlService().getPollVoteUrl(poll, newVote.getPollAccount());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UpdateURL for poll '%s' and account '%s' = %s", pollId, accountId, updateUrl));
            }
            this.addFlashMessage(this._("pollen.information.vote.createdWithUpdateUrl", new Object[]{updateUrl}));
        } else {
            this.addFlashMessage(this._("pollen.information.vote.created", new Object[0]));
        }
        return "success";
    }
}

