/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.UserAccount;

public class PollenSession {
    private static final Log log = LogFactory.getLog(PollenSession.class);
    protected static final String SESSION_PARAMETER = "pollenSession";
    public static final String SESSION_TOKEN_MESSAGES = "messages";
    public static final String SESSION_TOKEN_ERRORS = "errors";
    private UserAccount userAccount;
    private Map<String, Object> dynamicData;

    public static PollenSession get(ServletRequest servletRequest) {
        HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession(true);
        PollenSession pollenSession = (PollenSession)httpSession.getAttribute(SESSION_PARAMETER);
        if (pollenSession == null) {
            pollenSession = new PollenSession();
            httpSession.setAttribute(SESSION_PARAMETER, (Object)pollenSession);
        }
        return pollenSession;
    }

    public static PollenSession get(ActionContext actionContext) {
        Map strutsSession = actionContext.getSession();
        PollenSession session = (PollenSession)strutsSession.get(SESSION_PARAMETER);
        if (session == null) {
            session = new PollenSession();
            strutsSession.put(SESSION_PARAMETER, session);
        }
        return session;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
    }

    public <T> T getDynamicData(String token) {
        Object result = this.getDynamicData().get(token);
        return (T)result;
    }

    public void putDynamicData(String token, Object data) {
        this.getDynamicData().put(token, data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dynamic attributes size : " + this.getDynamicData().size()));
        }
    }

    public void removeDynamicData(String token) {
        this.getDynamicData().remove(token);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dynamic attributes size : " + this.getDynamicData().size()));
        }
    }

    public void clearDynamicData() {
        if (this.dynamicData != null) {
            this.dynamicData.clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dynamic attributes size : " + this.dynamicData.size()));
            }
        }
    }

    protected Map<String, Object> getDynamicData() {
        if (this.dynamicData == null) {
            this.dynamicData = Maps.newHashMap();
        }
        return this.dynamicData;
    }
}

