/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: AddComment.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/AddComment.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.Comment;

/**
 * To add a poll comment.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class AddComment extends AbstractVoteAction implements Preparable {

    private static final long serialVersionUID = 1L;

    private String commentText;

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String getCommentText() {
        return commentText;
    }

    @Override
    public void prepare() throws Exception {

        loadPoll();
        loadPollAccount();
    }

    @Override
    public void validate() {

        if (StringUtils.isBlank(getCommentAuthor())) {
            addFieldError("commentAuthor", _("pollen.error.comment.name.empty"));
        }

        if (StringUtils.isBlank(getCommentText())) {
            addFieldError("commentText", _("pollen.error.comment.text.empty"));
        }
    }

    @InputConfig(methodName = "prepareVotePage")
    @Override
    public String execute() throws Exception {

        // prepare a new comment
        Comment comment = getPollCommentService().getNewComment(
                getPollAccount(), getCommentAuthor(), getCommentText());

        // create the comment
        getPollCommentService().createComment(getPoll(), comment);

        return SUCCESS;
    }
}
