/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: GetCreatedPolls.java 3394 2012-05-28 15:27:04Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetCreatedPolls.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.nuiton.util.beans.Binder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Obtain created polls to put in grid for the connected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetCreatedPolls extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] polls;

    public Map<String, Object>[] getPolls() {
        return polls;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        PollService pollService = newService(PollService.class);

        List<Poll> pollList = pollService.getCreatedPolls(pager,
                                                          getPollenUserAccount());

        polls = new Map[pollList.size()];
        Binder<Poll, Poll> binder =
                PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Poll poll : pollList) {

            Map<String, Object> map = pollService.pollToMap(poll, binder);

            map.put("voteId", poll.getPollId());
            map.put("moderateId", poll.getAdminId());
            map.put("resultId", getResultId(poll));
            map.put("adminId", poll.getAdminId());
            Set<String> functions = getPollFunctions(poll);
            map.put("functions", functions);
            polls[index++] = map;
        }
        return SUCCESS;
    }

    protected Set<String> getPollFunctions(Poll poll) {
        Set<String> result = Sets.newHashSet();
        if (PollType.FREE == poll.getPollType()) {

            // only free poll could have vote action because creator can't vote
            result.add("vote");
        }
        result.add("moderate");
        result.add("result");
        if (!poll.isClosed()) {

            // poll is not closed
            result.add("edit");
            result.add("close");
        }
        result.add("export");
        result.add("clone");
        result.add("delete");
        return result;
    }

    /**
     * Retrieve the id for result page depends on {@code poll}.
     * It's not necessary to use {@code adminId} if the poll results are public.
     * But the {@code adminId} is mandatory if the poll is restricted (security).
     *
     * @param poll Poll
     * @return the pollId if results are public or the adminId if not
     */
    protected String getResultId(Poll poll) {
        String result;
        if (PollType.FREE == poll.getPollType() && poll.isPublicResults()) {
            result = poll.getPollId();

        } else {
            result = poll.getAdminId();
        }
        return result;
    }
}