/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: ResultLink.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/ResultLink.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.actions.PageSkin;

/**
 * Display the result link page.
 *
 * @author fdesbois <desbois@codelutin.com>
 * @since 1.3
 */
public class ResultLink extends AbstractPollUriIdAction {

    private static final long serialVersionUID = 1L;

    protected PollService pollService;

    protected Poll poll;

    protected String pollResultUrl;

    protected PollService getPollService() {
        if (pollService == null) {
            pollService = newService(PollService.class);
        }
        return pollService;
    }

    @Override
    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public Poll getPoll() {
        return poll;
    }

    public String getPollResultUrl() {
        return pollResultUrl;
    }

    @Override
    public String execute() throws Exception {

        String pollUid = getPollId();

        poll = getPollService().getPollByPollId(pollUid);

        pollResultUrl = getPollService().getPollResultUrl(poll).getUrl();

        return SUCCESS;
    }
}
