/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.util.List;
import java.util.Locale;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Report;
import org.chorem.pollen.persistence.entity.ReportResume;
import org.chorem.pollen.services.bean.ReportBean;
import org.chorem.pollen.services.bean.ReportLevel;
import org.chorem.pollen.services.bean.ReportResumeBean;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.InvalidEntityLinkException;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.nuiton.i18n.I18n;

public class ReportService
extends PollenServiceSupport {
    public ReportBean toReportBean(Report entity) {
        ReportBean bean = new ReportBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setLevel(ReportLevel.of(entity.getLevel()));
        bean.setEmail(entity.getEmail());
        bean.setIgnore(entity.isIgnore());
        return bean;
    }

    public void addPollReport(String pollId, ReportBean reportBean) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        Report report = this.getReportService().addReport(reportBean, (PollenEntity)poll);
        this.getNotificationService().onAddPollReport(poll, report);
    }

    public List<ReportBean> getPollReports(String pollId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        return this.getReports(pollId);
    }

    public void savePollReport(String pollId, ReportBean reportBean) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        this.saveReport(reportBean, pollId);
    }

    public void addQuestionReport(String pollId, String questionId, ReportBean reportBean) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.edit(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Report report = this.getReportService().addReport(reportBean, (PollenEntity)question);
        this.getNotificationService().onAddQuestionReport(question, report);
    }

    public List<ReportBean> getQuestionReports(String pollId, String questionId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.edit(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        return this.getReports(questionId);
    }

    public void saveQuestionReport(String pollId, String questionId, ReportBean reportBean) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.edit(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        this.saveReport(reportBean, questionId);
    }

    public void addChoiceReport(String pollId, String questionId, String choiceId, ReportBean reportBean) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(choiceId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.read(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.read(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Choice choice = this.getChoiceService().getChoice(question, choiceId);
        Question choiceQuestion = choice.getQuestion();
        if (!choiceQuestion.getTopiaId().equals(question.getTopiaId())) {
            throw new InvalidEntityLinkException("question", (PollenEntity)choice, (PollenEntity)question);
        }
        Report report = this.getReportService().addReport(reportBean, (PollenEntity)choice);
        this.getNotificationService().onAddChoiceReport(question, choice, report);
    }

    public List<ReportBean> getChoiceReports(String pollId, String questionId, String choiceId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(choiceId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.edit(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Choice choice = this.getChoiceService().getChoice(question, choiceId);
        Question choiceQuestion = choice.getQuestion();
        if (!choiceQuestion.getTopiaId().equals(question.getTopiaId())) {
            throw new InvalidEntityLinkException("question", (PollenEntity)choice, (PollenEntity)question);
        }
        return this.getReports(choiceId);
    }

    public void saveChoiceReport(String pollId, String questionId, String choiceId, ReportBean reportBean) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(choiceId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.edit(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Choice choice = this.getChoiceService().getChoice(question, choiceId);
        Question choiceQuestion = choice.getQuestion();
        if (!choiceQuestion.getTopiaId().equals(question.getTopiaId())) {
            throw new InvalidEntityLinkException("question", (PollenEntity)choice, (PollenEntity)question);
        }
        this.saveReport(reportBean, choiceId);
    }

    public void addCommentReport(String pollId, String commentId, ReportBean reportBean) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(commentId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.readComments(poll));
        Comment comment = this.getCommentService().getComment(poll, commentId);
        Report report = this.getReportService().addReport(reportBean, (PollenEntity)comment);
        this.getNotificationService().onAddCommentReport(poll, comment, report);
    }

    public void addQuestionCommentReport(String pollId, String questionId, String commentId, ReportBean reportBean) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(commentId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.readComments(poll));
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.readComments(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Comment comment = this.getCommentService().getComment(question, commentId);
        Report report = this.getReportService().addReport(reportBean, (PollenEntity)comment);
        this.getNotificationService().onAddQuestionCommentReport(question, comment, report);
    }

    public List<ReportBean> getCommentReports(String pollId, String commentId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(commentId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        return this.getReports(commentId);
    }

    public List<ReportBean> getQuestionCommentReports(String pollId, String questionId, String commentId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(commentId);
        Poll poll = this.getPollService().getPoll0(pollId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.edit(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        return this.getReports(commentId);
    }

    public void saveCommentReport(String pollId, String commentId, ReportBean reportBean) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        this.checkPermission(PollenPermissions.edit(poll));
        this.saveReport(reportBean, commentId);
    }

    public void saveQuestionCommentReport(String pollId, String questionId, String commentId, ReportBean reportBean) {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.edit(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        this.saveReport(reportBean, commentId);
    }

    protected List<ReportBean> getReports(String targetId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(targetId);
        List reports = this.getReportDao().forTargetIdEquals(targetId).findAll();
        return reports.stream().map(this::toReportBean).toList();
    }

    protected Report addReport(ReportBean report, PollenEntity target) throws InvalidFormException {
        this.checkNotNull(report);
        this.checkIsNotPersisted(report);
        this.checkNotNull(target);
        this.checkIsPersisted(target);
        ErrorMap errorMap = this.checkReport(report);
        errorMap.failIfNotEmpty();
        Report reportEntity = new Report();
        reportEntity.setTopiaId(report.getEntityId());
        reportEntity.setLevel(report.getLevel().getScore());
        reportEntity.setEmail(report.getEmail());
        reportEntity.setIgnore(report.isIgnore());
        reportEntity.setTargetId(target.getTopiaId());
        reportEntity = (Report)this.getReportDao().create((PollenEntity)reportEntity);
        this.commit();
        return reportEntity;
    }

    protected ErrorMap checkReport(ReportBean report) {
        ErrorMap errors = new ErrorMap();
        this.checkNotNull(errors, "level", (Object)report.getLevel(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.report.level.mandatory", (Object[])new Object[0]));
        this.checkNotNull(errors, "email", report.getEmail(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.report.email.mandatory", (Object[])new Object[0]));
        this.checkValidEmail(errors, "email", report.getEmail(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.report.email.invalid", (Object[])new Object[0]));
        return errors;
    }

    protected void saveReport(ReportBean reportBean, String targetId) {
        this.checkNotNull(reportBean);
        this.checkIsPersisted(reportBean);
        this.checkNotNull(targetId);
        Report report = (Report)this.getReportDao().forTopiaIdEquals(reportBean.getEntityId()).addEquals("targetId", (Object)targetId).findUnique();
        report.setIgnore(reportBean.isIgnore());
        this.commit();
    }

    public ReportResumeBean getReport(String targetId) {
        ReportResume report = this.getReportDao().getReportResume(targetId);
        return ReportResumeBean.of(report);
    }

    public long getScore(PollenEntity target) {
        ReportResume report = this.getReportDao().getReportResume(target.getTopiaId());
        return report.getScore();
    }
}

