/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.impl.EmailService;

public class PreventRuleService
extends PollenServiceSupport {
    public static final String SCOPE_VOTE = "vote";
    public static final String SCOPE_REMINDER = "rappel";
    private static final Log log = LogFactory.getLog(PreventRuleService.class);

    public PreventRule createAddVotePreventRule() {
        PreventRule rule = (PreventRule)this.newInstance(this.getDAO(PreventRule.class));
        rule.setScope(SCOPE_VOTE);
        rule.setSensibility(1);
        rule.setRepeated(true);
        return rule;
    }

    public PreventRule createRemindPreventRule(int sensibility) {
        PreventRule rule = (PreventRule)this.newInstance(this.getDAO(PreventRule.class));
        rule.setScope(SCOPE_REMINDER);
        rule.setSensibility(sensibility);
        rule.setRepeated(false);
        return rule;
    }

    public void onVoteAdded(Poll poll) {
        if (poll.getEndDate() != null) {
            for (PreventRule rule : poll.getPreventRule()) {
                this.onVoteAdded(poll, rule);
            }
        }
    }

    public void onPollToRemind(Poll poll) {
        if (poll.getEndDate() != null) {
            Date now = this.serviceContext.getCurrentTime();
            long timeValue = poll.getEndDate().getTime() - now.getTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Now: " + now.getTime() + " End: " + poll.getEndDate().getTime() + " timeValue: " + timeValue + "(" + timeValue / 3600000L + "h)"));
            }
            int hourBeforeEnd = (int)(timeValue / 3600000L);
            for (PreventRule rule : poll.getPreventRule()) {
                this.onPollToRemind(poll, rule, hourBeforeEnd);
            }
        }
    }

    protected void onVoteAdded(Poll poll, PreventRule preventRule) {
        if (this.execute(SCOPE_VOTE, preventRule, 1)) {
            EmailService emailService = this.newService(EmailService.class);
            emailService.onVoteAdded(poll);
            this.commitTransaction("Could not update prevent rule");
        }
    }

    protected void onPollToRemind(Poll poll, PreventRule preventRule, int timeValue) {
        if (this.execute(SCOPE_REMINDER, preventRule, timeValue)) {
            EmailService emailService = this.newService(EmailService.class);
            emailService.onPollReminder(poll);
            this.commitTransaction("Could not update prevent rule");
        }
    }

    protected boolean execute(String scope, PreventRule preventRule, Integer value) {
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkNotNull((Object)value);
        if (!preventRule.isActive()) {
            log.debug((Object)"R\u00e8gle non active");
            return false;
        }
        if (preventRule.isOneTime()) {
            log.debug((Object)"R\u00e8gle \u00e0 ex\u00e9cution unique : d\u00e9sactivation");
            preventRule.setActive(false);
        }
        if (!scope.equals(preventRule.getScope())) {
            return false;
        }
        if (preventRule.isRepeated() && preventRule.getSensibility() != 0) {
            value = value % preventRule.getSensibility() + preventRule.getSensibility();
        }
        return value.intValue() == preventRule.getSensibility();
    }
}

