/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollDateChoice;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceDAO;
import org.chorem.pollen.business.persistence.ChoiceImpl;
import org.chorem.pollen.business.persistence.ChoiceType;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.PreventRuleDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListDAO;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.PollAccountNotFound;
import org.chorem.pollen.services.exceptions.PollChoiceNotFoundException;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.impl.EmailService;
import org.chorem.pollen.services.impl.PollFeedService;
import org.chorem.pollen.services.impl.UserService;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;
import org.nuiton.util.beans.Binder;

public class PollService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(PollService.class);
    public static final String THUMB_PREFIX = "thumb_";

    public Poll getPollEditable(String pollUid, UserAccount userAccount, boolean clone) throws PollNotFoundException {
        Poll result;
        if (StringUtils.isEmpty((CharSequence)pollUid)) {
            PollDAO pollDAO = (PollDAO)this.getDAO(Poll.class);
            result = (Poll)this.newInstance(pollDAO);
            PollenConfiguration configuration = this.getConfiguration();
            result.setChoiceType(configuration.getDefaultChoiceType());
            result.setVoteCountingType(configuration.getDefaultVoteCountingType());
            result.setPollType(configuration.getDefaultPollType());
            result.setPollVoteVisibility(configuration.getDefaultPollVoteVisibility());
            result.setPollCommentVisibility(configuration.getDefaultPollCommentVisibility());
            PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
            PollAccount creator = (PollAccount)this.newInstance(pollAccountDAO);
            if (userAccount != null) {
                creator.setVotingId(userAccount.getDisplayName());
                creator.setEmail(userAccount.getEmail());
                creator.setUserAccount(userAccount);
            }
            result.setCreator(creator);
        } else {
            Poll poll = this.getExistingPollByPollId(pollUid);
            PollDAO pollDAO = (PollDAO)this.getDAO(Poll.class);
            result = (Poll)this.newInstance(pollDAO);
            PollenBinderHelper.simpleCopy((TopiaEntity)poll, (TopiaEntity)result, (!clone ? 1 : 0) != 0);
            if (clone) {
                result.setPollId(null);
            }
            PollAccount creatorLoaded = poll.getCreator();
            PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
            PollAccount creatorEditable = (PollAccount)this.newInstance(pollAccountDAO);
            result.setCreator(creatorEditable);
            PollenBinderHelper.simpleCopy((TopiaEntity)creatorLoaded, (TopiaEntity)creatorEditable, (!clone ? 1 : 0) != 0);
            if (clone) {
                creatorEditable.setAccountId(null);
            }
            if (creatorEditable.getUserAccount() == null) {
                creatorEditable.setUserAccount(userAccount);
            }
            Function<Choice, Choice> choiceCreator = PollenServiceFunctions.newChoiceCreator(poll.getChoiceType());
            Iterable choices = Iterables.transform((Iterable)poll.getChoice(), choiceCreator);
            for (Choice choiceLoaded : choices) {
                if (clone) {
                    choiceLoaded.setTopiaId(null);
                }
                result.addChoice(choiceLoaded);
            }
            VotingListDAO votingListDAO = (VotingListDAO)this.getDAO(VotingList.class);
            PersonToListDAO personToListDAO = (PersonToListDAO)this.getDAO(PersonToList.class);
            for (VotingList votingListLoaded : poll.getVotingList()) {
                VotingList votingListEditable = (VotingList)this.newInstance(votingListDAO);
                result.addVotingList(votingListEditable);
                PollenBinderHelper.simpleCopy((TopiaEntity)votingListLoaded, (TopiaEntity)votingListEditable, (boolean)false);
                for (PersonToList personToListLoaded : votingListLoaded.getPollAccountPersonToList()) {
                    PersonToList personToListEditable = (PersonToList)this.newInstance(personToListDAO);
                    votingListEditable.addPollAccountPersonToList(personToListEditable);
                    PollenBinderHelper.simpleCopy((TopiaEntity)personToListLoaded, (TopiaEntity)personToListEditable, (boolean)false);
                    PollAccount personLoaded = personToListLoaded.getPollAccount();
                    PollAccount personEditable = (PollAccount)this.newInstance(pollAccountDAO);
                    personToListEditable.setPollAccount(personEditable);
                    PollenBinderHelper.simpleCopy((TopiaEntity)personLoaded, (TopiaEntity)personEditable, (boolean)false);
                    if (!clone) continue;
                    personEditable.setAccountId(null);
                }
            }
            PreventRuleDAO preventRuleDAO = (PreventRuleDAO)this.getDAO(PreventRule.class);
            for (PreventRule preventRuleLoaded : poll.getPreventRule()) {
                PreventRule preventRuleEditable = (PreventRule)this.newInstance(preventRuleDAO);
                PollenBinderHelper.simpleCopy((TopiaEntity)preventRuleLoaded, (TopiaEntity)preventRuleEditable, (!clone ? 1 : 0) != 0);
                result.addPreventRule(preventRuleEditable);
            }
            result.setVote(poll.getVote());
        }
        return result;
    }

    public Map<String, Object> pollToMap(Poll poll, Binder<Poll, Poll> binder) {
        String addingchoiceText;
        Map map = binder.obtainProperties((Object)poll, new String[]{"title", "pollId", "description"});
        Locale l = this.serviceContext.getLocale();
        if (poll.getBeginDate() == null) {
            map.put("beginDate", I18n.l_((Locale)l, (String)"pollen.common.undefined", (Object[])new Object[0]));
        } else {
            map.put("beginDate", this.decorateDate(poll.getBeginDate()));
        }
        if (poll.getEndDate() == null) {
            map.put("endDate", I18n.l_((Locale)l, (String)"pollen.common.undefined", (Object[])new Object[0]));
        } else {
            map.put("endDate", this.decorateDate(poll.getEndDate()));
        }
        map.put("topiaCreateDate", this.decorateDateTime(poll.getTopiaCreateDate()));
        if (poll.isChoiceAddAllowed()) {
            Date beginDate = poll.getBeginChoiceDate();
            Date endDate = poll.getEndChoiceDate();
            addingchoiceText = beginDate == null && endDate == null ? I18n.l_((Locale)l, (String)"pollen.common.addingChoicesAlways", (Object[])new Object[0]) : (beginDate == null ? I18n.l_((Locale)l, (String)"pollen.common.addingChoicesTo", (Object[])new Object[]{this.decorateDate(endDate)}) : (endDate == null ? I18n.l_((Locale)l, (String)"pollen.common.addingChoicesFrom", (Object[])new Object[]{this.decorateDate(beginDate)}) : I18n.l_((Locale)l, (String)"pollen.common.addingChoicesContent", (Object[])new Object[]{this.decorateDate(beginDate), this.decorateDate(endDate)})));
        } else {
            addingchoiceText = I18n.l_((Locale)l, (String)"pollen.common.unauthorized", (Object[])new Object[0]);
        }
        map.put("addingChoices", addingchoiceText);
        map.put("id", poll.getTopiaId());
        return map;
    }

    public Poll createPoll(Poll poll) {
        PollDAO pollDAO = (PollDAO)this.getDAO(Poll.class);
        Poll result = (Poll)this.createWithProperties(pollDAO, "pollId", this.serviceContext.generateId(), "pollVoteVisibility", poll.getPollVoteVisibility(), "pollCommentVisibility", poll.getPollCommentVisibility());
        result.setAnonymousVoteAllowed(poll.isAnonymousVoteAllowed());
        result.setChoiceAddAllowed(poll.isChoiceAddAllowed());
        result.setBeginChoiceDate(poll.getBeginChoiceDate());
        result.setBeginDate(poll.getBeginDate());
        result.setChoiceType(poll.getChoiceType());
        result.setContinuousResults(poll.isContinuousResults());
        result.setDescription(poll.getDescription());
        result.setEndDate(poll.getEndDate());
        result.setEndChoiceDate(poll.getEndChoiceDate());
        result.setPollType(poll.getPollType());
        result.setMaxChoiceNb(poll.getMaxChoiceNb());
        result.setPublicResults(poll.isPublicResults());
        result.setTitle(poll.getTitle());
        result.setVoteCountingType(poll.getVoteCountingType());
        PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
        PollAccount creatorCreated = (PollAccount)this.createWithProperties(pollAccountDAO, "accountId", this.serviceContext.generateId());
        PollAccount creator = poll.getCreator();
        creatorCreated.setVotingId(creator.getVotingId());
        creatorCreated.setEmail(creator.getEmail());
        creatorCreated.setUserAccount(creator.getUserAccount());
        result.setCreator(creatorCreated);
        for (Choice choice : poll.getChoice()) {
            this.saveChoice(result, choice);
        }
        for (Choice choice : poll.getPreventRule()) {
            this.savePreventRule(result, (PreventRule)choice);
        }
        try {
            for (VotingList votingList : poll.getVotingList()) {
                this.saveVotingList(result, votingList, null);
            }
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Can't save votingLists", (Throwable)e);
        }
        PollFeedService pollFeedService = this.newService(PollFeedService.class);
        pollFeedService.onPollCreated(result);
        this.commitTransaction("Could not create poll " + poll.getTitle());
        EmailService emailService = this.newService(EmailService.class);
        emailService.onPollCreated(result);
        return result;
    }

    public Poll updatePoll(Poll poll) throws PollNotFoundException {
        Poll pollToUpdate = this.getEntityById(Poll.class, poll.getTopiaId());
        if (pollToUpdate == null) {
            throw new PollNotFoundException();
        }
        boolean voteStarted = pollToUpdate.sizeVote() > 0;
        PollAccount creatorToUpdate = pollToUpdate.getCreator();
        PollenBinderHelper.simpleCopy((TopiaEntity)poll, (TopiaEntity)pollToUpdate, (boolean)false);
        PollAccount creator = poll.getCreator();
        creatorToUpdate.setUserAccount(creator.getUserAccount());
        creatorToUpdate.setVotingId(creator.getVotingId());
        creatorToUpdate.setEmail(creator.getEmail());
        if (!voteStarted) {
            LinkedList choicesAdded = Lists.newLinkedList();
            for (Choice choice : poll.getChoice()) {
                Choice choiceLoaded = this.saveChoice(pollToUpdate, choice);
                choicesAdded.add(choiceLoaded);
            }
            pollToUpdate.clearChoice();
            pollToUpdate.addAllChoice((List)choicesAdded);
        }
        for (PreventRule preventRule : poll.getPreventRule()) {
            this.savePreventRule(pollToUpdate, preventRule);
        }
        if (!voteStarted) {
            EmailService emailService = this.newService(EmailService.class);
            pollToUpdate.clearVotingList();
            try {
                for (VotingList votingList : poll.getVotingList()) {
                    this.saveVotingList(pollToUpdate, votingList, emailService);
                }
            }
            catch (TopiaException e) {
                throw new PollenTechnicalException("Can't save votingLists", (Throwable)e);
            }
        }
        this.commitTransaction("Could not update poll [" + poll.getTopiaId() + "]");
        return pollToUpdate;
    }

    public List<Poll> getPolls(TopiaPagerBean pager) {
        Preconditions.checkNotNull((Object)pager);
        try {
            PollDAO dao = (PollDAO)this.getDAO(Poll.class);
            List result = dao.getPolls(pager);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain polls", (Throwable)e);
        }
    }

    public List<Poll> getCreatedPolls(TopiaPagerBean pager, UserAccount user) {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        try {
            PollDAO dao = (PollDAO)this.getDAO(Poll.class);
            List result = dao.findCreatedPolls(pager, user);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain created polls", (Throwable)e);
        }
    }

    public List<Pair<Poll, PollAccount>> getInvitedPolls(TopiaPagerBean pager, UserAccount user) {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        UserService userService = this.newService(UserService.class);
        UserAccount userToUse = userService.getEntityById(UserAccount.class, user.getTopiaId());
        Preconditions.checkNotNull((Object)userToUse);
        try {
            PollDAO pollDao = (PollDAO)this.getDAO(Poll.class);
            List result = pollDao.findInvitedPolls(pager, userToUse);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain invited polls", (Throwable)e);
        }
    }

    public List<Pair<Poll, PollAccount>> getParticipatedPolls(TopiaPagerBean pager, UserAccount user) {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        UserService userService = this.newService(UserService.class);
        UserAccount userToUse = userService.getEntityById(UserAccount.class, user.getTopiaId());
        Preconditions.checkNotNull((Object)userToUse);
        try {
            PollDAO pollDao = (PollDAO)this.getDAO(Poll.class);
            List result = pollDao.findParticipatedPolls(pager, userToUse);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain running polls", (Throwable)e);
        }
    }

    public List<Poll> getRunningPolls(Date currentTime) {
        try {
            PollDAO dao = (PollDAO)this.getDAO(Poll.class);
            List results = dao.findRunningPolls(currentTime);
            return results;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain running polls", (Throwable)e);
        }
    }

    public Poll getPollByPollId(String pollId) {
        Preconditions.checkNotNull((Object)pollId);
        try {
            PollDAO dao = (PollDAO)this.getDAO(Poll.class);
            Poll result = dao.findByPollId(pollId);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not find poll with pollId '" + pollId + "'", (Throwable)e);
        }
    }

    public Poll getExistingPollByPollId(String pollId) throws PollNotFoundException {
        Poll result = this.getPollByPollId(pollId);
        if (result == null) {
            throw new PollNotFoundException();
        }
        return result;
    }

    public PollAccount getPollAccountEditable(String accountId, UserAccount userAccount, Poll poll) throws PollAccountNotFound {
        boolean withUserAccount;
        PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
        PollAccount pollAccountLoaded = null;
        boolean bl = withUserAccount = userAccount != null;
        if (StringUtils.isNotEmpty((CharSequence)accountId) || withUserAccount) {
            if (poll.getCreator().getAccountId().equals(accountId)) {
                pollAccountLoaded = poll.getCreator();
            } else {
                if (poll.isPollFree()) {
                    try {
                        pollAccountLoaded = dao.findVoterPollAccount(poll.getPollId(), accountId, userAccount);
                    }
                    catch (TopiaException e) {
                        throw new PollenTechnicalException((Throwable)e);
                    }
                }
                try {
                    pollAccountLoaded = dao.findRestrictedPollAccount(poll.getPollId(), accountId, userAccount);
                }
                catch (TopiaException e) {
                    throw new PollenTechnicalException((Throwable)e);
                }
            }
        }
        PollAccount result = null;
        if (pollAccountLoaded != null) {
            result = (PollAccount)this.newInstance(dao);
            PollenBinderHelper.copy((String)"", (TopiaEntity)pollAccountLoaded, (TopiaEntity)result, (boolean)true);
            result.setUserAccount(pollAccountLoaded.getUserAccount());
            if (withUserAccount && result.getUserAccount() == null) {
                result.setUserAccount(userAccount);
            }
        }
        if (result == null) {
            result = (PollAccount)this.newInstance(dao);
            String votingId = userAccount != null ? userAccount.getDisplayName() : "";
            result.setVotingId(votingId);
            result.setUserAccount(userAccount);
        }
        return result;
    }

    public void deletePoll(String pollId) throws PollNotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pollId));
        Poll pollToDelete = this.getExistingPollByPollId(pollId);
        PollDAO dao = (PollDAO)this.getDAO(Poll.class);
        this.delete(dao, pollToDelete);
        this.commitTransaction("Could not delete poll" + pollToDelete.getTitle());
    }

    public void closePoll(String pollId) throws PollNotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pollId));
        Poll poll = this.getExistingPollByPollId(pollId);
        if (!poll.isChoiceEmpty()) {
            for (Choice choice : poll.getChoice()) {
                choice.setValidate(true);
            }
        }
        Date now = this.serviceContext.getCurrentTime();
        if (poll.getEndDate() == null || now.before(poll.getEndDate())) {
            poll.setEndDate(now);
        }
        poll.setClosed(true);
        this.commitTransaction("Could not close poll " + poll.getTitle());
    }

    public void attachPoll(String pollId, UserAccount userAccount) throws PollNotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pollId));
        Preconditions.checkNotNull((Object)userAccount);
        Poll poll = this.getExistingPollByPollId(pollId);
        PollAccount creator = poll.getCreator();
        creator.setUserAccount(userAccount);
        if (StringUtils.isEmpty((CharSequence)creator.getVotingId())) {
            creator.setVotingId(userAccount.getDisplayName());
        }
        if (StringUtils.isEmpty((CharSequence)creator.getEmail())) {
            creator.setEmail(userAccount.getEmail());
        }
        this.commitTransaction("Could not attach poll " + poll.getTitle() + " to user account " + userAccount.getDisplayName());
    }

    public Choice getNewChoice(ChoiceType choiceType) {
        ChoiceImpl result;
        switch (choiceType) {
            case DATE: {
                result = new PollDateChoice();
                break;
            }
            case IMAGE: {
                result = new PollImageChoice();
                break;
            }
            default: {
                ChoiceDAO dao = (ChoiceDAO)this.getDAO(Choice.class);
                result = (Choice)this.newInstance(dao);
            }
        }
        return result;
    }

    public void addChoice(String pollId, Choice choice) throws PollNotFoundException {
        Preconditions.checkNotNull((Object)pollId);
        Preconditions.checkNotNull((Object)choice);
        Poll poll = this.getExistingPollByPollId(pollId);
        this.saveChoice(poll, choice);
        this.commitTransaction("Can't create new choice [" + poll.getChoiceType() + "] for poll '" + pollId + "'");
    }

    protected Choice saveChoice(Poll poll, Choice choice) {
        Choice choiceLoaded;
        boolean newChoice;
        ChoiceType choiceType = poll.getChoiceType();
        ChoiceDAO dao = (ChoiceDAO)this.getDAO(Choice.class);
        boolean bl = newChoice = choice.getTopiaId() == null;
        if (newChoice) {
            choiceLoaded = (Choice)this.create(dao);
            poll.addChoice(choiceLoaded);
        } else {
            choiceLoaded = poll.getChoiceByTopiaId(choice.getTopiaId());
        }
        if (choiceType == ChoiceType.IMAGE) {
            PollImageChoice imageChoice = (PollImageChoice)choice;
            if (newChoice || !ObjectUtils.equals((Object)choice.getName(), (Object)choiceLoaded.getName())) {
                try {
                    this.saveImages(poll, imageChoice);
                }
                catch (IOException e) {
                    throw new PollenTechnicalException("Could not create image choice", (Throwable)e);
                }
                imageChoice.toChoice(choiceLoaded);
            }
        } else if (choiceType == ChoiceType.DATE) {
            PollDateChoice dateChoice = (PollDateChoice)choice;
            dateChoice.toChoice(choiceLoaded);
        } else {
            choiceLoaded.setDescription(choice.getDescription());
            choiceLoaded.setValidate(choice.isValidate());
            choiceLoaded.setName(choice.getName());
        }
        return choiceLoaded;
    }

    public void deleteChoice(String pollId, String choiceId) throws PollNotFoundException, PollChoiceNotFoundException {
        Poll poll = this.getExistingPollByPollId(pollId);
        Choice choice = poll.getChoiceByTopiaId(choiceId);
        if (choice == null) {
            throw new PollChoiceNotFoundException();
        }
        ChoiceDAO dao = (ChoiceDAO)this.getDAO(Choice.class);
        poll.removeChoice(choice);
        this.delete(dao, choice);
        this.commitTransaction("Could not delete choice " + choice.getName());
    }

    public File getPollChoiceImageFile(String pollId, String choiceId) {
        File imageDirectory = this.getConfiguration().getImageDirectory();
        File pollDirectory = new File(imageDirectory, pollId);
        File result = new File(pollDirectory, choiceId);
        return result;
    }

    public File getImageThumbFile(File imagePath) {
        File imageDirectory = imagePath.getParentFile();
        File result = new File(imageDirectory, THUMB_PREFIX + imagePath.getName());
        return result;
    }

    public void saveImages(Poll poll, PollImageChoice choice) throws IOException {
        String pollId = poll.getPollId();
        String name = choice.getName();
        File pollChoiceImage = this.getPollChoiceImageFile(pollId, name);
        String location = choice.getLocation();
        FileUtils.copyFile((File)new File(location), (File)pollChoiceImage);
        this.generateThumbIfNeeded(pollChoiceImage);
    }

    public File generateThumbIfNeeded(File pollChoiceImage) throws IOException {
        File pollChoiceImageThumb = this.getImageThumbFile(pollChoiceImage);
        if (!pollChoiceImageThumb.exists()) {
            int width = 100;
            ImageIcon ii = new ImageIcon(pollChoiceImage.getAbsolutePath());
            Image image = ii.getImage();
            double imageRatio = (double)image.getHeight(null) / (double)image.getWidth(null);
            int height = (int)((double)width * imageRatio);
            BufferedImage thumbImage = new BufferedImage(width, height, 1);
            Graphics2D graphics2D = thumbImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(image, 0, 0, width, height, null);
            ImageIO.write((RenderedImage)thumbImage, "jpg", pollChoiceImageThumb);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Thumbnail created: " + pollChoiceImageThumb.getName() + " (size=" + pollChoiceImageThumb.length() + ")"));
            }
        }
        return pollChoiceImageThumb;
    }

    public PersonToList getNewPersonToList(PollAccount pollAccount) {
        PersonToList result = (PersonToList)this.newInstance(this.getDAO(PersonToList.class));
        result.setWeight(1.0);
        PollAccount pollAccount2 = (PollAccount)this.newInstance(this.getDAO(PollAccount.class));
        result.setPollAccount(pollAccount2);
        if (pollAccount != null) {
            pollAccount2.setEmail(pollAccount.getEmail());
            pollAccount2.setUserAccount(pollAccount.getUserAccount());
            pollAccount2.setVotingId(pollAccount.getVotingId());
        }
        return result;
    }

    protected void saveVotingList(Poll poll, VotingList votingList, EmailService emailService) throws TopiaException {
        VotingList result;
        VotingListDAO votingListDAO = (VotingListDAO)this.getDAO(VotingList.class);
        PersonToListDAO personToListDAO = (PersonToListDAO)this.getDAO(PersonToList.class);
        PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
        String creatorEmail = poll.getCreator().getEmail();
        if (votingList.getTopiaId() == null) {
            result = (VotingList)this.create(votingListDAO);
            poll.addVotingList(result);
        } else {
            result = poll.getVotingListByTopiaId(votingList.getTopiaId());
        }
        result.setName(votingList.getName());
        result.setWeight(votingList.getWeight());
        ArrayList personToListsUpdated = Lists.newArrayList();
        for (PersonToList personToList : votingList.getPollAccountPersonToList()) {
            PollAccount pollAccountLoaded;
            PersonToList personToListLoaded;
            PollAccount pollAccount = personToList.getPollAccount();
            if (personToList.getTopiaId() == null) {
                personToListLoaded = (PersonToList)this.create(personToListDAO);
                personToListLoaded.setVotingList(result);
                String accountId = pollAccount.getAccountId();
                String accountEmail = pollAccount.getEmail();
                if (ObjectUtils.equals((Object)creatorEmail, (Object)pollAccount.getEmail())) {
                    pollAccountLoaded = pollAccountDAO.findByAccountId(poll.getCreator().getAccountId());
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Use the creator account as restricted account [%s]", accountEmail));
                    }
                } else if (StringUtils.isBlank((CharSequence)accountId)) {
                    pollAccountLoaded = (PollAccount)this.createWithProperties(pollAccountDAO, "accountId", this.serviceContext.generateId());
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Create new account as restricted account [%s]", accountEmail));
                    }
                } else {
                    pollAccountLoaded = pollAccountDAO.findByAccountId(accountId);
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Reuse existing account as restricted account [%s]", accountEmail));
                    }
                }
            } else {
                personToListLoaded = this.getEntityById(PersonToList.class, personToList.getTopiaId());
                pollAccountLoaded = personToListLoaded.getPollAccount();
            }
            personToListsUpdated.add(personToListLoaded);
            personToListLoaded.setWeight(personToList.getWeight());
            pollAccountLoaded.setVotingId(pollAccount.getVotingId());
            boolean emailChanged = !Objects.equal((Object)pollAccountLoaded.getEmail(), (Object)pollAccount.getEmail());
            pollAccountLoaded.setEmail(pollAccount.getEmail());
            if (emailService != null && emailChanged) {
                emailService.onRestrictedPersonAdded(poll, pollAccountLoaded);
            }
            PollAccount pollAccountUpdated = this.update(pollAccountDAO, pollAccountLoaded);
            personToListLoaded.setPollAccount(pollAccountUpdated);
        }
        result.setPollAccountPersonToList((List)personToListsUpdated);
    }

    protected void savePreventRule(Poll poll, PreventRule preventRule) {
        PreventRuleDAO preventRuleDAO = (PreventRuleDAO)this.getDAO(PreventRule.class);
        PreventRule preventRuleLoaded = poll.getPreventRuleByScope(preventRule.getScope());
        if (preventRuleLoaded == null) {
            preventRuleLoaded = (PreventRule)this.create(preventRuleDAO);
            poll.addPreventRule(preventRuleLoaded);
            preventRuleLoaded.setScope(preventRule.getScope());
            preventRuleLoaded.setActive(true);
        }
        preventRuleLoaded.setMethod(preventRule.getMethod());
        preventRuleLoaded.setOneTime(preventRule.isOneTime());
        preventRuleLoaded.setRepeated(preventRule.isRepeated());
        preventRuleLoaded.setSensibility(preventRule.getSensibility());
    }

    protected static void createThumbnail(File img, File thumbCopied, int width) throws IOException {
        ImageIcon ii = new ImageIcon(img.getAbsolutePath());
        Image image = ii.getImage();
        double imageRatio = (double)image.getHeight(null) / (double)image.getWidth(null);
        int height = (int)((double)width * imageRatio);
        BufferedImage thumbImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        ImageIO.write((RenderedImage)thumbImage, "jpg", thumbCopied);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Thumbnail created: " + thumbCopied.getName() + " (size=" + thumbCopied.length() + ")"));
        }
    }
}

