/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.chorem.pollen.bean.PollDateChoice;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.bean.PollResult;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceImpl;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListImpl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountImpl;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListImpl;
import org.chorem.pollen.common.ChoiceType;
import org.nuiton.topia.persistence.TopiaEntity;

public class PollenServiceFunctions {
    public static final Function<Choice, String> CHOICE_TO_NAME = new Function<Choice, String>(){

        public String apply(Choice input) {
            return input.getName();
        }
    };
    public static final Function<ChoiceType, String> CHOICE_TYPE_TO_PROPERTY_NAME = new Function<ChoiceType, String>(){

        public String apply(ChoiceType choiceType) {
            String result;
            switch (choiceType) {
                case DATE: {
                    result = "date";
                    break;
                }
                case IMAGE: {
                    result = "location";
                    break;
                }
                default: {
                    result = "name";
                }
            }
            return result;
        }
    };

    protected PollenServiceFunctions() {
    }

    public static void fillChoiceList(List<Choice> choiceList, int max, Function<Choice, Choice> function) {
        while (choiceList.size() < max) {
            Choice newChoice = (Choice)function.apply(null);
            choiceList.add(newChoice);
        }
    }

    public static void fillVotingList(VotingList votingList, Function<PersonToList, PersonToList> persontoListCreator, int max) {
        while (votingList.sizePollAccountPersonToList() < max) {
            PersonToList newPersontoList = (PersonToList)persontoListCreator.apply(null);
            votingList.addPollAccountPersonToList(newPersontoList);
        }
    }

    public static TopiaIdExtractor newTopiaIdExtractor() {
        return new TopiaIdExtractor();
    }

    public static TextChoiceCreator newTextChoiceCreator() {
        return new TextChoiceCreator();
    }

    public static ImageChoiceCreator newImageChoiceCreator() {
        return new ImageChoiceCreator();
    }

    public static DateChoiceCreator newDateChoiceCreator() {
        return new DateChoiceCreator();
    }

    public static Function<Choice, Choice> newChoiceCreator(ChoiceType choiceType) {
        Object result;
        switch (choiceType) {
            case DATE: {
                result = PollenServiceFunctions.newDateChoiceCreator();
                break;
            }
            case IMAGE: {
                result = PollenServiceFunctions.newImageChoiceCreator();
                break;
            }
            default: {
                result = PollenServiceFunctions.newTextChoiceCreator();
            }
        }
        return result;
    }

    public static Function<VotingList, VotingList> newVotingListCreator(Function<PersonToList, PersonToList> persontoListCreator) {
        return new VotingListCreator(persontoListCreator);
    }

    public static Function<PersonToList, PersonToList> newPersonToListCreator() {
        return new PersonToListCreator();
    }

    public static Function<Result, PollResult> newResultToBeanFunction(final Poll poll) {
        return new Function<Result, PollResult>(){

            public PollResult apply(Result res) {
                PollResult dto = new PollResult();
                dto.setId(res.getTopiaId());
                dto.setPollId(poll.getPollId());
                String resName = res.getName();
                dto.setName(resName);
                dto.setHidden(resName != null && resName.startsWith("HIDDEN_"));
                dto.setValue(res.getResultValue());
                dto.setByGroup(res.isByGroup());
                dto.setChoiceType(poll.getChoiceType());
                dto.setVoteCountingType(poll.getVoteCountingType());
                return dto;
            }
        };
    }

    public static class PersonToListCreator
    implements Function<PersonToList, PersonToList> {
        public PersonToList apply(PersonToList input) {
            PersonToListImpl result = new PersonToListImpl();
            if (input != null) {
                result.setTopiaId(input.getTopiaId());
                result.setWeight(input.getWeight());
                PollAccount pollAccount = input.getPollAccount();
                if (pollAccount != null) {
                    PollAccountImpl pollAccount2 = new PollAccountImpl();
                    pollAccount2.setTopiaId(pollAccount.getTopiaId());
                    pollAccount2.setAccountId(pollAccount.getAccountId());
                    pollAccount2.setVotingId(pollAccount.getVotingId());
                    result.setPollAccount((PollAccount)pollAccount2);
                }
            } else {
                result.setWeight(1.0);
            }
            return result;
        }
    }

    public static class VotingListCreator
    implements Function<VotingList, VotingList> {
        protected final Function<PersonToList, PersonToList> persontoListCreator;

        protected VotingListCreator(Function<PersonToList, PersonToList> persontoListCreator) {
            this.persontoListCreator = persontoListCreator;
        }

        public VotingList apply(VotingList input) {
            VotingListImpl result = new VotingListImpl();
            result.setPollAccountPersonToList((List)Lists.newArrayList());
            if (input == null) {
                result.setWeight(1.0);
            } else {
                result.setTopiaId(input.getTopiaId());
                result.setName(input.getName());
                result.setWeight(input.getWeight());
                if (!input.isPollAccountPersonToListEmpty()) {
                    result.addAllPollAccountPersonToList(Lists.transform((List)input.getPollAccountPersonToList(), this.persontoListCreator));
                }
            }
            return result;
        }
    }

    public static class DateChoiceCreator
    implements Function<Choice, Choice> {
        public Choice apply(Choice input) {
            PollDateChoice result = new PollDateChoice();
            if (input != null) {
                result.setTopiaId(input.getTopiaId());
                result.setName(input.getName());
                result.setDescription(input.getDescription());
                result.setDate(new Date(Long.valueOf(input.getName())));
            }
            return result;
        }
    }

    public static class ImageChoiceCreator
    implements Function<Choice, Choice> {
        public Choice apply(Choice input) {
            PollImageChoice result = new PollImageChoice();
            if (input != null) {
                result.setTopiaId(input.getTopiaId());
                result.setName(input.getName());
                result.setDescription(input.getDescription());
                result.setLocation(input.getName());
            }
            return result;
        }
    }

    public static class TextChoiceCreator
    implements Function<Choice, Choice> {
        public Choice apply(Choice input) {
            ChoiceImpl result = new ChoiceImpl();
            if (input != null) {
                result.setTopiaId(input.getTopiaId());
                result.setName(input.getName());
                result.setDescription(input.getDescription());
            }
            return result;
        }
    }

    public static class TopiaIdExtractor
    implements Function<TopiaEntity, String> {
        public String apply(TopiaEntity input) {
            return input.getTopiaId();
        }
    }
}

