/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VoteToChoiceDAO;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.PollAccountNotFound;
import org.chorem.pollen.services.exceptions.VoteNotFoundException;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class VoteService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(VoteService.class);

    public Vote getNewVote(Poll poll, PollAccount account) {
        Preconditions.checkNotNull((Object)poll);
        VoteDAO voteDAO = (VoteDAO)this.getDAO(Vote.class);
        VoteToChoiceDAO voteToChoiceDAO = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
        Vote result = (Vote)this.newInstance(voteDAO);
        result.setPollAccount(account);
        result.setWeight(1.0);
        for (Choice choice : poll.getChoice()) {
            VoteToChoice element = (VoteToChoice)this.newInstance(voteToChoiceDAO);
            element.setChoice(choice);
            result.addChoiceVoteToChoice(element);
        }
        return result;
    }

    public Vote getVoteEditable(Poll poll, PollAccount accountEditable) {
        Vote result;
        Vote voteLoaded;
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)accountEditable);
        VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
        try {
            voteLoaded = dao.findByAccountId(accountEditable.getAccountId());
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
        if (voteLoaded != null) {
            result = (Vote)this.newInstance(dao);
            PollenBinderHelper.simpleCopy((TopiaEntity)voteLoaded, (TopiaEntity)result, (boolean)true);
            result.setPollAccount(accountEditable);
            VoteToChoiceDAO voteToChoiceDAO = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
            ArrayList voteToChoices = Lists.newArrayList();
            List choices = poll.getChoice();
            for (int i = 0; i < choices.size(); ++i) {
                Choice choice = (Choice)choices.get(i);
                VoteToChoice voteToChoice = (VoteToChoice)this.newInstance(voteToChoiceDAO);
                voteToChoice.setChoice(choice);
                VoteToChoice voteToChoiceLoaded = voteLoaded.getChoiceVoteToChoice(choice);
                if (voteToChoiceLoaded != null) {
                    voteToChoice.setVoteValue(voteToChoiceLoaded.getVoteValue());
                }
                voteToChoices.add(i, voteToChoice);
            }
            result.setChoiceVoteToChoice((List)voteToChoices);
        } else {
            result = this.getNewVote(poll, accountEditable);
        }
        if (poll.getPollType() != PollType.FREE && accountEditable.getTopiaId() != null) {
            PersonToListDAO personToListDAO = (PersonToListDAO)this.getDAO(PersonToList.class);
            PersonToList personToList = personToListDAO.findByPollAndAccount(poll, accountEditable);
            result.setWeight(personToList.getWeight());
        }
        return result;
    }

    public String getUpdateVoteUrl(PollUri pollUri) {
        Preconditions.checkNotNull((Object)pollUri.getAccountId());
        URL baseUrl = this.serviceContext.getApplicationURL();
        String result = String.format("%s/poll/votefor/%s", baseUrl, pollUri.getUri());
        return result;
    }

    public Vote createVote(Vote vote) throws PollAccountNotFound {
        PollAccount pollAccountLoaded;
        VoteDAO voteDAO = (VoteDAO)this.getDAO(Vote.class);
        Vote result = (Vote)this.create(voteDAO);
        result.setWeight(vote.getWeight());
        result.setAnonymous(vote.isAnonymous());
        PollAccount pollAccount = vote.getPollAccount();
        String pollAccountId = pollAccount.getTopiaId();
        if (pollAccountId != null) {
            pollAccountLoaded = this.getEntityById(PollAccount.class, pollAccountId);
        } else {
            PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
            pollAccountLoaded = (PollAccount)this.create(pollAccountDAO);
            pollAccountLoaded.setAccountId(pollAccount.getAccountId());
        }
        if (!vote.isAnonymous()) {
            pollAccountLoaded.setVotingId(pollAccount.getVotingId());
            pollAccountLoaded.setEmail(pollAccount.getEmail());
            UserAccount userAccount = pollAccount.getUserAccount();
            if (userAccount != null) {
                UserAccount userAccountLoaded = this.getEntityById(UserAccount.class, userAccount.getTopiaId());
                pollAccountLoaded.setUserAccount(userAccountLoaded);
            }
        }
        result.setPollAccount(pollAccountLoaded);
        for (VoteToChoice input : vote.getChoiceVoteToChoice()) {
            Integer value = input.getVoteValue();
            if (value == null) continue;
            this.createVoteToChoice(result, input);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entity created: " + result.getTopiaId()));
        }
        this.commitTransaction("Could not create vote");
        return result;
    }

    public Vote updateVote(Vote vote) throws VoteNotFoundException {
        Vote result = this.getEntityById(Vote.class, vote.getTopiaId());
        if (result == null) {
            throw new VoteNotFoundException();
        }
        PollAccount voteAccount = vote.getPollAccount();
        PollAccount pollAccountEntity = result.getPollAccount();
        if (vote.isAnonymous()) {
            pollAccountEntity.setVotingId(null);
            pollAccountEntity.setEmail(null);
            pollAccountEntity.setUserAccount(null);
        } else {
            pollAccountEntity.setVotingId(voteAccount.getVotingId());
            pollAccountEntity.setEmail(voteAccount.getEmail());
            pollAccountEntity.setUserAccount(voteAccount.getUserAccount());
        }
        result.setAnonymous(vote.isAnonymous());
        for (VoteToChoice input : vote.getChoiceVoteToChoice()) {
            Integer value = input.getVoteValue();
            VoteToChoice voteToChoiceEntity = result.getChoiceVoteToChoice(input.getChoice());
            if (value != null) {
                if (voteToChoiceEntity != null) {
                    voteToChoiceEntity.setVoteValue(value);
                    continue;
                }
                this.createVoteToChoice(result, input);
                continue;
            }
            if (voteToChoiceEntity == null) continue;
            this.deleteVoteToChoice(result, voteToChoiceEntity);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entity updated: " + result.getTopiaId()));
        }
        this.commitTransaction("Could not update vote");
        return result;
    }

    protected VoteToChoice createVoteToChoice(Vote vote, VoteToChoice source) {
        VoteToChoiceDAO voteToChoiceDao = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
        VoteToChoice result = (VoteToChoice)this.create(voteToChoiceDao);
        String choiceId = source.getChoice().getTopiaId();
        Choice choiceLoaded = this.getEntityById(Choice.class, choiceId);
        result.setChoice(choiceLoaded);
        result.setVote(vote);
        result.setVoteValue(source.getVoteValue());
        vote.addChoiceVoteToChoice(result);
        return result;
    }

    protected void deleteVoteToChoice(Vote vote, VoteToChoice entity) {
        VoteToChoiceDAO voteToChoiceDao = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
        vote.removeChoiceVoteToChoice(entity);
        this.delete(voteToChoiceDao, entity);
    }

    public void deleteVote(String voteId) throws VoteNotFoundException {
        Vote entityToDelete = this.getEntityById(Vote.class, voteId);
        if (entityToDelete == null) {
            throw new VoteNotFoundException();
        }
        VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
        VoteToChoiceDAO voteToChoiceDao = (VoteToChoiceDAO)this.getDAO(VoteToChoice.class);
        ImmutableList voteToChoices = ImmutableList.copyOf((Collection)entityToDelete.getChoiceVoteToChoice());
        for (VoteToChoice voteToChoice : voteToChoices) {
            entityToDelete.removeChoiceVoteToChoice(voteToChoice);
            this.delete(voteToChoiceDao, voteToChoice);
        }
        Poll poll = entityToDelete.getPoll();
        if (PollType.FREE == poll.getPollType()) {
            PollAccount voteAccount = entityToDelete.getPollAccount();
            if (!voteAccount.equals(poll.getCreator())) {
                PollAccountDAO accountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
                this.delete(accountDAO, voteAccount);
            }
        } else {
            PersonToList personToList = poll.getPersonToListByVote(entityToDelete);
            personToList.setHasVoted(false);
        }
        poll.removeVote(entityToDelete);
        this.delete(dao, entityToDelete);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entity deleted: " + voteId));
        }
        this.commitTransaction("Could not delete vote");
    }

    public List<Vote> getVotesByPoll(Poll poll, TopiaFilterPagerUtil.FilterPagerBean pager) {
        try {
            VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
            List results = dao.getVotesByPoll(poll, pager);
            return results;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain votes", (Throwable)e);
        }
    }

    public boolean isVoteAllowed(Poll poll, PollAccount accountEditable) {
        boolean result;
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)accountEditable);
        Date now = this.serviceContext.getCurrentTime();
        if (poll.getCreator().equals(accountEditable)) {
            result = false;
        } else {
            result = poll.isRunning(now);
            if (poll.getPollType() != PollType.FREE) {
                PersonToListDAO personToListDAO = (PersonToListDAO)this.getDAO(PersonToList.class);
                PersonToList personToList = personToListDAO.findByPollAndAccount(poll, accountEditable);
                result &= personToList != null;
            }
        }
        return result;
    }

    public boolean isUpdateAllowed(Poll poll, String voteId, String accountId, UserAccount userConnected) {
        Date now = this.serviceContext.getCurrentTime();
        boolean result = false;
        Vote vote = poll.getVoteByTopiaId(voteId);
        if (vote != null && poll.isRunning(now)) {
            PollAccount votePollAccount = vote.getPollAccount();
            if (accountId != null && accountId.equals(votePollAccount.getAccountId())) {
                result = true;
            }
            if (userConnected != null) {
                UserAccount voteUserAccount = votePollAccount.getUserAccount();
                result = userConnected.equals(voteUserAccount);
            }
        }
        return result;
    }

    public boolean hasAlreadyVoted(String votingId, Poll poll) {
        try {
            VoteDAO dao = (VoteDAO)this.getDAO(Vote.class);
            boolean result = dao.hasAlreadyVoted(votingId, poll);
            return result;
        }
        catch (Exception e) {
            throw new PollenTechnicalException("Unable test vote existing for account with votingId = " + votingId + " and poll with uid = " + poll.getPollId(), (Throwable)e);
        }
    }

    public List<Vote> selectVotes(Map<String, Object> properties) {
        TopiaContext transaction = this.getTransaction();
        try {
            List voteEntities;
            VoteDAO voteDAO = PollenDAOHelper.getVoteDAO((TopiaContext)transaction);
            if (properties == null) {
                voteEntities = voteDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les votes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                voteEntities = voteDAO.findAllByProperties(properties);
            }
            ArrayList results = Lists.newArrayList((Iterable)voteEntities);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (Exception e) {
            throw new PollenTechnicalException("Could not obtain votes", (Throwable)e);
        }
    }
}

