/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.bean;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Date;
import org.chorem.pollen.bean.PollDateChoice;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.common.ChoiceType;

public final class ChoiceHelper {
    private ChoiceHelper() {
    }

    public static Object toValue(Choice choice, ChoiceType choiceType) {
        Object result;
        switch (choiceType) {
            case DATE: {
                if (choice instanceof PollDateChoice) {
                    result = ((PollDateChoice)choice).getDate();
                    break;
                }
                result = new Date(Long.parseLong(choice.getName()));
                break;
            }
            case IMAGE: {
                if (choice instanceof PollImageChoice) {
                    result = ((PollImageChoice)choice).getLocation();
                    break;
                }
                result = choice.getName();
                break;
            }
            default: {
                result = choice.getName();
            }
        }
        return result;
    }

    public static Function<Choice, Object> toValue(final ChoiceType type) {
        return new Function<Choice, Object>(){

            public Object apply(Choice input) {
                return ChoiceHelper.toValue(input, type);
            }
        };
    }

    public static Iterable<Object> toValues(Iterable<Choice> choices, ChoiceType choiceType) {
        return Iterables.transform(choices, ChoiceHelper.toValue(choiceType));
    }

    public static String getValuePropertyName(ChoiceType choiceType) {
        String result;
        switch (choiceType) {
            case DATE: {
                result = "date";
                break;
            }
            case IMAGE: {
                result = "location";
                break;
            }
            default: {
                result = "name";
            }
        }
        return result;
    }
}

