/*
 * #%L
 * Pollen :: Persistence
 * $Id: PollAccountDAOImpl.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/PollAccountDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

import java.util.List;

public class PollAccountDAOImpl<E extends PollAccount> extends PollAccountDAOAbstract<E> {

    public E getRestrictedPollAccount(String pollId,
                                      String accountId) throws TopiaException {

//                List<PersonToList> tmp = transaction.find(
//                "FROM " + PersonToList.class.getName() +
//                " WHERE pollAccount.accountId = :accountUId" +
//                " AND votingList.poll.pollId = :pollUId",
//                "accountUId", accountId,
//                "pollUId", pollId);

        TopiaQuery query = new TopiaQuery(PersonToList.class, "p").
                setSelect("p." + PersonToList.PROPERTY_POLL_ACCOUNT).
                addWhere("p." + PersonToList.PROPERTY_POLL_ACCOUNT + "." + PollAccount.PROPERTY_ACCOUNT_ID, TopiaQuery.Op.EQ, accountId).
                addWhere("p." + PersonToList.PROPERTY_VOTING_LIST + "." + VotingList.PROPERTY_POLL + "." + Poll.PROPERTY_POLL_ID, TopiaQuery.Op.EQ, pollId);
        E result = findByQuery(query);
        return result;
    }

    public List<E> getFavoriteListUsers(PersonList favoriteList,
                                        TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(favoriteList);
        Preconditions.checkNotNull(pager);


        int records = favoriteList.sizePollAccount();
        pager.setRecords(records);

        TopiaQuery query = createQuery("e");
        TopiaFilterPagerUtil.addPagerToQuery(query, pager);
        query.addWhere("e." + PollAccount.PROPERTY_PERSON_LIST, TopiaQuery.Op.EQ, favoriteList);

        List<E> result = findAllByQuery(query);
        return result;
    }

    public boolean isPollAccountExists(PersonList personListToUpdate,
                                       PollAccount pollAccount) throws TopiaException {

        Preconditions.checkNotNull(personListToUpdate);
        Preconditions.checkNotNull(pollAccount);

        // check there is other poll account in this list with same id
        TopiaQuery query = createQuery("e");
        query.addWhere("e." + PollAccount.PROPERTY_PERSON_LIST, TopiaQuery.Op.EQ, personListToUpdate);
        query.addWhere("e." + PollAccount.PROPERTY_EMAIL, TopiaQuery.Op.EQ, pollAccount.getEmail());

        String pollAccountId = pollAccount.getTopiaId();
        if (pollAccountId == null) {
            // no check necessary, it's a new pollAccount

        } else {
            query.addWhere("e." + PollAccount.TOPIA_ID, TopiaQuery.Op.NEQ, pollAccountId);
        }

        boolean result = existByQuery(query);
        return result;
    }
    
    public PollAccount findByPollVoteUser(Poll poll,
                                          UserAccount user) throws TopiaException {
        
        Preconditions.checkNotNull(poll);
        Preconditions.checkNotNull(user);
        
        TopiaQuery query = createQuery("e")
                .addFrom(Poll.class, "p")
                .addFrom(Vote.class, "v")
                .addEquals("p", poll)
                .addInElements("v", "p." + Poll.PROPERTY_VOTE)
                .addWhere("e = v." + Vote.PROPERTY_POLL_ACCOUNT)
                .addEquals("e." + PollAccount.PROPERTY_USER_ACCOUNT, user);
        PollAccount result = findByQuery(query);
        return result;
    }

    public boolean existsByPollVoteAccountId(String pollId,
                                             String accountId) throws TopiaException {

        Preconditions.checkNotNull(pollId);
        Preconditions.checkNotNull(accountId);

        TopiaQuery query = createQuery("e")
                .addFrom(Poll.class, "p")
                .addFrom(Vote.class, "v")
                .addEquals("p." + Poll.PROPERTY_POLL_ID, pollId)
                .addInElements("v", "p." + Poll.PROPERTY_VOTE)
                .addWhere("e = v." + Vote.PROPERTY_POLL_ACCOUNT)
                .addEquals("e." + PollAccount.PROPERTY_ACCOUNT_ID, accountId);
        boolean result = existByQuery(query);
        return result;
    }

} //PollAccountDAOImpl<E extends PollAccount>
