/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class PersonListAbstract extends TopiaEntityAbstract implements PersonList {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : owner
     */
    protected UserAccount owner;

    /**
     * Nom de l'attribut en BD : pollAccount
     */
    protected List<PollAccount> pollAccount;

    private static final long serialVersionUID = 7233403756282655586L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_OWNER, UserAccount.class, owner);
        visitor.visit(this, PROPERTY_POLL_ACCOUNT, List.class, PollAccount.class, pollAccount);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setOwner(UserAccount owner) {
        UserAccount oldValue = this.owner;
        fireOnPreWrite(PROPERTY_OWNER, oldValue, owner);
        this.owner = owner;
        fireOnPostWrite(PROPERTY_OWNER, oldValue, owner);
    }

    @Override
    public UserAccount getOwner() {
        fireOnPreRead(PROPERTY_OWNER, owner);
        UserAccount result = this.owner;
        fireOnPostRead(PROPERTY_OWNER, owner);
        return result;
    }

    @Override
    public void addPollAccount(PollAccount pollAccount) {
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, null, pollAccount);
        if (this.pollAccount == null) {
            this.pollAccount = new ArrayList<PollAccount>();
        }

        pollAccount.setPersonList(this);

        this.pollAccount.add(pollAccount);
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, this.pollAccount.size(), null, pollAccount);
    }

    @Override
    public void addAllPollAccount(List<PollAccount> pollAccount) {
        if (pollAccount == null) {
            return;
        }
        for (PollAccount item : pollAccount) {
            addPollAccount(item);
        }
    }

    @Override
    public void setPollAccount(List<PollAccount> pollAccount) {
        // Copy elements to keep data for fire with new reference
        List<PollAccount> oldValue = this.pollAccount != null ? new ArrayList<PollAccount>(this.pollAccount) : null;
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
        this.pollAccount = pollAccount;
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
    }

    @Override
    public void removePollAccount(PollAccount pollAccount) {
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, pollAccount, null);
        if (this.pollAccount == null || !this.pollAccount.remove(pollAccount)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        pollAccount.setPersonList(null);

        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, this.pollAccount.size() + 1, pollAccount, null);
    }

    @Override
    public void clearPollAccount() {
        if (this.pollAccount == null) {
            return;
        }
        for (PollAccount item : this.pollAccount) {
            item.setPersonList(null);
        }
        List<PollAccount> oldValue = new ArrayList<PollAccount>(this.pollAccount);
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, oldValue, this.pollAccount);
        this.pollAccount.clear();
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, oldValue, this.pollAccount);
    }

    @Override
    public List<PollAccount> getPollAccount() {
        return pollAccount;
    }

    @Override
    public PollAccount getPollAccountByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(pollAccount, topiaId);
    }

    @Override
    public int sizePollAccount() {
        if (pollAccount == null) {
            return 0;
        }
        return pollAccount.size();
    }

    @Override
    public boolean isPollAccountEmpty() {
        int size = sizePollAccount();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //PersonListAbstract
