/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataPollAccountConverter;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;

public class ServicePollAccountImpl
implements ServicePollAccount {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private PollAccountDAO pollAccountDAO = null;
    private DataPollAccountConverter converter = new DataPollAccountConverter();
    private static final Log log = LogFactory.getLog(ServicePollAccountImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createPollAccount(PollAccountDTO pollAccountDTO) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
            PollAccount pollAccountEntity = (PollAccount)this.pollAccountDAO.create(new Object[0]);
            String id = UUID.randomUUID().toString();
            pollAccountDTO.setAccountId(id.replaceAll("-", ""));
            this.converter.setTransaction(transaction);
            this.converter.populatePollAccountEntity(pollAccountDTO, pollAccountEntity);
            String topiaId = pollAccountEntity.getTopiaId();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            String string = topiaId;
            return string;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            String string = null;
            return string;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollAccount createPollAccount(String votingId, String email, String userId) {
        TopiaContext transaction = null;
        PollAccount pollAccountEntity = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
            pollAccountEntity = (PollAccount)this.pollAccountDAO.create(new Object[0]);
            String id = UUID.randomUUID().toString();
            pollAccountEntity.setAccountId(id.replaceAll("-", ""));
            this.converter.setTransaction(transaction);
            this.converter.populatePollAccountEntity(votingId, email, userId, pollAccountEntity);
            String topiaId = pollAccountEntity.getTopiaId();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            PollAccount pollAccount = pollAccountEntity;
            return pollAccount;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            PollAccount pollAccount = null;
            return pollAccount;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    @Override
    public List<PollAccount> createPollAccounts(List<PollAccountDTO> pollAccounts, TopiaContext transaction) {
        if (pollAccounts.isEmpty()) {
            return null;
        }
        ArrayList<PollAccount> result = null;
        try {
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
            this.converter.setTransaction(transaction);
            result = new ArrayList<PollAccount>();
            for (PollAccountDTO pollAccount : pollAccounts) {
                PollAccount entity = (PollAccount)this.pollAccountDAO.create(new Object[0]);
                String id = UUID.randomUUID().toString();
                pollAccount.setAccountId(id.replaceAll("-", ""));
                pollAccount.setId(entity.getTopiaId());
                this.converter.populatePollAccountEntity(pollAccount, entity);
                result.add(entity);
            }
            return result;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePollAccount(String pollAccountId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
            PollAccount pollAccountEntity = (PollAccount)this.pollAccountDAO.findByTopiaId(pollAccountId);
            this.pollAccountDAO.delete(pollAccountEntity);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + pollAccountId));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePollAccount(PollAccountDTO pollAccountDTO) {
        TopiaContext transaction = null;
        boolean resu = false;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
            PollAccount pollAccountEntity = (PollAccount)this.pollAccountDAO.findByTopiaId(pollAccountDTO.getId());
            if (pollAccountEntity != null) {
                this.converter.setTransaction(transaction);
                this.converter.populatePollAccountEntity(pollAccountDTO, pollAccountEntity);
                this.pollAccountDAO.update(pollAccountEntity);
                transaction.commitTransaction();
                resu = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + pollAccountDTO.getId()));
            }
            boolean bl = resu;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollAccountDTO findPollAccountById(String pollAccountId) {
        TopiaContext transaction = null;
        PollAccountDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
            PollAccount pollAccountEntity = (PollAccount)this.pollAccountDAO.findByTopiaId(pollAccountId);
            if (pollAccountEntity != null) {
                this.converter.setTransaction(transaction);
                result = this.converter.createPollAccountDTO(pollAccountEntity);
            }
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            PollAccountDTO pollAccountDTO = result;
            return pollAccountDTO;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            PollAccountDTO pollAccountDTO = null;
            return pollAccountDTO;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollAccountDTO findPollAccountByAccountId(String pollAccountId) {
        TopiaContext transaction = null;
        PollAccountDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
            Object pollAccountEntity = this.pollAccountDAO.findByAccountId(pollAccountId);
            if (pollAccountEntity != null) {
                this.converter.setTransaction(transaction);
                result = this.converter.createPollAccountDTO((PollAccount)pollAccountEntity);
            }
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            PollAccountDTO pollAccountDTO = result;
            return pollAccountDTO;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            PollAccountDTO pollAccountDTO = null;
            return pollAccountDTO;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PollAccountDTO> findPollAccountsByUser(String userId) {
        TopiaContext transaction = null;
        List<PollAccountDTO> results = null;
        ArrayList<PollAccount> pollAccountEntities = null;
        UserAccountDAO userDAO = null;
        try {
            transaction = this.rootContext.beginTransaction();
            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount user = (UserAccount)userDAO.findByTopiaId(userId);
            pollAccountEntities = new ArrayList<PollAccount>();
            pollAccountEntities.addAll(user.getPollAccount());
            this.converter.setTransaction(transaction);
            results = this.converter.createPollAccountDTOs(pollAccountEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<PollAccountDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<PollAccountDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PollAccountDTO> selectPollAccounts(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<PollAccountDTO> results = null;
        List pollAccountEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(transaction);
            if (properties == null) {
                pollAccountEntities = this.pollAccountDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les comptes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                pollAccountEntities = this.pollAccountDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createPollAccountDTOs(pollAccountEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<PollAccountDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<PollAccountDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }
}

