/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.List;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.converters.DataVoteConverter;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAO;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.nuiton.topia.TopiaException;

public class DataPollAccountConverter
extends DataConverter {
    public void populatePollAccountEntity(PollAccountDTO pollAccountDTO, PollAccount ePollAccount) throws TopiaException {
        ePollAccount.setAccountId(pollAccountDTO.getAccountId());
        ePollAccount.setEmail(pollAccountDTO.getEmail());
        ePollAccount.setVotingId(pollAccountDTO.getVotingId());
        if (pollAccountDTO.getUserId().length() > 0) {
            UserAccountDAO userAccountDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount userAccountEntity = (UserAccount)userAccountDAO.findByTopiaId(pollAccountDTO.getUserId());
            ePollAccount.setUserAccount(userAccountEntity);
        }
        if (pollAccountDTO.getPersonListId().length() > 0) {
            PersonListDAO personListDAO = PollenModelDAOHelper.getPersonListDAO(this.transaction);
            PersonList personListEntity = (PersonList)personListDAO.findByTopiaId(pollAccountDTO.getPersonListId());
            ePollAccount.setPersonList(personListEntity);
        }
        if (ePollAccount.getVotingListPersonToList() != null) {
            for (PersonToList personToList : ePollAccount.getVotingListPersonToList()) {
                personToList.setWeight(pollAccountDTO.getWeight());
                personToList.setHasVoted(pollAccountDTO.isHasVoted());
            }
        }
    }

    public void populatePollAccountEntity(String votingId, String email, String userId, PollAccount ePollAccount) throws TopiaException {
        ePollAccount.setEmail(email);
        ePollAccount.setVotingId(votingId);
        if (userId != null && userId.length() > 0) {
            UserAccountDAO userAccountDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount userAccountEntity = (UserAccount)userAccountDAO.findByTopiaId(userId);
            ePollAccount.setUserAccount(userAccountEntity);
        }
    }

    public PollAccountDTO createPollAccountDTO(PollAccount ePollAccount) {
        PollAccountDTO dto = new PollAccountDTO();
        dto.setId(ePollAccount.getTopiaId());
        dto.setAccountId(ePollAccount.getAccountId());
        dto.setEmail(ePollAccount.getEmail());
        dto.setVotingId(ePollAccount.getVotingId());
        if (ePollAccount.getUserAccount() != null) {
            dto.setUserId(ePollAccount.getUserAccount().getTopiaId());
        }
        if (ePollAccount.getPersonList() != null) {
            dto.setPersonListId(ePollAccount.getPersonList().getTopiaId());
        }
        if (ePollAccount.getVote().size() > 0) {
            DataVoteConverter voteConverter = new DataVoteConverter();
            dto.setVoteDTOs(voteConverter.createVoteDTOs(ePollAccount.getVote()));
        }
        if (ePollAccount.getVotingListPersonToList() != null) {
            for (PersonToList personToList : ePollAccount.getVotingListPersonToList()) {
                dto.setWeight(personToList.getWeight());
                dto.setHasVoted(personToList.getHasVoted());
            }
        }
        return dto;
    }

    public List<PollAccountDTO> createPollAccountDTOs(List<PollAccount> lPollAccounts) {
        ArrayList<PollAccountDTO> results = new ArrayList<PollAccountDTO>();
        for (PollAccount p : lPollAccounts) {
            PollAccountDTO dto = this.createPollAccountDTO(p);
            results.add(dto);
        }
        return results;
    }
}

