/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import java.util.List;
import java.util.Map;

import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.persistence.Choice;
import org.nuiton.topia.TopiaContext;

/**
 * Interface de gestion des choix
 *
 * @author enema
 * @version $Id: ServiceChoice.java 2649 2009-07-15 16:30:23Z nrannou $
 */
public interface ServiceChoice {

    /**
     * Création d'un choix
     *
     * @param choice le dto choix
     * @return l'identifiant du choix
     */
    public String createChoice(ChoiceDTO choice);

    /**
     * Création des choix du sondage
     *
     * @param choices les dtos choix
     * @param pollId l'identifiant du sondage
     * @param transaction la transaction du sondage
     * @return les choix créés
     */
    public List<Choice> createChoices(List<ChoiceDTO> choices, String pollId,
            TopiaContext transaction);

    /**
     * Mise à jour d'un choix pour un sondage
     *
     * @param choiceDTO
     * @return true si le choix a été mise à jours
     */
    public boolean updateChoice(ChoiceDTO choiceDTO);

    /**
     * Suppression d'un choix de sondage
     *
     * @param choiceId l'identifiant du choix
     * @return true si le choix a été mis à jours
     */
    public boolean deleteChoice(String choiceId);

    /**
     * Recherche d'un choix par son identifiant
     *
     * @param choiceId l'identifiant du choix
     * @return le choix
     */
    public ChoiceDTO findChoiceById(String choiceId);

    /**
     * Recherche de choix d'un sondage à partir du nom
     *
     * @param choiceName le nom du choix
     * @param pollId l'identifiant du sondage
     * @return les choix
     */
    public List<ChoiceDTO> findChoicesByName(String choiceName, String pollId);

    /**
     * Recherche de tous les choix d'un sondage
     *
     * @param properties filtre sur les champs de la table choix
     * @return les choix du sondage
     */
    public List<ChoiceDTO> selectChoices(Map<String, Object> properties);
}
