/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité PersonList.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class PersonListDAOAbstract<E extends PersonList> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)PersonList.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.pollen.business.persistence.PollAccount> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.PollAccount.class)
                            .findAllByProperties("personList", entity);
                    for (org.chorem.pollen.business.persistence.PollAccount item : list) {
                        item.setPersonList(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut name
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return un element ou null
     */
    public E findByName(java.lang.String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return une liste
     */
    public List<E> findAllByName(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }
    /**
     * Recherche sur l'attribut owner
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * owner le paramètre
     * @param v la valeur que doit avoir owner
     * @return un element ou null
     */
    public E findByOwner(org.chorem.pollen.business.persistence.UserAccount v) throws TopiaException {
        E result = findByProperty("owner", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * owner le paramètre
     * @param v la valeur que doit avoir owner
     * @return une liste
     */
    public List<E> findAllByOwner(org.chorem.pollen.business.persistence.UserAccount v) throws TopiaException {
        List<E> result = findAllByProperty("owner", v);
        return result;
    }
    /**
     * Recherche sur l'attribut pollAccount
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * pollAccount contient le paramètre
     * @param v la valeur que doit contenir pollAccount
     * @return un element ou null
     */
    public E findContainsPollAccount(org.chorem.pollen.business.persistence.PollAccount ... v) throws TopiaException {
        E result = findContainsProperties("pollAccount", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * pollAccount contient le paramètre
     * @param v la valeur que doit contenir pollAccount
     * @return une liste
     */
    public List<E> findAllContainsPollAccount(org.chorem.pollen.business.persistence.PollAccount ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("pollAccount", Arrays.asList(v));
        return results;
    }

} // PersonListDAOAbstract
