/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Poll.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class PollDAOAbstract<E extends Poll> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Poll.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.pollen.business.persistence.Vote> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Vote.class)
                            .findAllByProperties("poll", entity);
                    for (org.chorem.pollen.business.persistence.Vote item : list) {
                        item.setPoll(null);

                    }
                }
        
                {
                List<org.chorem.pollen.business.persistence.Choice> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Choice.class)
                            .findAllByProperties("poll", entity);
                    for (org.chorem.pollen.business.persistence.Choice item : list) {
                        item.setPoll(null);

                    }
                }
        
                {
                List<org.chorem.pollen.business.persistence.Result> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Result.class)
                            .findAllByProperties("poll", entity);
                    for (org.chorem.pollen.business.persistence.Result item : list) {
                        item.setPoll(null);

                    }
                }
        
                {
                List<org.chorem.pollen.business.persistence.Comment> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Comment.class)
                            .findAllByProperties("poll", entity);
                    for (org.chorem.pollen.business.persistence.Comment item : list) {
                        item.setPoll(null);

                    }
                }
        
                {
                List<org.chorem.pollen.business.persistence.PreventRule> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.PreventRule.class)
                            .findAllByProperties("poll", entity);
                    for (org.chorem.pollen.business.persistence.PreventRule item : list) {
                        item.setPoll(null);

                    }
                }
        
                {
                List<org.chorem.pollen.business.persistence.VotingList> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.VotingList.class)
                            .findAllByProperties("poll", entity);
                    for (org.chorem.pollen.business.persistence.VotingList item : list) {
                        item.setPoll(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut pollId
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * pollId le paramètre
     * @param v la valeur que doit avoir pollId
     * @return un element ou null
     */
    public E findByPollId(java.lang.String v) throws TopiaException {
        E result = findByProperty("pollId", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * pollId le paramètre
     * @param v la valeur que doit avoir pollId
     * @return une liste
     */
    public List<E> findAllByPollId(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("pollId", v);
        return result;
    }
    /**
     * Recherche sur l'attribut title
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * title le paramètre
     * @param v la valeur que doit avoir title
     * @return un element ou null
     */
    public E findByTitle(java.lang.String v) throws TopiaException {
        E result = findByProperty("title", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * title le paramètre
     * @param v la valeur que doit avoir title
     * @return une liste
     */
    public List<E> findAllByTitle(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("title", v);
        return result;
    }
    /**
     * Recherche sur l'attribut description
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return un element ou null
     */
    public E findByDescription(java.lang.String v) throws TopiaException {
        E result = findByProperty("description", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * description le paramètre
     * @param v la valeur que doit avoir description
     * @return une liste
     */
    public List<E> findAllByDescription(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("description", v);
        return result;
    }
    /**
     * Recherche sur l'attribut beginChoiceDate
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * beginChoiceDate le paramètre
     * @param v la valeur que doit avoir beginChoiceDate
     * @return un element ou null
     */
    public E findByBeginChoiceDate(java.util.Date v) throws TopiaException {
        E result = findByProperty("beginChoiceDate", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * beginChoiceDate le paramètre
     * @param v la valeur que doit avoir beginChoiceDate
     * @return une liste
     */
    public List<E> findAllByBeginChoiceDate(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("beginChoiceDate", v);
        return result;
    }
    /**
     * Recherche sur l'attribut beginDate
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * beginDate le paramètre
     * @param v la valeur que doit avoir beginDate
     * @return un element ou null
     */
    public E findByBeginDate(java.util.Date v) throws TopiaException {
        E result = findByProperty("beginDate", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * beginDate le paramètre
     * @param v la valeur que doit avoir beginDate
     * @return une liste
     */
    public List<E> findAllByBeginDate(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("beginDate", v);
        return result;
    }
    /**
     * Recherche sur l'attribut endDate
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * endDate le paramètre
     * @param v la valeur que doit avoir endDate
     * @return un element ou null
     */
    public E findByEndDate(java.util.Date v) throws TopiaException {
        E result = findByProperty("endDate", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * endDate le paramètre
     * @param v la valeur que doit avoir endDate
     * @return une liste
     */
    public List<E> findAllByEndDate(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("endDate", v);
        return result;
    }
    /**
     * Recherche sur l'attribut maxChoiceNb
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * maxChoiceNb le paramètre
     * @param v la valeur que doit avoir maxChoiceNb
     * @return un element ou null
     */
    public E findByMaxChoiceNb(int v) throws TopiaException {
        E result = findByProperty("maxChoiceNb", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * maxChoiceNb le paramètre
     * @param v la valeur que doit avoir maxChoiceNb
     * @return une liste
     */
    public List<E> findAllByMaxChoiceNb(int v) throws TopiaException {
        List<E> result = findAllByProperty("maxChoiceNb", v);
        return result;
    }
    /**
     * Recherche sur l'attribut closed
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * closed le paramètre
     * @param v la valeur que doit avoir closed
     * @return un element ou null
     */
    public E findByClosed(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("closed", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * closed le paramètre
     * @param v la valeur que doit avoir closed
     * @return une liste
     */
    public List<E> findAllByClosed(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("closed", v);
        return result;
    }
    /**
     * Recherche sur l'attribut choiceAddAllowed
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * choiceAddAllowed le paramètre
     * @param v la valeur que doit avoir choiceAddAllowed
     * @return un element ou null
     */
    public E findByChoiceAddAllowed(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("choiceAddAllowed", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * choiceAddAllowed le paramètre
     * @param v la valeur que doit avoir choiceAddAllowed
     * @return une liste
     */
    public List<E> findAllByChoiceAddAllowed(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("choiceAddAllowed", v);
        return result;
    }
    /**
     * Recherche sur l'attribut anonymousVoteAllowed
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * anonymousVoteAllowed le paramètre
     * @param v la valeur que doit avoir anonymousVoteAllowed
     * @return un element ou null
     */
    public E findByAnonymousVoteAllowed(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("anonymousVoteAllowed", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * anonymousVoteAllowed le paramètre
     * @param v la valeur que doit avoir anonymousVoteAllowed
     * @return une liste
     */
    public List<E> findAllByAnonymousVoteAllowed(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("anonymousVoteAllowed", v);
        return result;
    }
    /**
     * Recherche sur l'attribut anonymous
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * anonymous le paramètre
     * @param v la valeur que doit avoir anonymous
     * @return un element ou null
     */
    public E findByAnonymous(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("anonymous", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * anonymous le paramètre
     * @param v la valeur que doit avoir anonymous
     * @return une liste
     */
    public List<E> findAllByAnonymous(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("anonymous", v);
        return result;
    }
    /**
     * Recherche sur l'attribut publicResults
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * publicResults le paramètre
     * @param v la valeur que doit avoir publicResults
     * @return un element ou null
     */
    public E findByPublicResults(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("publicResults", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * publicResults le paramètre
     * @param v la valeur que doit avoir publicResults
     * @return une liste
     */
    public List<E> findAllByPublicResults(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("publicResults", v);
        return result;
    }
    /**
     * Recherche sur l'attribut continuousResults
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * continuousResults le paramètre
     * @param v la valeur que doit avoir continuousResults
     * @return un element ou null
     */
    public E findByContinuousResults(java.lang.Boolean v) throws TopiaException {
        E result = findByProperty("continuousResults", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * continuousResults le paramètre
     * @param v la valeur que doit avoir continuousResults
     * @return une liste
     */
    public List<E> findAllByContinuousResults(java.lang.Boolean v) throws TopiaException {
        List<E> result = findAllByProperty("continuousResults", v);
        return result;
    }
    /**
     * Recherche sur l'attribut vote
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * vote contient le paramètre
     * @param v la valeur que doit contenir vote
     * @return un element ou null
     */
    public E findContainsVote(org.chorem.pollen.business.persistence.Vote ... v) throws TopiaException {
        E result = findContainsProperties("vote", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * vote contient le paramètre
     * @param v la valeur que doit contenir vote
     * @return une liste
     */
    public List<E> findAllContainsVote(org.chorem.pollen.business.persistence.Vote ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("vote", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut choice
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * choice contient le paramètre
     * @param v la valeur que doit contenir choice
     * @return un element ou null
     */
    public E findContainsChoice(org.chorem.pollen.business.persistence.Choice ... v) throws TopiaException {
        E result = findContainsProperties("choice", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * choice contient le paramètre
     * @param v la valeur que doit contenir choice
     * @return une liste
     */
    public List<E> findAllContainsChoice(org.chorem.pollen.business.persistence.Choice ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("choice", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut result
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * result contient le paramètre
     * @param v la valeur que doit contenir result
     * @return un element ou null
     */
    public E findContainsResult(org.chorem.pollen.business.persistence.Result ... v) throws TopiaException {
        E result = findContainsProperties("result", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * result contient le paramètre
     * @param v la valeur que doit contenir result
     * @return une liste
     */
    public List<E> findAllContainsResult(org.chorem.pollen.business.persistence.Result ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("result", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut creator
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * creator le paramètre
     * @param v la valeur que doit avoir creator
     * @return un element ou null
     */
    public E findByCreator(org.chorem.pollen.business.persistence.PollAccount v) throws TopiaException {
        E result = findByProperty("creator", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * creator le paramètre
     * @param v la valeur que doit avoir creator
     * @return une liste
     */
    public List<E> findAllByCreator(org.chorem.pollen.business.persistence.PollAccount v) throws TopiaException {
        List<E> result = findAllByProperty("creator", v);
        return result;
    }
    /**
     * Recherche sur l'attribut comment
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * comment contient le paramètre
     * @param v la valeur que doit contenir comment
     * @return un element ou null
     */
    public E findContainsComment(org.chorem.pollen.business.persistence.Comment ... v) throws TopiaException {
        E result = findContainsProperties("comment", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * comment contient le paramètre
     * @param v la valeur que doit contenir comment
     * @return une liste
     */
    public List<E> findAllContainsComment(org.chorem.pollen.business.persistence.Comment ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("comment", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut preventRule
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * preventRule contient le paramètre
     * @param v la valeur que doit contenir preventRule
     * @return un element ou null
     */
    public E findContainsPreventRule(org.chorem.pollen.business.persistence.PreventRule ... v) throws TopiaException {
        E result = findContainsProperties("preventRule", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * preventRule contient le paramètre
     * @param v la valeur que doit contenir preventRule
     * @return une liste
     */
    public List<E> findAllContainsPreventRule(org.chorem.pollen.business.persistence.PreventRule ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("preventRule", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut votingList
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * votingList contient le paramètre
     * @param v la valeur que doit contenir votingList
     * @return un element ou null
     */
    public E findContainsVotingList(org.chorem.pollen.business.persistence.VotingList ... v) throws TopiaException {
        E result = findContainsProperties("votingList", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * votingList contient le paramètre
     * @param v la valeur que doit contenir votingList
     * @return une liste
     */
    public List<E> findAllContainsVotingList(org.chorem.pollen.business.persistence.VotingList ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("votingList", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut pollType
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * pollType le paramètre
     * @param v la valeur que doit avoir pollType
     * @return un element ou null
     */
    public E findByPollType(org.chorem.pollen.business.persistence.PollType v) throws TopiaException {
        E result = findByProperty("pollType", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * pollType le paramètre
     * @param v la valeur que doit avoir pollType
     * @return une liste
     */
    public List<E> findAllByPollType(org.chorem.pollen.business.persistence.PollType v) throws TopiaException {
        List<E> result = findAllByProperty("pollType", v);
        return result;
    }
    /**
     * Recherche sur l'attribut choiceType
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * choiceType le paramètre
     * @param v la valeur que doit avoir choiceType
     * @return un element ou null
     */
    public E findByChoiceType(org.chorem.pollen.business.persistence.ChoiceType v) throws TopiaException {
        E result = findByProperty("choiceType", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * choiceType le paramètre
     * @param v la valeur que doit avoir choiceType
     * @return une liste
     */
    public List<E> findAllByChoiceType(org.chorem.pollen.business.persistence.ChoiceType v) throws TopiaException {
        List<E> result = findAllByProperty("choiceType", v);
        return result;
    }
    /**
     * Recherche sur l'attribut voteCounting
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * voteCounting le paramètre
     * @param v la valeur que doit avoir voteCounting
     * @return un element ou null
     */
    public E findByVoteCounting(org.chorem.pollen.business.persistence.VoteCounting v) throws TopiaException {
        E result = findByProperty("voteCounting", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * voteCounting le paramètre
     * @param v la valeur que doit avoir voteCounting
     * @return une liste
     */
    public List<E> findAllByVoteCounting(org.chorem.pollen.business.persistence.VoteCounting v) throws TopiaException {
        List<E> result = findAllByProperty("voteCounting", v);
        return result;
    }

} // PollDAOAbstract
