/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.List;

import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.persistence.Poll;
import org.nuiton.topia.TopiaException;

/**
 * Gestion de la conversion des dtos Poll en entité et vice-versa.
 *
 * @author enema
 * @version $Id: DataPollConverter.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class DataPollConverter extends DataConverter {
    DataChoiceConverter choiceConverter = new DataChoiceConverter();
    DataVoteConverter voteConverter = new DataVoteConverter();
    DataCommentConverter commentConverter = new DataCommentConverter();
    DataPreventRuleConverter preventRuleConverter = new DataPreventRuleConverter();
    DataVotingListConverter votingListConverter = new DataVotingListConverter();

    /**
     * Création d'un sondage à partir d'un dto sondage.
     *
     * @param pollDTO le dto sondage
     * @param ePoll l'entité sondage
     */
    public void populatePollEntity(PollDTO pollDTO, Poll ePoll)
            throws TopiaException {
        ePoll.setPollId(pollDTO.getPollId());
        ePoll.setTitle(pollDTO.getTitle());
        ePoll.setDescription(pollDTO.getDescription());
        ePoll.setBeginChoiceDate(pollDTO.getBeginChoiceDate());
        ePoll.setBeginDate(pollDTO.getBeginDate());
        ePoll.setEndDate(pollDTO.getEndDate());
        ePoll.setClosed(pollDTO.isClosed());
        ePoll.setAnonymous(pollDTO.isAnonymous());
        ePoll.setAnonymousVoteAllowed(pollDTO.isAnonymousVoteAllowed());
        ePoll.setPublicResults(pollDTO.isPublicResults());
        ePoll.setContinuousResults(pollDTO.isContinuousResults());
        ePoll.setChoiceAddAllowed(pollDTO.isChoiceAddAllowed());
        ePoll.setMaxChoiceNb(pollDTO.getMaxChoiceNb());

        EnumController enumCtrl = new EnumController(super.transaction);
        enumCtrl.setChoiceType(pollDTO.getChoiceType(), ePoll);
        enumCtrl.setPollType(pollDTO.getPollType(), ePoll);
        enumCtrl.setVoteCounting(pollDTO.getVoteCounting(), ePoll);

        /*if (pollDTO.getCreatorId().length() > 0) {
            PollAccountDAO pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(super.transaction);
            PollAccount PollAccountEntity = pollAccountDAO.findByTopiaId(pollDTO.getCreatorId());
            ePoll.setCreator(PollAccountEntity);
        }*/
    }

    /**
     * Création d'un dto sondage à partir d'une entité.
     *
     * @param ePoll l'entité sondage
     * @return le dto sondage
     */
    public PollDTO createPollDTO(Poll ePoll) {
        PollDTO pollDTO = new PollDTO();
        pollDTO.setId(ePoll.getTopiaId());
        pollDTO.setPollId(ePoll.getPollId());
        pollDTO.setTitle(ePoll.getTitle());
        pollDTO.setDescription(ePoll.getDescription());
        pollDTO.setBeginChoiceDate(ePoll.getBeginChoiceDate());
        pollDTO.setBeginDate(ePoll.getBeginDate());
        pollDTO.setEndDate(ePoll.getEndDate());
        pollDTO.setAnonymous(ePoll.getAnonymous());
        pollDTO.setAnonymousVoteAllowed(ePoll.getAnonymousVoteAllowed());
        pollDTO.setPublicResults(ePoll.getPublicResults());
        pollDTO.setContinuousResults(ePoll.getContinuousResults());
        pollDTO.setChoiceAddAllowed(ePoll.getChoiceAddAllowed());
        pollDTO.setClosed(ePoll.getClosed());
        pollDTO.setMaxChoiceNb(ePoll.getMaxChoiceNb());
        pollDTO.setChoiceType(EnumController.getChoiceType(ePoll));
        pollDTO.setPollType(EnumController.getPollType(ePoll));
        pollDTO.setVoteCounting(EnumController.getVoteCountingType(ePoll));

        if (ePoll.getCreator() != null) {
            pollDTO.setCreatorId(ePoll.getCreator().getTopiaId());
            pollDTO.setCreatorEmail(ePoll.getCreator().getEmail());
        }
        if (ePoll.getChoice().size() > 0) {
            pollDTO.setChoiceDTOs(choiceConverter.createChoiceDTOs(ePoll
                    .getChoice()));
        }
        if (ePoll.getVote().size() > 0) {
            pollDTO.setVoteDTOs(voteConverter.createVoteDTOs(ePoll.getVote()));
        }
        if (ePoll.getComment().size() > 0) {
            pollDTO.setCommentDTOs(commentConverter.createCommentDTOs(ePoll
                    .getComment()));
        }
        if (ePoll.getPreventRule().size() > 0) {
            pollDTO.setPreventRuleDTOs(preventRuleConverter
                    .createPreventRuleDTOs(ePoll.getPreventRule()));
        }
        if (ePoll.getVotingList().size() > 0) {
            pollDTO.setVotingListDTOs(votingListConverter
                    .createVotingListDTOs(ePoll.getVotingList()));
        }

        return pollDTO;
    }

    /**
     * Retourne une liste de dtos sondage à partir d'une liste d'entités.
     *
     * @param lPolls liste de entités sondages
     * @return la liste des dtos sondages
     */
    public List<PollDTO> createPollDTOs(List<Poll> lPolls) {
        ArrayList<PollDTO> results = new ArrayList<PollDTO>();
        PollDTO dto;
        for (Poll p : lPolls) {
            dto = this.createPollDTO(p);
            results.add(dto);
        }
        return results;
    }
}
