/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.web.action;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaTechnicalException;
import org.chorem.lima.beans.DocumentReport;
import org.chorem.lima.business.LimaServiceConfig;
import org.chorem.lima.business.utils.DocumentReportTypes;
import org.chorem.lima.business.utils.DocumentsEnum;

public class ReportBuilder {
    private static final Log log = LogFactory.getLog(ReportBuilder.class);
    protected JasperReport balanceDocumentReport;
    protected JasperReport balanceManAccountsReport;
    protected JasperReport balanceSubAccountsReport;
    protected JasperReport entryBookDocumentReport;
    protected JasperReport entryBookEntryBooksReport;
    protected JasperReport entryBookFinancialPeriodsReport;
    protected JasperReport entryBookTransactionsReport;
    protected JasperReport generalEntryBookDocumentReport;
    protected JasperReport generalEntryBookGeneralEntryBooksReport;
    protected JasperReport generalEntryBookEntriesReport;
    protected JasperReport generalLedgerDocumentReport;
    protected JasperReport generalLedgerGeneralLedgersReport;
    protected JasperReport generalLedgerEntriesReport;
    protected Map<DocumentsEnum, JasperReport> reportsByDocumentType;

    public ReportBuilder() {
        LimaServiceConfig config = LimaServiceConfig.getInstance();
        this.balanceDocumentReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.BALANCE));
        this.balanceManAccountsReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.BALANCE_MAIN_ACCOUNTS));
        this.balanceSubAccountsReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.BALANCE_SUB_ACCOUNTS));
        this.entryBookDocumentReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.ENTRY_BOOKS));
        this.entryBookEntryBooksReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.ENTRY_BOOKS_ENTRY_BOOKS));
        this.entryBookFinancialPeriodsReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.ENTRY_BOOKS_FINANCIAL_PERIODS));
        this.entryBookTransactionsReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.ENTRY_BOOKS_TRANSACTION));
        this.generalEntryBookDocumentReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.GENERAL_ENTRY_BOOK));
        this.generalEntryBookGeneralEntryBooksReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.GENERAL_ENTRY_BOOK_GENERAL_ENTRY_BOOKS));
        this.generalEntryBookEntriesReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.GENERAL_ENTRY_BOOK_ENTRIES));
        this.generalLedgerDocumentReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.LEDGER));
        this.generalLedgerGeneralLedgersReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.LEDGER_GENERAL_LEDGERS));
        this.generalLedgerEntriesReport = this.createReport(config.getReportModelUrl(DocumentReportTypes.LEDGER_ENTRIES));
        this.reportsByDocumentType = Maps.newHashMap();
        this.reportsByDocumentType.put(DocumentsEnum.BALANCE, this.balanceDocumentReport);
        this.reportsByDocumentType.put(DocumentsEnum.GENERAL_ENTRY_BOOK, this.generalEntryBookDocumentReport);
        this.reportsByDocumentType.put(DocumentsEnum.ENTRY_BOOKS, this.entryBookDocumentReport);
        this.reportsByDocumentType.put(DocumentsEnum.LEDGER, this.generalLedgerDocumentReport);
    }

    protected JasperReport createReport(URL url) {
        JasperReport jasperReport;
        try (InputStream inputStream = url.openStream();){
            jasperReport = JasperCompileManager.compileReport((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new LimaTechnicalException("Could not close inputStream for " + url, (Throwable)e);
        }
        catch (JRException e) {
            throw new LimaTechnicalException("Could not compile jaspert report for " + url, (Throwable)e);
        }
        return jasperReport;
    }

    public void generatePDFReport(DocumentsEnum reportType, String path, List<DocumentReport> reports) {
        block4: {
            try {
                JasperReport report = this.reportsByDocumentType.get(reportType);
                if (report != null) {
                    JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, new HashMap(), (JRDataSource)new JRBeanCollectionDataSource(reports));
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)path);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Rapport g\u00e9n\u00e9r\u00e9:" + path));
                    }
                    break block4;
                }
                throw new LimaTechnicalException("JasperReport not found for " + reportType);
            }
            catch (JRException e) {
                throw new LimaTechnicalException((Throwable)e);
            }
        }
    }

    public JasperReport getBalanceManAccountsReport() {
        return this.balanceManAccountsReport;
    }

    public JasperReport getBalanceSubAccountsReport() {
        return this.balanceSubAccountsReport;
    }

    public JasperReport getEntryBookEntryBooksReport() {
        return this.entryBookEntryBooksReport;
    }

    public JasperReport getEntryBookFinancialPeriodsReport() {
        return this.entryBookFinancialPeriodsReport;
    }

    public JasperReport getEntryBookTransactionsReport() {
        return this.entryBookTransactionsReport;
    }

    public JasperReport getGeneralEntryBookGeneralEntryBooksReport() {
        return this.generalEntryBookGeneralEntryBooksReport;
    }

    public JasperReport getGeneralEntryBookEntriesReport() {
        return this.generalEntryBookEntriesReport;
    }

    public JasperReport getGeneralLedgerGeneralLedgersReport() {
        return this.generalLedgerGeneralLedgersReport;
    }

    public JasperReport getGeneralLedgerEntriesReport() {
        return this.generalLedgerEntriesReport;
    }

    public Map<DocumentsEnum, JasperReport> getReportsByDocumentType() {
        return this.reportsByDocumentType;
    }
}

